/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.compaction.recthull;

import java.util.Objects;
import org.eclipse.elk.core.math.KVector;

public class Point {
    public double x;
    public double y;
    public Quadrant quadrant;
    public boolean convex = true;

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Point(double x, double y, Quadrant quadrant) {
        this(x, y);
        this.quadrant = quadrant;
    }

    public static Point from(KVector v) {
        return new Point(v.x, v.y);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + (this.convex ? "cx" : "") + (Object)((Object)this.quadrant) + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point p2 = (Point)obj;
        return Objects.equals(this.x, p2.x) && Objects.equals(this.y, p2.y);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public static enum Quadrant {
        Q1,
        Q4,
        Q2,
        Q3;


        public boolean isUpper() {
            return this == Q1 || this == Q2;
        }

        public boolean isLeft() {
            return this == Q1 || this == Q4;
        }

        public static boolean isBothLeftOrBothRight(Quadrant q1, Quadrant q2) {
            return q1 == Q1 && q2 == Q4 || q1 == Q4 && q2 == Q1 || q1 == Q3 && q2 == Q2 || q1 == Q2 && q2 == Q3;
        }

        public static boolean isOneLeftOneRight(Quadrant q1, Quadrant q2) {
            return q1 == Q1 && q2 == Q2 || q1 == Q1 && q2 == Q3 || q1 == Q4 && q2 == Q3 || q1 == Q4 && q2 == Q2;
        }
    }
}

