/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TreeViewerRow;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.tree.ui.tools.internal.editor.listeners.TreeItemExpansionManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TreeItem;

public class SiriusDTreeCellNavigationStrategy
extends CellNavigationStrategy {
    private static int expandDepthLimit = 20;
    private Session session;
    private IPermissionAuthority permissionAuthority;

    public SiriusDTreeCellNavigationStrategy(Session session) {
        this.session = session;
        this.permissionAuthority = session.getModelAccessor().getPermissionAuthority();
    }

    public static void setExpandDepthLimit(int depth) {
        expandDepthLimit = depth;
    }

    public void collapse(ColumnViewer viewer, ViewerCell cellToCollapse, Event event) {
        if (cellToCollapse != null && cellToCollapse.getItem() instanceof TreeItem) {
            Control control = viewer.getControl();
            control.setRedraw(false);
            try {
                TreeItem currentTreeItem = (TreeItem)cellToCollapse.getItem();
                if ((event.stateMask & SWT.MOD2) != 0) {
                    ArrayList<TreeItem> subItems = new ArrayList<TreeItem>();
                    this.collectSubItems(currentTreeItem, subItems);
                    TreeItemExpansionManager.handleTreeCollapse(event, subItems, this.session, this.permissionAuthority);
                } else {
                    TreeItemExpansionManager.handleTreeCollapse(event, Optional.of(currentTreeItem), this.session, this.permissionAuthority);
                }
            }
            finally {
                control.setRedraw(true);
            }
        }
    }

    private void collectSubItems(TreeItem currentTreeItem, List<TreeItem> subItems) {
        int i = 0;
        while (i < currentTreeItem.getItemCount()) {
            this.collectSubItems(currentTreeItem.getItem(i), subItems);
            ++i;
        }
        subItems.add(currentTreeItem);
    }

    public void expand(ColumnViewer viewer, ViewerCell cellToExpand, Event event) {
        if (cellToExpand != null && cellToExpand.getItem() instanceof TreeItem) {
            Control control = viewer.getControl();
            control.setRedraw(false);
            try {
                TreeItem currentTreeItem = (TreeItem)cellToExpand.getItem();
                TreeItemExpansionManager.handleTreeExpand(event, Optional.of(currentTreeItem), this.session, this.permissionAuthority, (event.stateMask & SWT.MOD2) != 0, expandDepthLimit);
            }
            finally {
                control.setRedraw(true);
            }
        }
    }

    public boolean isCollapseEvent(ColumnViewer viewer, ViewerCell cellToCollapse, Event event) {
        return cellToCollapse != null && ((TreeItem)cellToCollapse.getItem()).getExpanded() && event.keyCode == 0x1000003 && this.isFirstColumnCell(cellToCollapse);
    }

    public boolean isExpandEvent(ColumnViewer viewer, ViewerCell cellToExpand, Event event) {
        boolean result;
        boolean bl = result = cellToExpand != null && ((TreeItem)cellToExpand.getItem()).getItemCount() > 0;
        if (result) {
            boolean bl2 = result = !((TreeItem)cellToExpand.getItem()).getExpanded() || (event.stateMask & SWT.MOD2) != 0;
            if (result) {
                result = event.keyCode == 0x1000004 && this.isFirstColumnCell(cellToExpand);
            }
        }
        return result;
    }

    private boolean isFirstColumnCell(ViewerCell cell) {
        if (cell.getViewerRow() instanceof TreeViewerRow) {
            return ((TreeViewerRow)cell.getViewerRow()).getVisualIndex(cell.getColumnIndex()) == 0;
        }
        return false;
    }
}

