/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.api.image;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.common.tools.api.resource.ImageFileFormat;
import org.eclipse.sirius.diagram.ui.business.api.image.ITreeImagesContentProvider;

public final class ImageFiltersUtils {
    public static final ImageFileFormat[] VALUES = new ImageFileFormat[]{ImageFileFormat.JPEG, ImageFileFormat.JPG, ImageFileFormat.SVG, ImageFileFormat.PNG};
    private static final List<String> IMAGE_FILE_EXTENSIONS = new ArrayList<String>();

    static {
        ImageFileFormat[] imageFileFormatArray = VALUES;
        int n = VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFileFormat imageFileFormat = imageFileFormatArray[n2];
            IMAGE_FILE_EXTENSIONS.add(imageFileFormat.getName().toLowerCase());
            ++n2;
        }
    }

    private ImageFiltersUtils() {
    }

    public static List<String> imageFileExtensionsList() {
        return IMAGE_FILE_EXTENSIONS;
    }

    public static ViewerFilter createFileExtensionFilter() {
        return new FileExtensionFilter();
    }

    public static ViewerFilter createImageFileFilter() {
        return new ImageFileFilter();
    }

    public static boolean isSupportedImageFile(String imageName) {
        String extension = ImageFiltersUtils.getExtension(imageName);
        if (!extension.isEmpty()) {
            extension = extension.toLowerCase();
            for (String imageExtension : IMAGE_FILE_EXTENSIONS) {
                if (!extension.equals(imageExtension)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getExtension(String fileName) {
        String extension = "";
        if (fileName != null) {
            int index = fileName.lastIndexOf(46);
            if (index == -1 || index == fileName.length() - 1) {
                return extension;
            }
            extension = fileName.substring(index + 1);
        }
        return extension;
    }

    static class FileExtensionFilter
    extends ViewerFilter {
        FileExtensionFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            ContentViewer contentViewer;
            boolean isValid = false;
            if (viewer instanceof ContentViewer && (contentViewer = (ContentViewer)viewer).getContentProvider() instanceof ITreeImagesContentProvider && contentViewer.getLabelProvider() instanceof ILabelProvider) {
                ITreeImagesContentProvider contentProvider = (ITreeImagesContentProvider)contentViewer.getContentProvider();
                ILabelProvider labelProvider = (ILabelProvider)contentViewer.getLabelProvider();
                if (contentProvider.hasChildren(element)) {
                    isValid = true;
                    Object[] objectArray = contentProvider.getChildren(element);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        isValid = this.containsOrIsSupportedImage(child, contentProvider, labelProvider);
                        if (isValid) break;
                        ++n2;
                    }
                }
            }
            return isValid;
        }

        private boolean containsOrIsSupportedImage(Object element, ITreeImagesContentProvider contentProvider, ILabelProvider labelProvider) {
            boolean isValid = false;
            if (contentProvider.hasChildren(element)) {
                isValid = true;
                Object[] objectArray = contentProvider.getChildren(element);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    isValid = this.containsOrIsSupportedImage(child, contentProvider, labelProvider);
                    if (!isValid) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            } else {
                boolean isImage = contentProvider.isImage(element);
                if (isImage) {
                    String name = labelProvider.getText(element);
                    isValid = ImageFiltersUtils.isSupportedImageFile(name);
                }
            }
            return isValid;
        }
    }

    static class ImageFileFilter
    extends ViewerFilter {
        ImageFileFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            ContentViewer contentViewer;
            boolean isValid = false;
            if (viewer instanceof ContentViewer && (contentViewer = (ContentViewer)viewer).getContentProvider() instanceof ITreeImagesContentProvider && contentViewer.getLabelProvider() instanceof ILabelProvider) {
                ITreeImagesContentProvider contentProvider = (ITreeImagesContentProvider)contentViewer.getContentProvider();
                ILabelProvider labelProvider = (ILabelProvider)contentViewer.getLabelProvider();
                if (contentProvider.hasChildren(element)) {
                    isValid = false;
                    Object[] objectArray = contentProvider.getChildren(element);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        isValid = this.select(viewer, parentElement, child);
                        if (!isValid) {
                            ++n2;
                            continue;
                        }
                        break;
                    }
                } else {
                    boolean isImage = contentProvider.isImage(element);
                    if (isImage) {
                        String name = labelProvider.getText(element);
                        isValid = ImageFiltersUtils.isSupportedImageFile(name);
                    }
                }
            }
            return isValid;
        }
    }
}

