/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.tools.api.layout.PinHelper;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.AbstractDiagramAction;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.DiagramElementsSelectionDialog;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DDiagramEditorImpl;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class SelectPinnedElementsAction
extends AbstractDiagramAction {
    private static final String ACTION_ID = "selectPinnedElementsAction";
    private static final String ICON_PATH = "icons/pinWizard.gif";
    private static final ImageDescriptor DESC_PIN = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/pinWizard.gif");
    private static final Predicate<Object> IS_PINNED = new Predicate<Object>(){

        public boolean apply(Object input) {
            if (input instanceof DDiagramElement) {
                return new PinHelper().isPinned((DDiagramElement)input);
            }
            return false;
        }
    };
    private static final Function<Object, Void> PIN_ELEMENT = new Function<Object, Void>(){

        public Void apply(Object from) {
            if (from instanceof DDiagramElement) {
                new PinHelper().markAsPinned((DDiagramElement)from);
            }
            return null;
        }
    };
    private static final Function<Object, Void> UNPIN_ELEMENT = new Function<Object, Void>(){

        public Void apply(Object from) {
            if (from instanceof DDiagramElement) {
                new PinHelper().markAsUnpinned((DDiagramElement)from);
            }
            return null;
        }
    };

    public SelectPinnedElementsAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
        this.setText(Messages.SelectPinnedElementsAction_label);
        this.setToolTipText(Messages.SelectPinnedElementsAction_tooltip);
        this.setId(ACTION_ID);
        this.setImageDescriptor(DiagramUIPlugin.Implementation.getDecoratedCheckedImageDescriptor(DESC_PIN));
    }

    public SelectPinnedElementsAction(IWorkbenchPage workbenchPage, IWorkbenchPart part) {
        super(workbenchPage);
        this.setWorkbenchPart(part);
        this.setText(Messages.SelectPinnedElementsAction_label);
        this.setToolTipText(Messages.SelectPinnedElementsAction_tooltip);
        this.setId(ACTION_ID);
        this.setImageDescriptor(this.getImage());
    }

    private ImageDescriptor getImage() {
        EObject diagram;
        Diagram gmfDiagram;
        if (this.getWorkbenchPart() instanceof DDiagramEditorImpl && (gmfDiagram = ((DDiagramEditorImpl)this.getWorkbenchPart()).getDiagram()) != null && (diagram = gmfDiagram.getElement()) instanceof DDiagram && this.hasPinnedElements((DDiagram)diagram)) {
            return DiagramUIPlugin.Implementation.getDecoratedCheckedImageDescriptor(DESC_PIN);
        }
        return DESC_PIN;
    }

    private boolean hasPinnedElements(DDiagram dDiagram) {
        Iterator iterator = dDiagram.getDiagramElements().iterator();
        PinHelper pinHelper = new PinHelper();
        while (iterator.hasNext()) {
            DDiagramElement element = (DDiagramElement)iterator.next();
            if (!pinHelper.isPinned(element)) continue;
            return true;
        }
        return false;
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected boolean isSelectionListener() {
        return false;
    }

    private Shell getShell() {
        return this.getWorkbenchPart().getSite().getShell();
    }

    protected Command getCommand() {
        DiagramEditPart diagramEditPart;
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        if (this.getDiagramGraphicalViewer() != null && (diagramEditPart = this.getDiagramEditPart()) instanceof IDDiagramEditPart) {
            result = this.getElementsSelectionCommand((IDDiagramEditPart)diagramEditPart);
        }
        return result;
    }

    private Command getElementsSelectionCommand(IDDiagramEditPart diagramEditPart) {
        EObject semanticElement;
        UnexecutableCommand elementsSelectionCommand = UnexecutableCommand.INSTANCE;
        if (diagramEditPart.isActive() && diagramEditPart.getEditingDomain() != null && diagramEditPart.getEditingDomain().getCommandStack() != null && (semanticElement = diagramEditPart.resolveSemanticElement()) instanceof DDiagram) {
            DDiagram diagram = (DDiagram)semanticElement;
            elementsSelectionCommand = new ICommandProxy((ICommand)new PinnedElementsSelectionCommand(this.getShell(), diagramEditPart.getEditingDomain(), Messages.SelectPinnedElementsAction_label, diagram));
        }
        return elementsSelectionCommand;
    }

    private static final class PinnedElementsSelectionCommand
    extends AbstractTransactionalCommand {
        private final DDiagram diagram;
        private final Shell shell;

        private PinnedElementsSelectionCommand(Shell shell, TransactionalEditingDomain domain, String label, DDiagram diagram) {
            super(domain, label, null);
            this.shell = Objects.requireNonNull(shell);
            this.diagram = Objects.requireNonNull(diagram);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            DiagramElementsSelectionDialog dlg = new DiagramElementsSelectionDialog(Messages.SelectPinnedElementsAction_label, Messages.PinnedElementsSelectionCommand_dialogMessage);
            dlg.setSelectionPredicate(IS_PINNED);
            dlg.setSelectedAction(PIN_ELEMENT);
            dlg.setDeselectedAction(UNPIN_ELEMENT);
            dlg.setGrayedPredicate(this.getNonSelectablePredicate());
            boolean executed = dlg.open(this.shell, this.diagram, false);
            if (executed) {
                return CommandResult.newOKCommandResult();
            }
            return CommandResult.newCancelledCommandResult();
        }

        private Predicate<Object> getNonSelectablePredicate() {
            return new Predicate<Object>(){

                public boolean apply(Object input) {
                    if (input instanceof DDiagramElement) {
                        return !PinHelper.allowsPinUnpin((DDiagramElement)((DDiagramElement)input));
                    }
                    return false;
                }
            };
        }
    }
}

