/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.seconditeration;

import java.util.List;
import org.eclipse.elk.alg.rectpacking.seconditeration.Compaction;
import org.eclipse.elk.alg.rectpacking.seconditeration.InitialPlacement;
import org.eclipse.elk.alg.rectpacking.seconditeration.RectangleExpansion;
import org.eclipse.elk.alg.rectpacking.util.Block;
import org.eclipse.elk.alg.rectpacking.util.BlockStack;
import org.eclipse.elk.alg.rectpacking.util.DrawingData;
import org.eclipse.elk.alg.rectpacking.util.DrawingDataDescriptor;
import org.eclipse.elk.alg.rectpacking.util.RectRow;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;

public class RowFillingAndCompaction {
    private double drawingWidth;
    private double drawingHeight;
    private double aspectRatio;
    private boolean expandNodes;
    private boolean expandToAspectRatio;
    private boolean compaction;
    private double nodeNodeSpacing;

    public RowFillingAndCompaction(double aspectRatio, boolean expandNodes, boolean expandToAspectRatio, boolean compaction, double nodeNodeSpacing) {
        this.aspectRatio = aspectRatio;
        this.expandNodes = expandNodes;
        this.expandToAspectRatio = expandToAspectRatio;
        this.compaction = compaction;
        this.nodeNodeSpacing = nodeNodeSpacing;
    }

    public DrawingData start(List<ElkNode> rectangles, double maxWidth, KVector minParentSize, IElkProgressMonitor progressMonitor, ElkNode layoutGraph) {
        List<RectRow> rows = InitialPlacement.place(rectangles, maxWidth, this.nodeNodeSpacing);
        if (progressMonitor.isLoggingEnabled()) {
            progressMonitor.logGraph(layoutGraph, "After placement");
        }
        if (this.compaction) {
            int rowIdx = 0;
            while (rowIdx < rows.size()) {
                RectRow currentRow = rows.get(rowIdx);
                if (rowIdx != 0) {
                    RectRow previousRow = rows.get(rowIdx - 1);
                    currentRow.setY(previousRow.getY() + previousRow.getHeight());
                }
                Compaction.compact(rowIdx, rows, maxWidth, this.nodeNodeSpacing);
                this.adjustWidthAndHeight(currentRow);
                ++rowIdx;
            }
        } else {
            for (RectRow row : rows) {
                for (Block block : row.getChildren()) {
                    BlockStack stack = new BlockStack(block.getX(), block.getY());
                    stack.addBlock(block);
                    row.getStacks().add(stack);
                }
            }
        }
        this.calculateDimensions(rows);
        if (progressMonitor.isLoggingEnabled()) {
            progressMonitor.logGraph(layoutGraph, "After compaction");
        }
        double totalWidth = Math.max(this.drawingWidth, minParentSize.x);
        double minHeight = Math.max(this.drawingHeight, minParentSize.y);
        double additionalHeight = minHeight - this.drawingHeight;
        if (this.expandNodes && this.expandToAspectRatio) {
            double aspectRatio = totalWidth / minHeight;
            if (aspectRatio < this.aspectRatio) {
                totalWidth = minHeight * this.aspectRatio;
            } else {
                additionalHeight += totalWidth / this.aspectRatio - minHeight;
            }
        }
        if (this.expandNodes) {
            RectangleExpansion.expand(rows, totalWidth + this.nodeNodeSpacing, additionalHeight, this.nodeNodeSpacing);
        }
        if (progressMonitor.isLoggingEnabled()) {
            progressMonitor.logGraph(layoutGraph, "After expansion");
        }
        return new DrawingData(this.aspectRatio, totalWidth, this.drawingHeight + additionalHeight, DrawingDataDescriptor.WHOLE_DRAWING);
    }

    private void adjustWidthAndHeight(RectRow row) {
        double maxHeight = 0.0;
        double maxWidth = 0.0;
        for (BlockStack stack : row.getStacks()) {
            stack.updateDimension();
            maxHeight = Math.max(maxHeight, stack.getHeight());
            maxWidth += stack.getWidth();
        }
        row.setHeight(maxHeight);
        row.setWidth(maxWidth);
    }

    private void calculateDimensions(List<RectRow> rows) {
        double maxWidth = 0.0;
        double newHeight = 0.0;
        for (RectRow row : rows) {
            maxWidth = Math.max(maxWidth, row.getWidth());
            newHeight += row.getHeight();
        }
        this.drawingHeight = newHeight - this.nodeNodeSpacing;
        this.drawingWidth = maxWidth - this.nodeNodeSpacing;
    }
}

