/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.extender.business.api.accessor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.internal.common.AbstractProviderDescriptor;
import org.eclipse.sirius.ecore.extender.business.internal.common.ExtenderProviderDescriptor;

public final class ExtenderService {
    private static List<AbstractProviderDescriptor> extenderProviders = new ArrayList<AbstractProviderDescriptor>();
    private static final String EXTENDER_PROVIDER_EXTENSION_POINT = "org.eclipse.sirius.ecore.extender.ExtenderProvider";
    private static final String TAG_ENGINE = "extenderprovider";

    static {
        ExtenderService.parseExtensionMetadata();
    }

    private ExtenderService() {
    }

    public static ModelAccessor createModelAccessor(ResourceSet set) {
        ModelAccessor result = new ModelAccessor();
        for (ExtenderProviderDescriptor extenderProviderDescriptor : extenderProviders) {
            if (extenderProviderDescriptor.getProviderInstance() == null || !extenderProviderDescriptor.getProviderInstance().provides(set)) continue;
            result.addExtender(extenderProviderDescriptor.getProviderInstance().getExtender(set), extenderProviderDescriptor.getPriority());
        }
        return result;
    }

    private static void parseExtensionMetadata() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = Platform.getExtensionRegistry().getExtensionPoint(EXTENDER_PROVIDER_EXTENSION_POINT).getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    AbstractProviderDescriptor desc = ExtenderService.parseEngine(configElement);
                    if (desc != null) {
                        extenderProviders.add(desc);
                    }
                    ++n4;
                }
                ++n2;
            }
            Collections.sort(extenderProviders);
        }
    }

    private static AbstractProviderDescriptor parseEngine(IConfigurationElement configElement) {
        if (!configElement.getName().equals(TAG_ENGINE)) {
            return null;
        }
        ExtenderProviderDescriptor desc = new ExtenderProviderDescriptor(configElement);
        return desc;
    }
}

