/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.ui.DiagramEventBrokerThreadSafe;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionEventBroker;
import org.eclipse.sirius.business.internal.session.SessionEventBrokerImpl;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.refresh.RefreshLayoutCommand;
import org.eclipse.sirius.diagram.sequence.business.internal.refresh.RefreshLayoutScope;
import org.eclipse.sirius.diagram.sequence.business.internal.refresh.RefreshLayoutTrigger;
import org.eclipse.sirius.diagram.sequence.business.internal.refresh.SequenceCanonicalSynchronizerAdapter;
import org.eclipse.sirius.diagram.sequence.business.internal.refresh.SequenceCanonicalSynchronizerAdapterScope;
import org.eclipse.sirius.diagram.sequence.ui.business.internal.refresh.VisibilityEventHandler;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.command.SequenceEMFCommandFactory;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.ExecutionOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.SequenceEditPartsOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.InstanceRoleEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.SequenceMessageEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.SequenceContainerCreationPolicy;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.SequenceLaunchToolEditPolicy;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout.SequenceZOrderingRefresher;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.business.api.query.EditPartQuery;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.ContainerCreationEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.figures.OverlayLabelsDrawerFigure;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Display;

public class SequenceDiagramEditPart
extends DDiagramEditPart {
    private final VisibilityEventHandler semanticOrderingSynchronizer;
    private IDiagramCommandFactoryProvider previousProvider;
    private ModelChangeTrigger refreshLayout;
    private ModelChangeTrigger sequenceCanonicalSynchronizer;
    private ResourceSetListener zOrderAndInstanceRolePartRefresher = new ZOrderAndInstanceRolePartRefresher();
    private IPropertyChangeListener snapDisabler;
    private IFigure overlayLabelsDrawerFigure;

    public SequenceDiagramEditPart(View diagramView) {
        super(diagramView);
        this.semanticOrderingSynchronizer = new VisibilityEventHandler();
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        ExecutionOperations.replaceEditPolicy((IGraphicalEditPart)this, "ContainerEditPolicy", (EditPolicy)new SequenceContainerCreationPolicy(), ContainerCreationEditPolicy.class);
        this.installEditPolicy("launchTool", (EditPolicy)new SequenceLaunchToolEditPolicy());
    }

    public void addNotify() {
        SequenceEditPartsOperations.registerDiagramElement((IGraphicalEditPart)this, this.resolveSemanticElement());
        super.addNotify();
        Object property = this.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        if (property instanceof DDiagramEditor) {
            DDiagramEditor diagramEditor = (DDiagramEditor)property;
            this.setCustomCommandFactoryProvider(diagramEditor);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        SequenceEditPartsOperations.unregisterDiagramElement((IGraphicalEditPart)this, this.resolveSemanticElement());
        Object property = this.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        if (property instanceof DDiagramEditor && this.previousProvider != null) {
            DDiagramEditor diagramEditor = (DDiagramEditor)property;
            diagramEditor.setEmfCommandFactoryProvider(this.previousProvider);
            this.previousProvider = null;
        }
    }

    public void activate() {
        IFigure overlayLayer;
        IPreferenceStore workspaceViewerPreferenceStore;
        super.activate();
        EditPartViewer viewer = this.getViewer();
        if (viewer instanceof DiagramGraphicalViewer && (workspaceViewerPreferenceStore = ((DiagramGraphicalViewer)viewer).getWorkspaceViewerPreferenceStore()) != null) {
            workspaceViewerPreferenceStore.setDefault("rulergrid.snaptogrid", false);
            workspaceViewerPreferenceStore.setValue("rulergrid.snaptogrid", false);
            workspaceViewerPreferenceStore.setDefault("rulergrid.snaptogeometry", false);
            workspaceViewerPreferenceStore.setValue("rulergrid.snaptogeometry", false);
            this.snapDisabler = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getNewValue() instanceof Boolean && ((Boolean)event.getNewValue()).booleanValue()) {
                        if ("rulergrid.snaptogeometry".equals(event.getProperty())) {
                            EclipseUIUtil.displayAsyncExec((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    workspaceViewerPreferenceStore.setValue("rulergrid.snaptogeometry", Boolean.FALSE.booleanValue());
                                }
                            });
                        } else if ("rulergrid.snaptogrid".equals(event.getProperty())) {
                            EclipseUIUtil.displayAsyncExec((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    workspaceViewerPreferenceStore.setValue("rulergrid.snaptogrid", Boolean.FALSE.booleanValue());
                                }
                            });
                        }
                    }
                }
            };
            workspaceViewerPreferenceStore.addPropertyChangeListener(this.snapDisabler);
        }
        Diagram diagramView = this.getDiagramView();
        DDiagram dDiagram = (DDiagram)new EditPartQuery((IGraphicalEditPart)this).getDDiagram().get();
        boolean autoRefresh = new DRepresentationQuery((DRepresentation)dDiagram).isAutoRefresh();
        boolean refreshOnOpen = ((Session)Session.of((EObject)dDiagram).get()).getSiriusPreferences().isRefreshOnRepresentationOpening();
        this.getEditingDomain().getCommandStack().execute((Command)new RefreshLayoutCommand(this.getEditingDomain(), diagramView, autoRefresh || refreshOnOpen));
        this.getEditingDomain().addResourceSetListener((ResourceSetListener)this.semanticOrderingSynchronizer);
        this.getEditingDomain().addResourceSetListener(this.zOrderAndInstanceRolePartRefresher);
        Option<SessionEventBroker> broker = this.getSessionBroker();
        if (broker.some()) {
            SessionEventBroker sessionEventBroker = (SessionEventBroker)broker.get();
            RefreshLayoutScope refreshLayoutScope = new RefreshLayoutScope(diagramView);
            this.refreshLayout = new RefreshLayoutTrigger(diagramView);
            sessionEventBroker.addLocalTrigger(SessionEventBrokerImpl.asFilter((Predicate)refreshLayoutScope), this.refreshLayout);
            SequenceCanonicalSynchronizerAdapterScope sequenceCanonicalSynchronizerLayoutScope = new SequenceCanonicalSynchronizerAdapterScope(diagramView);
            this.sequenceCanonicalSynchronizer = new SequenceCanonicalSynchronizerAdapter();
            sessionEventBroker.addLocalTrigger(SessionEventBrokerImpl.asFilter((Predicate)sequenceCanonicalSynchronizerLayoutScope), this.sequenceCanonicalSynchronizer);
        }
        if ((overlayLayer = this.getLayer("Overlay Layer")) != null) {
            this.overlayLabelsDrawerFigure = new OverlayLabelsDrawerFigure(this.getFigure(), (IGraphicalEditPart)this);
            overlayLayer.add(this.overlayLabelsDrawerFigure);
        }
    }

    private Option<SessionEventBroker> getSessionBroker() {
        Session session;
        DDiagramEditor diagramEditor = (DDiagramEditor)this.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        if (diagramEditor != null && (session = diagramEditor.getSession()) != null && session.isOpen()) {
            return Options.newSome((Object)diagramEditor.getSession().getEventBroker());
        }
        return Options.newNone();
    }

    private void setCustomCommandFactoryProvider(DDiagramEditor diagramEditor) {
        this.previousProvider = diagramEditor.getEmfCommandFactoryProvider();
        diagramEditor.setEmfCommandFactoryProvider(new IDiagramCommandFactoryProvider(){
            private IDiagramCommandFactory commandFactory;

            public IDiagramCommandFactory getCommandFactory(TransactionalEditingDomain editingDomain) {
                if (this.commandFactory == null) {
                    this.commandFactory = new SequenceEMFCommandFactory(SequenceDiagramEditPart.this);
                }
                return this.commandFactory;
            }
        });
    }

    public void deactivate() {
        EditPartViewer viewer = this.getViewer();
        if (this.snapDisabler != null && viewer instanceof DiagramGraphicalViewer && ((DiagramGraphicalViewer)viewer).getWorkspaceViewerPreferenceStore() != null) {
            ((DiagramGraphicalViewer)viewer).getWorkspaceViewerPreferenceStore().removePropertyChangeListener(this.snapDisabler);
            this.snapDisabler = null;
        }
        IFigure overlayLayer = this.getLayer("Overlay Layer");
        if (this.overlayLabelsDrawerFigure != null && overlayLayer != null) {
            overlayLayer.remove(this.overlayLabelsDrawerFigure);
            this.overlayLabelsDrawerFigure = null;
        }
        this.getEditingDomain().removeResourceSetListener(this.zOrderAndInstanceRolePartRefresher);
        this.getEditingDomain().removeResourceSetListener((ResourceSetListener)this.semanticOrderingSynchronizer);
        Option<SessionEventBroker> broker = this.getSessionBroker();
        if (broker.some()) {
            SessionEventBroker sessionEventBroker = (SessionEventBroker)broker.get();
            sessionEventBroker.removeLocalTrigger(this.refreshLayout);
            sessionEventBroker.removeLocalTrigger(this.sequenceCanonicalSynchronizer);
        }
        super.deactivate();
    }

    public void reorderChild(EditPart child, int index) {
        super.reorderChild(child, index);
    }

    protected void refreshChildren() {
        super.refreshChildren();
        this.refreshConnectionsBendpoints();
        new SequenceZOrderingRefresher(this).run();
    }

    protected void reorderEdgesFiguresAccordingToGmfOrder() {
    }

    protected void refreshConnectionsBendpoints() {
        for (SequenceMessageEditPart connectionEditPart : Iterables.filter((Iterable)this.getConnections(), SequenceMessageEditPart.class)) {
            connectionEditPart.refreshBendpoints();
        }
    }

    public SequenceDiagram getSequenceDiagram() {
        return (SequenceDiagram)ISequenceElementAccessor.getSequenceDiagram((Diagram)this.getDiagramView()).get();
    }

    private class ZOrderAndInstanceRolePartRefresher
    extends ResourceSetListenerImpl {
        private ZOrderAndInstanceRolePartRefresher() {
        }

        public boolean isPostcommitOnly() {
            return true;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            this.refreshInstanceRoleEditPartsOnAbstractNodeEventSetBounds(event);
            new SequenceZOrderingRefresher(SequenceDiagramEditPart.this).run();
            SequenceDiagramEditPart.this.refreshConnectionsBendpoints();
        }

        private void refreshInstanceRoleEditPartsOnAbstractNodeEventSetBounds(ResourceSetChangeEvent event) {
            LinkedHashSet<View> instanceOfRoleToRefresh = new LinkedHashSet<View>();
            for (Notification notification : event.getNotifications()) {
                Option lifeline;
                Option abstractNodeEvent;
                Bounds notifier;
                EObject eContainer;
                if (notification.isTouch() || notification.getEventType() != 1 || !(notification.getNotifier() instanceof Bounds) || !((eContainer = (notifier = (Bounds)notification.getNotifier()).eContainer()) instanceof View) || !(abstractNodeEvent = ISequenceElementAccessor.getAbstractNodeEvent((View)((View)eContainer))).some() || !(lifeline = ((AbstractNodeEvent)abstractNodeEvent.get()).getLifeline()).some()) continue;
                instanceOfRoleToRefresh.add(((Lifeline)lifeline.get()).getInstanceRole().getNotationView());
            }
            if (instanceOfRoleToRefresh.isEmpty()) {
                return;
            }
            Runnable instanceRoleRefreshRunnable = () -> {
                Stream<Object> instanceRoleEditParts = SequenceDiagramEditPart.this.getChildren().stream().filter(InstanceRoleEditPart.class::isInstance).map(InstanceRoleEditPart.class::cast);
                instanceRoleEditParts.filter(part -> instanceOfRoleToRefresh.contains(part.getModel())).forEach(EditPart::refresh);
            };
            if (Display.getCurrent() != null) {
                instanceRoleRefreshRunnable.run();
            } else {
                boolean safeSynchroneRefresh = this.isDefaultSiriusDiagramEventBroker(event.getEditingDomain());
                if (safeSynchroneRefresh) {
                    DisplayUtils.getDisplay().syncExec((Runnable)event.getEditingDomain().createPrivilegedRunnable(instanceRoleRefreshRunnable));
                } else {
                    EclipseUIUtil.displayAsyncExec((Runnable)instanceRoleRefreshRunnable);
                }
            }
        }

        private boolean isDefaultSiriusDiagramEventBroker(TransactionalEditingDomain editingDomain) {
            Optional postCommitListeners;
            if (editingDomain != null && (postCommitListeners = ReflectionHelper.getFieldValueWithoutException((Object)editingDomain, (String)"postListeners")).isPresent()) {
                Optional<DiagramEventBroker> broker = ((Collection)postCommitListeners.get()).stream().filter(DiagramEventBroker.class::isInstance).findFirst().map(DiagramEventBroker.class::cast);
                return broker.isPresent() && DiagramEventBrokerThreadSafe.class.equals(broker.get().getClass());
            }
            return false;
        }
    }
}

