/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.action.actions.global.ClipboardContentsHelper;
import org.eclipse.gmf.runtime.common.ui.action.actions.global.ClipboardManager;
import org.eclipse.gmf.runtime.common.ui.action.global.GlobalActionId;
import org.eclipse.gmf.runtime.common.ui.services.action.global.AbstractGlobalActionHandler;
import org.eclipse.gmf.runtime.common.ui.services.action.global.IGlobalActionContext;
import org.eclipse.gmf.runtime.common.ui.util.ICustomData;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.CopyCommand;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.providers.internal.DiagramProvidersDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.providers.internal.DiagramProvidersPlugin;
import org.eclipse.gmf.runtime.diagram.ui.requests.PasteViewRequest;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.ui.properties.actions.PropertyPageViewAction;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class DiagramGlobalActionHandler
extends AbstractGlobalActionHandler {
    private ICommand openCommand = null;

    public ICommand getCommand(IGlobalActionContext cntxt) {
        IWorkbenchPart part = cntxt.getActivePart();
        if (!(part instanceof IDiagramWorkbenchPart)) {
            return null;
        }
        IDiagramWorkbenchPart diagramPart = (IDiagramWorkbenchPart)part;
        ICommand command = null;
        String actionId = cntxt.getActionId();
        if (actionId.equals(GlobalActionId.DELETE)) {
            CompoundCommand deleteCC = this.getDeleteCommand(diagramPart, cntxt);
            if (deleteCC != null && deleteCC.canExecute()) {
                command = new CommandProxy((Command)deleteCC);
            }
        } else if (actionId.equals(GlobalActionId.COPY)) {
            command = this.getCopyCommand(cntxt, diagramPart, false);
        } else if (actionId.equals(GlobalActionId.CUT)) {
            command = this.getCutCommand(cntxt, diagramPart);
        } else if (actionId.equals("open")) {
            command = this.openCommand;
        } else if (actionId.equals(GlobalActionId.PASTE)) {
            EditPart targetEP;
            Command paste;
            PasteViewRequest pasteReq = this.createPasteViewRequest();
            Object[] objects = ((IStructuredSelection)cntxt.getSelection()).toArray();
            if (objects.length == 1 && (paste = (targetEP = ((EditPart)objects[0]).getTargetEditPart((Request)pasteReq)).getCommand((Request)pasteReq)) != null) {
                DiagramCommandStack cs = diagramPart.getDiagramEditDomain().getDiagramCommandStack();
                cs.execute(paste);
                diagramPart.getDiagramEditPart().getFigure().invalidate();
                diagramPart.getDiagramEditPart().getFigure().validate();
                this.selectAddedObject((EditPartViewer)diagramPart.getDiagramGraphicalViewer(), DiagramCommandStack.getReturnValues((Command)paste));
                return null;
            }
        } else if (actionId.equals(GlobalActionId.SAVE)) {
            part.getSite().getPage().saveEditor((IEditorPart)diagramPart, false);
        } else if (actionId.equals(GlobalActionId.PROPERTIES)) {
            new PropertyPageViewAction().run();
        }
        return command;
    }

    protected ICommand getCopyCommand(IGlobalActionContext cntxt, IDiagramWorkbenchPart diagramPart, final boolean isUndoable) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain(diagramPart);
        if (editingDomain == null) {
            return null;
        }
        return new CopyCommand(editingDomain, cntxt.getLabel(), (View)diagramPart.getDiagram(), this.getSelectedViews(cntxt.getSelection())){

            public boolean canUndo() {
                return isUndoable;
            }

            public boolean canRedo() {
                return isUndoable;
            }

            protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                if (isUndoable) {
                    return Status.OK_STATUS;
                }
                return super.doUndo(monitor, info);
            }

            protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                if (isUndoable) {
                    return Status.OK_STATUS;
                }
                return super.doRedo(monitor, info);
            }
        };
    }

    protected ICommand getCutCommand(IGlobalActionContext cntxt, IDiagramWorkbenchPart diagramPart) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain(diagramPart);
        if (editingDomain == null) {
            return null;
        }
        CompositeTransactionalCommand cut = new CompositeTransactionalCommand(editingDomain, cntxt.getLabel());
        cut.compose((IUndoableOperation)this.getCopyCommand(cntxt, diagramPart, true));
        Object[] objects = ((IStructuredSelection)cntxt.getSelection()).toArray();
        int i = 0;
        while (i < objects.length) {
            EditPart editPart = (EditPart)objects[i];
            GroupRequest deleteReq = new GroupRequest((Object)"delete");
            Command deleteCommand = editPart.getCommand((Request)deleteReq);
            if (deleteCommand != null) {
                cut.compose((IUndoableOperation)new CommandProxy(deleteCommand));
            }
            ++i;
        }
        if (!cut.isEmpty() && cut.canExecute()) {
            return cut;
        }
        return null;
    }

    protected PasteViewRequest createPasteViewRequest() {
        ICustomData[] data = ClipboardManager.getInstance().getClipboardData("Drawing Surface", ClipboardContentsHelper.getInstance());
        if (data == null) {
            data = ClipboardManager.getInstance().getClipboardData("COMMON_FORMAT", ClipboardContentsHelper.getInstance());
        }
        PasteViewRequest pasteReq = new PasteViewRequest(data);
        return pasteReq;
    }

    private CompoundCommand getDeleteCommand(IDiagramWorkbenchPart part, IGlobalActionContext cntxt) {
        GroupRequest deleteReq = new GroupRequest((Object)"delete");
        CompoundCommand deleteCC = new CompoundCommand(cntxt.getLabel());
        TransactionalEditingDomain editingDomain = this.getEditingDomain(part);
        if (editingDomain == null) {
            return deleteCC;
        }
        CompositeTransactionalCommand compositeCommand = new CompositeTransactionalCommand(editingDomain, cntxt.getLabel());
        Object[] objects = ((IStructuredSelection)cntxt.getSelection()).toArray();
        int i = 0;
        while (i < objects.length) {
            EditPart editPart = (EditPart)objects[i];
            Command command = editPart.getCommand((Request)deleteReq);
            if (command != null) {
                compositeCommand.compose((IUndoableOperation)new CommandProxy(command));
            }
            ++i;
        }
        if (!compositeCommand.isEmpty()) {
            deleteCC.add((Command)new ICommandProxy((ICommand)compositeCommand));
        }
        return deleteCC;
    }

    private boolean isContainedInViews(List views, View view) {
        while (view != null) {
            if (views.contains(view)) {
                return true;
            }
            if (!(view.eContainer() instanceof View)) break;
            view = (View)view.eContainer();
        }
        return false;
    }

    protected List getSelectedViews(ISelection sel) {
        final ArrayList<View> views = new ArrayList<View>();
        ArrayList editParts = new ArrayList();
        if (!(sel instanceof IStructuredSelection)) {
            return views;
        }
        for (Object object : (IStructuredSelection)sel) {
            View view;
            if (!(object instanceof INodeEditPart) && !(object instanceof ShapeEditPart)) continue;
            View view2 = view = object instanceof IAdaptable ? (View)((IAdaptable)object).getAdapter(View.class) : null;
            if (view == null || view.eResource() == null) continue;
            views.add(view);
            editParts.add(object);
        }
        if (!views.isEmpty()) {
            try {
                TransactionUtil.getEditingDomain(views.get(0)).runExclusive(new Runnable(){

                    @Override
                    public void run() {
                        ArrayList objects = (ArrayList)views.clone();
                        for (Object object : objects) {
                            if (!(object instanceof Edge)) continue;
                            Edge view = (Edge)object;
                            View fromView = view.getSource();
                            View toView = view.getTarget();
                            if (fromView != null && toView != null && DiagramGlobalActionHandler.this.isContainedInViews(views, fromView) && DiagramGlobalActionHandler.this.isContainedInViews(views, toView)) continue;
                            views.remove(view);
                        }
                    }
                });
            }
            catch (Exception e) {
                Trace.catching((Plugin)DiagramProvidersPlugin.getInstance(), (String)DiagramProvidersDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getSelectedViews()", (Throwable)e);
            }
        }
        boolean doesSelectionContainAShapeView = false;
        Iterator i = editParts.iterator();
        while (i.hasNext()) {
            if (!(i.next() instanceof ShapeEditPart)) continue;
            doesSelectionContainAShapeView = true;
            break;
        }
        if (!doesSelectionContainAShapeView) {
            views.clear();
        }
        return views;
    }

    private boolean canOpen(IGlobalActionContext cntxt) {
        boolean canOpenAll = true;
        this.openCommand = new CompositeCommand(cntxt.getLabel());
        Object[] objects = ((IStructuredSelection)cntxt.getSelection()).toArray();
        int i = 0;
        while (canOpenAll && i < objects.length) {
            if (objects[i] instanceof EditPart) {
                EditPart editPart = (EditPart)objects[i];
                Request request = new Request((Object)"open");
                Command cmd = editPart.getCommand(request);
                if (cmd == null || !cmd.canExecute()) {
                    canOpenAll = false;
                } else {
                    this.openCommand.compose((IUndoableOperation)new CommandProxy(cmd));
                }
            }
            ++i;
        }
        if (!canOpenAll) {
            this.openCommand = null;
        }
        return canOpenAll;
    }

    private boolean canDelete(IGlobalActionContext cntxt) {
        return this.getCommand(cntxt) != null;
    }

    protected boolean canCopy(IGlobalActionContext cntxt) {
        List elements = this.getSelectedViews(cntxt.getSelection());
        return !elements.isEmpty();
    }

    protected boolean canCut(IGlobalActionContext cntxt) {
        ICommand command;
        String actionId = cntxt.getActionId();
        if (actionId.equals(GlobalActionId.CUT) && (command = this.getCommand(cntxt)) != null && command.canExecute()) {
            return this.canCopy(cntxt);
        }
        return false;
    }

    protected boolean canPaste(IGlobalActionContext cntxt) {
        return ClipboardManager.getInstance().doesClipboardHaveData("Drawing Surface", ClipboardContentsHelper.getInstance()) || ClipboardManager.getInstance().doesClipboardHaveData("COMMON_FORMAT", ClipboardContentsHelper.getInstance());
    }

    private boolean canPrint() {
        return true;
    }

    protected boolean canSave(IGlobalActionContext cntxt) {
        IWorkbenchPart part = cntxt.getActivePart();
        return part instanceof IDiagramWorkbenchPart && part instanceof IEditorPart && ((IEditorPart)part).isDirty();
    }

    public boolean canHandle(IGlobalActionContext cntxt) {
        boolean result = false;
        IWorkbenchPart part = cntxt.getActivePart();
        if (!(part instanceof IDiagramWorkbenchPart)) {
            return false;
        }
        if (!(cntxt.getSelection() instanceof IStructuredSelection)) {
            return result;
        }
        String actionId = cntxt.getActionId();
        if (actionId.equals(GlobalActionId.DELETE)) {
            result = this.canDelete(cntxt);
        } else if (actionId.equals(GlobalActionId.COPY)) {
            result = this.canCopy(cntxt);
        } else if (actionId.equals(GlobalActionId.CUT)) {
            result = this.canCut(cntxt);
        } else if (actionId.equals("open")) {
            result = this.canOpen(cntxt);
        } else if (actionId.equals(GlobalActionId.PASTE)) {
            result = this.canPaste(cntxt);
        } else if (actionId.equals(GlobalActionId.PRINT)) {
            result = this.canPrint();
        } else if (actionId.equals(GlobalActionId.SAVE)) {
            result = this.canSave(cntxt);
        } else if (actionId.equals(GlobalActionId.PROPERTIES)) {
            result = true;
        }
        return result;
    }

    protected void selectAddedObject(EditPartViewer viewer, Collection objects) {
        ArrayList<EditPart> editparts = new ArrayList<EditPart>();
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            EditPart editPart = this.getEditPart(viewer, i.next());
            if (editPart == null || !editPart.isSelectable()) continue;
            editparts.add(editPart);
        }
        if (!editparts.isEmpty()) {
            viewer.setSelection((ISelection)new StructuredSelection(editparts));
            viewer.reveal((EditPart)editparts.get(0));
        }
    }

    private EditPart getEditPart(EditPartViewer viewer, Object object) {
        if (object instanceof View) {
            return (EditPart)viewer.getEditPartRegistry().get(object);
        }
        if (object instanceof IAdaptable) {
            return (EditPart)viewer.getEditPartRegistry().get(((IAdaptable)object).getAdapter(View.class));
        }
        return null;
    }

    protected IMapMode getMapMode(IGlobalActionContext cntxt) {
        RootEditPart rootEP;
        IWorkbenchPart part = cntxt.getActivePart();
        if (!(part instanceof IDiagramWorkbenchPart) && (rootEP = ((IDiagramWorkbenchPart)part).getDiagramGraphicalViewer().getRootEditPart()) instanceof DiagramRootEditPart) {
            return ((DiagramRootEditPart)part).getMapMode();
        }
        return MapModeUtil.getMapMode();
    }

    private TransactionalEditingDomain getEditingDomain(IDiagramWorkbenchPart part) {
        EditingDomain domain;
        TransactionalEditingDomain result = null;
        IEditingDomainProvider provider = (IEditingDomainProvider)part.getAdapter(IEditingDomainProvider.class);
        if (provider != null && (domain = provider.getEditingDomain()) != null && domain instanceof TransactionalEditingDomain) {
            result = (TransactionalEditingDomain)domain;
        }
        return result;
    }
}

