/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.format;

import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.util.ViewRefactorHelper;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.JumpLinkStatus;
import org.eclipse.gmf.runtime.notation.JumpLinkType;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.Smoothness;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.formatdata.AbstractFormatData;
import org.eclipse.sirius.diagram.formatdata.EdgeFormatData;
import org.eclipse.sirius.diagram.formatdata.FormatdataFactory;
import org.eclipse.sirius.diagram.formatdata.FormatdataPackage;
import org.eclipse.sirius.diagram.formatdata.NodeFormatData;
import org.eclipse.sirius.diagram.formatdata.Point;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.internal.operation.CenterEdgeEndModelChangeOperation;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.borderednode.CanonicalDBorderItemLocator;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.format.FormatDataHelper;
import org.eclipse.sirius.diagram.ui.tools.api.format.FormatDataKey;
import org.eclipse.sirius.diagram.ui.tools.api.format.SiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.ext.draw2d.figure.FigureUtilities;
import org.eclipse.sirius.tools.internal.SiriusCopierHelper;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public abstract class AbstractSiriusFormatDataManager
implements SiriusFormatDataManager {
    private static final Class<?>[] CLASS_EXCEPTIONS = new Class[]{DNodeListElement.class};

    @Override
    public void storeFormatData(IGraphicalEditPart rootEditPart) {
        HashSet<FormatDataKey> discoveredKeys = new HashSet<FormatDataKey>();
        EObject semanticElement = rootEditPart.resolveSemanticElement();
        View toStoreView = (View)rootEditPart.getModel();
        if (toStoreView instanceof Edge && semanticElement instanceof DEdge) {
            this.addEdgeFormatData(null, (DEdge)semanticElement, rootEditPart.getRoot().getViewer());
        } else if (toStoreView instanceof Diagram && semanticElement instanceof DDiagram) {
            this.addChildFormat((DDiagram)semanticElement, rootEditPart, discoveredKeys);
        } else if (toStoreView instanceof Node && semanticElement instanceof DDiagramElement && semanticElement instanceof DSemanticDecorator) {
            this.addChildFormat(null, (DRepresentationElement)((DDiagramElement)semanticElement), (Node)toStoreView, rootEditPart, discoveredKeys);
        }
        discoveredKeys.clear();
    }

    @Override
    public void applyFormat(IGraphicalEditPart rootEditPart) {
        this.applyFormat(rootEditPart, true, true);
    }

    @Override
    public void applyLayout(IGraphicalEditPart rootEditPart) {
        this.applyFormat(rootEditPart, true, false);
    }

    @Override
    public void applyStyle(IGraphicalEditPart rootEditPart) {
        this.applyFormat(rootEditPart, false, true);
    }

    protected void applyFormat(IGraphicalEditPart rootEditPart, boolean applyFormat, boolean applyStyle) {
        EObject semanticElement = rootEditPart.resolveSemanticElement();
        View toStoreView = (View)rootEditPart.getModel();
        if (!(toStoreView instanceof Edge)) {
            if (toStoreView instanceof Diagram && semanticElement instanceof DDiagram) {
                this.applyFormat((DDiagram)semanticElement, (Diagram)toStoreView, rootEditPart.getRoot().getViewer(), applyFormat, applyStyle);
                this.centerEdgesEnds(toStoreView);
            } else if (toStoreView instanceof Node) {
                if (semanticElement instanceof DDiagramElement && semanticElement instanceof DSemanticDecorator) {
                    this.applyFormat((DRepresentationElement)((DDiagramElement)semanticElement), (Node)toStoreView, rootEditPart.getRoot().getViewer(), null, applyFormat, applyStyle);
                }
                this.centerEdgesEnds(toStoreView);
            }
        }
    }

    private void centerEdgesEnds(View view) {
        HashSet edges = new HashSet();
        if (view instanceof Diagram) {
            edges.addAll(((Diagram)view).getEdges());
        } else {
            ViewUtil.getAllRelatedEdgesForView((View)view, edges);
        }
        for (Edge edge : edges) {
            CenterEdgeEndModelChangeOperation centerEdgeEndModelChangeOperation = new CenterEdgeEndModelChangeOperation(edge, false);
            centerEdgeEndModelChangeOperation.execute();
        }
    }

    private void applyFormat(DDiagram diagram, Diagram toStoreView, EditPartViewer editPartViewer, boolean applyFormat, boolean applyStyle) {
        for (AbstractDNode node : Iterables.filter((Iterable)diagram.getOwnedDiagramElements(), AbstractDNode.class)) {
            Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)node);
            if (gmfNode == null) continue;
            this.applyFormat((DRepresentationElement)node, gmfNode, editPartViewer, null, applyFormat, applyStyle);
        }
    }

    private void applyFormatToOutgoingEdge(EdgeTarget sourceNode, EditPartViewer editPartViewer, boolean applyFormat, boolean applyStyle) {
        for (DEdge edge : sourceNode.getOutgoingEdges()) {
            Edge gmfEdge = SiriusGMFHelper.getGmfEdge((DDiagramElement)edge);
            if (gmfEdge == null) continue;
            this.applyFormat(edge, gmfEdge, editPartViewer, applyFormat, applyStyle);
        }
    }

    private void applyFormat(DEdge edge, Edge gmfEdge, EditPartViewer editPartViewer, boolean applyFormat, boolean applyStyle) {
        EdgeFormatData formatData = (EdgeFormatData)this.getFormatData(this.createKey((DSemanticDecorator)edge), edge.getMapping());
        if (formatData != null) {
            if (applyFormat) {
                this.applyEdgeFormat(gmfEdge, formatData);
            }
            if (applyStyle) {
                this.applySiriusStyle((DSemanticDecorator)edge, (AbstractFormatData)formatData);
                this.applyGMFStyle((View)gmfEdge, (AbstractFormatData)formatData);
            }
            this.applyLabelFormat((View)gmfEdge, (AbstractFormatData)formatData, applyFormat, applyStyle);
        }
    }

    private void applyEdgeFormat(Edge gmfEdge, EdgeFormatData formatData) {
        RoutingStyle routingStyle;
        Bendpoints newBendpoints = this.convertPointsToGMFBendpoint(formatData);
        Bendpoints oldBendpoints = gmfEdge.getBendpoints();
        if (oldBendpoints instanceof RelativeBendpoints && newBendpoints instanceof RelativeBendpoints) {
            ((RelativeBendpoints)oldBendpoints).setPoints(((RelativeBendpoints)newBendpoints).getPoints());
        } else {
            gmfEdge.setBendpoints(newBendpoints);
        }
        if (formatData.getSourceTerminal() != null) {
            if (gmfEdge.getSourceAnchor() == null) {
                gmfEdge.setSourceAnchor((Anchor)NotationFactory.eINSTANCE.createIdentityAnchor());
            }
            if (gmfEdge.getSourceAnchor() instanceof IdentityAnchor) {
                ((IdentityAnchor)gmfEdge.getSourceAnchor()).setId(formatData.getSourceTerminal());
            }
        } else if (gmfEdge.getSourceAnchor() instanceof IdentityAnchor) {
            gmfEdge.setSourceAnchor(null);
        }
        if (formatData.getTargetTerminal() != null) {
            if (gmfEdge.getTargetAnchor() == null) {
                gmfEdge.setTargetAnchor((Anchor)NotationFactory.eINSTANCE.createIdentityAnchor());
            }
            if (gmfEdge.getTargetAnchor() instanceof IdentityAnchor) {
                ((IdentityAnchor)gmfEdge.getTargetAnchor()).setId(formatData.getTargetTerminal());
            }
        } else if (gmfEdge.getTargetAnchor() instanceof IdentityAnchor) {
            gmfEdge.setTargetAnchor(null);
        }
        if ((routingStyle = (RoutingStyle)gmfEdge.getStyle(NotationPackage.eINSTANCE.getRoutingStyle())) != null) {
            routingStyle.setRouting(Routing.get((int)formatData.getRouting()));
            routingStyle.setJumpLinkStatus(JumpLinkStatus.get((int)formatData.getJumpLinkStatus()));
            routingStyle.setJumpLinkType(JumpLinkType.get((int)formatData.getJumpLinkType()));
            routingStyle.setJumpLinksReverse(formatData.isReverseJumpLink());
            routingStyle.setSmoothness(Smoothness.get((int)formatData.getSmoothness()));
        }
    }

    private void applyLabelFormat(View gmfView, AbstractFormatData parentFormatData, boolean applyFormat, boolean applyStyle) {
        if (parentFormatData != null) {
            Node labelNode = SiriusGMFHelper.getLabelNode(gmfView);
            if (parentFormatData.getLabel() != null && labelNode != null) {
                if (applyFormat) {
                    if (!parentFormatData.getLabel().eIsSet((EStructuralFeature)FormatdataPackage.eINSTANCE.getNodeFormatData_Width()) && !parentFormatData.getLabel().eIsSet((EStructuralFeature)FormatdataPackage.eINSTANCE.getNodeFormatData_Height())) {
                        Location location = NotationFactory.eINSTANCE.createLocation();
                        location.setX(parentFormatData.getLabel().getLocation().getX());
                        location.setY(parentFormatData.getLabel().getLocation().getY());
                        labelNode.setLayoutConstraint((LayoutConstraint)location);
                    } else {
                        Bounds bounds = NotationFactory.eINSTANCE.createBounds();
                        bounds.setX(parentFormatData.getLabel().getLocation().getX());
                        bounds.setY(parentFormatData.getLabel().getLocation().getY());
                        bounds.setWidth(parentFormatData.getLabel().getWidth());
                        bounds.setHeight(parentFormatData.getLabel().getHeight());
                        labelNode.setLayoutConstraint((LayoutConstraint)bounds);
                    }
                }
                if (applyStyle) {
                    this.applyGMFStyle((View)labelNode, (AbstractFormatData)parentFormatData.getLabel());
                }
            }
        }
    }

    private Bendpoints convertPointsToGMFBendpoint(EdgeFormatData edgeFormatData) {
        RelativeBendpoints result = NotationFactory.eINSTANCE.createRelativeBendpoints();
        LinkedList<RelativeBendpoint> relativeBendpoints = new LinkedList<RelativeBendpoint>();
        Point source = edgeFormatData.getSourceRefPoint();
        Point target = edgeFormatData.getTargetRefPoint();
        if (source != null && target != null) {
            org.eclipse.draw2d.geometry.Point sourceRefPoint = new org.eclipse.draw2d.geometry.Point(source.getX(), source.getY());
            org.eclipse.draw2d.geometry.Point targetRefPoint = new org.eclipse.draw2d.geometry.Point(target.getX(), target.getY());
            for (Point point : edgeFormatData.getPointList()) {
                org.eclipse.draw2d.geometry.Point tempPoint = new org.eclipse.draw2d.geometry.Point(point.getX(), point.getY());
                Dimension s = tempPoint.getDifference(sourceRefPoint);
                Dimension t = tempPoint.getDifference(targetRefPoint);
                relativeBendpoints.add(new RelativeBendpoint(s.width, s.height, t.width, t.height));
            }
        }
        result.setPoints(relativeBendpoints);
        return result;
    }

    private void applyFormat(DRepresentationElement semanticDecorator, Node toRestoreView, EditPartViewer editPartViewer, NodeFormatData parentFormatData, boolean applyFormat, boolean applyStyle) {
        FormatDataKey key = this.createKey((DSemanticDecorator)semanticDecorator);
        NodeFormatData formatData = (NodeFormatData)this.getFormatData(key, semanticDecorator.getMapping());
        if (parentFormatData != null && parentFormatData == formatData && !StringUtil.isEmpty((String)key.getId())) {
            formatData = null;
            for (NodeFormatData childFormatData : parentFormatData.getChildren()) {
                if (!key.getId().equals(childFormatData.getId())) continue;
                if (formatData == null) {
                    formatData = childFormatData;
                    continue;
                }
                formatData = null;
                break;
            }
        }
        Object editPartAsObject = editPartViewer.getEditPartRegistry().get(toRestoreView);
        if (formatData != null && applyFormat && editPartAsObject != null) {
            Point locationToApply;
            Bounds bounds = NotationFactory.eINSTANCE.createBounds();
            IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)editPartAsObject;
            boolean isCollapsed = false;
            if (graphicalEditPart instanceof AbstractDiagramBorderNodeEditPart) {
                locationToApply = FormatDataHelper.INSTANCE.getAbsoluteLocation(formatData);
                Node parentNode = (Node)toRestoreView.eContainer();
                CanonicalDBorderItemLocator locator = new CanonicalDBorderItemLocator(parentNode, 29);
                if (semanticDecorator instanceof DDiagramElement) {
                    if (new DDiagramElementQuery((DDiagramElement)semanticDecorator).isIndirectlyCollapsed()) {
                        isCollapsed = true;
                        locator.setBorderItemOffset(IBorderItemOffsets.COLLAPSE_FILTER_OFFSET);
                    } else {
                        locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                    }
                } else {
                    locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                }
                Rectangle rect = new Rectangle(locationToApply.getX(), locationToApply.getY(), formatData.getWidth(), formatData.getHeight());
                org.eclipse.draw2d.geometry.Point realLocation = locator.getValidLocation(rect, toRestoreView, new ArrayList<Node>(Arrays.asList(toRestoreView)));
                org.eclipse.draw2d.geometry.Point parentAbsoluteLocation = ((IGraphicalEditPart)graphicalEditPart.getParent()).getFigure().getBounds().getTopLeft().getCopy();
                FigureUtilities.translateToAbsoluteByIgnoringScrollbar((IFigure)((IGraphicalEditPart)graphicalEditPart.getParent()).getFigure(), (org.eclipse.draw2d.geometry.Point)parentAbsoluteLocation);
                locationToApply.setX(realLocation.x);
                locationToApply.setY(realLocation.y);
                locationToApply = FormatDataHelper.INSTANCE.getTranslated(locationToApply, parentAbsoluteLocation.negate());
            } else {
                locationToApply = FormatDataHelper.INSTANCE.getRelativeLocation(formatData, graphicalEditPart);
                graphicalEditPart.getFigure().setLocation(new org.eclipse.draw2d.geometry.Point(locationToApply.getX(), locationToApply.getY()));
            }
            bounds.setX(locationToApply.getX());
            bounds.setY(locationToApply.getY());
            if (isCollapsed) {
                Dimension dim = new NodeQuery(toRestoreView).getCollapsedSize();
                bounds.setHeight(dim.height);
                bounds.setWidth(dim.width);
            } else {
                bounds.setHeight(formatData.getHeight());
                bounds.setWidth(formatData.getWidth());
            }
            toRestoreView.setLayoutConstraint((LayoutConstraint)bounds);
        }
        if (formatData != null && applyStyle) {
            this.applySiriusStyle((DSemanticDecorator)semanticDecorator, (AbstractFormatData)formatData);
            this.applyGMFStyle((View)toRestoreView, (AbstractFormatData)formatData);
        }
        if (semanticDecorator instanceof DNode) {
            this.applyFormatToNodeChildren((DNode)semanticDecorator, editPartViewer, formatData, applyFormat, applyStyle);
        } else if (semanticDecorator instanceof DNodeContainer) {
            this.applyFormatToNodeContainerChildren((DNodeContainer)semanticDecorator, editPartViewer, formatData, applyFormat, applyStyle);
        } else if (semanticDecorator instanceof DNodeList) {
            this.applyFormatToNodeListChildren((DNodeList)semanticDecorator, editPartViewer, formatData, applyFormat, applyStyle);
        } else {
            AbstractSiriusFormatDataManager.logUnhandledDiagramElementKindMessage(semanticDecorator);
        }
        if (semanticDecorator instanceof EdgeTarget) {
            this.applyFormatToOutgoingEdge((EdgeTarget)semanticDecorator, editPartViewer, applyFormat, applyStyle);
        }
    }

    protected void applySiriusStyle(DSemanticDecorator semanticDecorator, AbstractFormatData formatData) {
        Style copyOfSiriusStyle = (Style)SiriusCopierHelper.copyWithNoUidDuplication((EObject)formatData.getSiriusStyle());
        if ((semanticDecorator instanceof DNode || semanticDecorator instanceof DNodeListElement) && copyOfSiriusStyle instanceof NodeStyle) {
            if (semanticDecorator instanceof DNode) {
                this.computeCustomFeatures((Style)((DNode)semanticDecorator).getOwnedStyle(), copyOfSiriusStyle);
                ((DNode)semanticDecorator).setOwnedStyle((NodeStyle)copyOfSiriusStyle);
            } else {
                this.computeCustomFeatures((Style)((DNodeListElement)semanticDecorator).getOwnedStyle(), copyOfSiriusStyle);
                ((DNodeListElement)semanticDecorator).setOwnedStyle((NodeStyle)copyOfSiriusStyle);
            }
        } else if (semanticDecorator instanceof DDiagramElementContainer && copyOfSiriusStyle instanceof ContainerStyle) {
            if (((DDiagramElementContainer)semanticDecorator).getOwnedStyle() != null) {
                this.computeCustomFeatures((Style)((DDiagramElementContainer)semanticDecorator).getOwnedStyle(), copyOfSiriusStyle);
            }
            ((DDiagramElementContainer)semanticDecorator).setOwnedStyle((ContainerStyle)copyOfSiriusStyle);
        } else if (semanticDecorator instanceof DEdge && copyOfSiriusStyle instanceof EdgeStyle) {
            this.computeCustomFeatures((Style)((DEdge)semanticDecorator).getOwnedStyle(), copyOfSiriusStyle);
            ((DEdge)semanticDecorator).setOwnedStyle((EdgeStyle)copyOfSiriusStyle);
        }
    }

    protected void applyGMFStyle(View newView, AbstractFormatData formatData) {
        if (newView != null && formatData.getGmfView() != null) {
            ArrayList<EClass> excludedStyles = new ArrayList<EClass>();
            if (newView instanceof Edge) {
                excludedStyles.add(NotationPackage.eINSTANCE.getRoutingStyle());
            }
            new ViewRefactorHelper().copyViewAppearance(formatData.getGmfView(), newView, excludedStyles);
        }
    }

    public static void logUnhandledDiagramElementKindMessage(Object notManagedObject) {
        Class<?> clazz = notManagedObject.getClass();
        boolean logWarn = true;
        Class<?>[] classArray = CLASS_EXCEPTIONS;
        int n = CLASS_EXCEPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> exceptionClass = classArray[n2];
            if (exceptionClass.isAssignableFrom(clazz)) {
                logWarn = false;
                break;
            }
            ++n2;
        }
        if (logWarn) {
            DiagramPlugin.getDefault().logWarning(MessageFormat.format(Messages.AbstractSiriusLayoutDataManager_unhandledDiagramElementKind, clazz.getName()));
        }
    }

    private void applyFormatToNodeChildren(DNode parentNode, EditPartViewer editPartViewer, NodeFormatData formatData, boolean applyFormat, boolean applyStyle) {
        this.applyFormatForBorderedNodes((EList<DNode>)parentNode.getOwnedBorderedNodes(), editPartViewer, formatData, applyFormat, applyStyle);
        Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)parentNode);
        this.applyLabelFormat((View)gmfNode, (AbstractFormatData)formatData, applyFormat, applyStyle);
    }

    private void applyFormatToNodeContainerChildren(DNodeContainer container, EditPartViewer editPartViewer, NodeFormatData formatData, boolean applyFormat, boolean applyStyle) {
        for (DDiagramElement child : container.getOwnedDiagramElements()) {
            Node gmfNode;
            if (!(child instanceof AbstractDNode) || (gmfNode = SiriusGMFHelper.getGmfNode(child)) == null) continue;
            this.applyFormat((DRepresentationElement)child, gmfNode, editPartViewer, formatData, applyFormat, applyStyle);
        }
        this.applyFormatForBorderedNodes((EList<DNode>)container.getOwnedBorderedNodes(), editPartViewer, formatData, applyFormat, applyStyle);
        Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)container);
        this.applyLabelFormat((View)gmfNode, (AbstractFormatData)formatData, applyFormat, applyStyle);
    }

    private void applyFormatForBorderedNodes(EList<DNode> borderedNodes, EditPartViewer editPartViewer, NodeFormatData parentFormatData, boolean applyFormat, boolean applyStyle) {
        HashMap<Node, NodeFormatData> nodesWithFormatDataToApply = new HashMap<Node, NodeFormatData>();
        HashMap<Node, DNode> nodesWithCoresspondingDSemanticDecorator = new HashMap<Node, DNode>();
        for (DNode child : borderedNodes) {
            Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)child);
            if (gmfNode == null) continue;
            FormatDataKey key = this.createKey((DSemanticDecorator)child);
            NodeFormatData formatData = (NodeFormatData)this.getFormatData(key, child.getMapping());
            if (parentFormatData != null && parentFormatData == formatData && !StringUtil.isEmpty((String)key.getId())) {
                formatData = null;
                for (NodeFormatData childFormatData : parentFormatData.getChildren()) {
                    if (!key.getId().equals(childFormatData.getId())) continue;
                    if (formatData == null) {
                        formatData = childFormatData;
                        continue;
                    }
                    formatData = null;
                    break;
                }
            }
            if (formatData == null) continue;
            nodesWithFormatDataToApply.put(gmfNode, formatData);
            nodesWithCoresspondingDSemanticDecorator.put(gmfNode, child);
        }
        Set<Node> toIgnore = nodesWithFormatDataToApply.keySet();
        for (Map.Entry entry : nodesWithFormatDataToApply.entrySet()) {
            Node node = (Node)entry.getKey();
            this.applyFormatForBorderedNode((DSemanticDecorator)nodesWithCoresspondingDSemanticDecorator.get(node), node, editPartViewer, (NodeFormatData)entry.getValue(), toIgnore, applyFormat, applyStyle);
        }
    }

    private void applyFormatForBorderedNode(DSemanticDecorator semanticDecorator, Node toRestoreView, EditPartViewer editPartViewer, NodeFormatData formatData, Set<Node> portsNodesToIgnore, boolean applyFormat, boolean applyStyle) {
        if (applyFormat) {
            Point locationToApply;
            Bounds bounds = NotationFactory.eINSTANCE.createBounds();
            boolean isCollapsed = false;
            if (!(toRestoreView.eContainer() instanceof Node)) {
                return;
            }
            Node parentNode = (Node)toRestoreView.eContainer();
            Object parentGraphicalEditPart = editPartViewer.getEditPartRegistry().get(parentNode);
            NodeQuery nodeQuery = new NodeQuery(toRestoreView);
            if (nodeQuery.isBorderedNode() && parentGraphicalEditPart instanceof IGraphicalEditPart) {
                locationToApply = FormatDataHelper.INSTANCE.getAbsoluteLocation(formatData);
                CanonicalDBorderItemLocator locator = new CanonicalDBorderItemLocator(parentNode, 29);
                if (semanticDecorator instanceof DDiagramElement) {
                    if (new DDiagramElementQuery((DDiagramElement)semanticDecorator).isIndirectlyCollapsed()) {
                        isCollapsed = true;
                        locator.setBorderItemOffset(IBorderItemOffsets.COLLAPSE_FILTER_OFFSET);
                    } else {
                        locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                    }
                } else {
                    locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                }
                Rectangle rect = new Rectangle(locationToApply.getX(), locationToApply.getY(), formatData.getWidth(), formatData.getHeight());
                org.eclipse.draw2d.geometry.Point realLocation = locator.getValidLocation(rect, toRestoreView, portsNodesToIgnore);
                org.eclipse.draw2d.geometry.Point parentAbsoluteLocation = GMFHelper.getAbsoluteBounds(parentNode, true).getTopLeft();
                locationToApply.setX(realLocation.x);
                locationToApply.setY(realLocation.y);
                locationToApply = FormatDataHelper.INSTANCE.getTranslated(locationToApply, parentAbsoluteLocation.negate());
            } else {
                Object graphicalEditPart = editPartViewer.getEditPartRegistry().get(toRestoreView);
                if (graphicalEditPart instanceof IGraphicalEditPart) {
                    locationToApply = FormatDataHelper.INSTANCE.getRelativeLocation(formatData, (IGraphicalEditPart)graphicalEditPart);
                    ((GraphicalEditPart)graphicalEditPart).getFigure().setLocation(new org.eclipse.draw2d.geometry.Point(locationToApply.getX(), locationToApply.getY()));
                } else {
                    locationToApply = FormatdataFactory.eINSTANCE.createPoint();
                }
            }
            bounds.setX(locationToApply.getX());
            bounds.setY(locationToApply.getY());
            if (isCollapsed) {
                Dimension dim = new NodeQuery(toRestoreView).getCollapsedSize();
                bounds.setHeight(dim.height);
                bounds.setWidth(dim.width);
            } else {
                bounds.setHeight(formatData.getHeight());
                bounds.setWidth(formatData.getWidth());
            }
            toRestoreView.setLayoutConstraint((LayoutConstraint)bounds);
        }
        if (applyStyle) {
            this.applySiriusStyle(semanticDecorator, (AbstractFormatData)formatData);
            this.applyGMFStyle((View)toRestoreView, (AbstractFormatData)formatData);
        }
        if (semanticDecorator instanceof DNode) {
            this.applyFormatToNodeChildren((DNode)semanticDecorator, editPartViewer, formatData, applyFormat, applyStyle);
        } else if (semanticDecorator instanceof DNodeContainer) {
            this.applyFormatToNodeContainerChildren((DNodeContainer)semanticDecorator, editPartViewer, formatData, applyFormat, applyStyle);
        } else if (semanticDecorator instanceof DNodeList) {
            this.applyFormatToNodeListChildren((DNodeList)semanticDecorator, editPartViewer, formatData, applyFormat, applyStyle);
        } else {
            AbstractSiriusFormatDataManager.logUnhandledDiagramElementKindMessage(semanticDecorator);
        }
        if (semanticDecorator instanceof EdgeTarget) {
            this.applyFormatToOutgoingEdge((EdgeTarget)semanticDecorator, editPartViewer, applyFormat, applyStyle);
        }
    }

    private void applyFormatToNodeListChildren(DNodeList nodeList, EditPartViewer editPartViewer, NodeFormatData formatData, boolean applyFormat, boolean applyStyle) {
        this.applyFormatForBorderedNodes((EList<DNode>)nodeList.getOwnedBorderedNodes(), editPartViewer, formatData, applyFormat, applyStyle);
        Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)nodeList);
        this.applyLabelFormat((View)gmfNode, (AbstractFormatData)formatData, applyFormat, applyStyle);
    }

    protected void addNodeChildren(DNode parentNode, NodeFormatData parentFormatData, IGraphicalEditPart parentEditPart, View gmfView, Collection<FormatDataKey> discoveredKeys) {
        for (DNode child : parentNode.getOwnedBorderedNodes()) {
            this.checkDataAndAddChildFormat(parentFormatData, (AbstractDNode)child, parentEditPart, discoveredKeys);
        }
        this.addLabelFormatData((AbstractFormatData)parentFormatData, gmfView);
    }

    protected void checkDataAndAddChildFormat(NodeFormatData parentFormatData, AbstractDNode child, IGraphicalEditPart parentSavedEditPart, Collection<FormatDataKey> discoveredKeys) {
        IGraphicalEditPart editPart;
        Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)child);
        if (gmfNode != null && (editPart = (IGraphicalEditPart)parentSavedEditPart.getRoot().getViewer().getEditPartRegistry().get(gmfNode)) != null) {
            this.addChildFormat(parentFormatData, (DRepresentationElement)child, gmfNode, editPart, discoveredKeys);
        }
    }

    protected void addNodeContainerChildren(DNodeContainer container, NodeFormatData parentFormatData, IGraphicalEditPart parentEditPart, Collection<FormatDataKey> discoveredKeys) {
        for (DDiagramElement child : container.getOwnedDiagramElements()) {
            if (!(child instanceof AbstractDNode)) continue;
            this.checkDataAndAddChildFormat(parentFormatData, (AbstractDNode)child, parentEditPart, discoveredKeys);
        }
        for (DDiagramElement child : container.getOwnedBorderedNodes()) {
            this.checkDataAndAddChildFormat(parentFormatData, (AbstractDNode)child, parentEditPart, discoveredKeys);
        }
    }

    protected void addNodeListChildren(DNodeList nodeList, NodeFormatData parentFormatData, IGraphicalEditPart parentEditPart, Collection<FormatDataKey> discoveredKeys) {
        for (DNode child : nodeList.getOwnedBorderedNodes()) {
            this.checkDataAndAddChildFormat(parentFormatData, (AbstractDNode)child, parentEditPart, discoveredKeys);
        }
    }

    private void addChildFormat(DDiagram diagram, IGraphicalEditPart diagramEditPart, Collection<FormatDataKey> discoveredKeys) {
        for (AbstractDNode child : Iterables.filter((Iterable)diagram.getOwnedDiagramElements(), AbstractDNode.class)) {
            IGraphicalEditPart editPart;
            Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)child);
            if (gmfNode == null || (editPart = (IGraphicalEditPart)diagramEditPart.getRoot().getViewer().getEditPartRegistry().get(gmfNode)) == null) continue;
            this.addChildFormat(null, (DRepresentationElement)child, gmfNode, editPart, discoveredKeys);
        }
    }

    private void addChildFormat(NodeFormatData parentFormatData, DRepresentationElement child, Node gmfNode, IGraphicalEditPart editPart, Collection<FormatDataKey> discoveredKeys) {
        NodeFormatData childFormatData = FormatDataHelper.INSTANCE.createNodeFormatData(gmfNode, editPart, parentFormatData);
        if (parentFormatData != null) {
            parentFormatData.getChildren().add((Object)childFormatData);
        }
        FormatDataKey childKey = this.createKey((DSemanticDecorator)child);
        childFormatData.setId(childKey.getId());
        if (!discoveredKeys.contains(childKey)) {
            this.addFormatData(childKey, child.getMapping(), (AbstractFormatData)childFormatData);
            discoveredKeys.add(childKey);
        } else if (parentFormatData == null) {
            this.addFormatData(childKey, child.getMapping(), (AbstractFormatData)childFormatData);
        }
        if (child instanceof DNode) {
            this.addNodeChildren((DNode)child, childFormatData, editPart, (View)gmfNode, discoveredKeys);
        } else if (child instanceof DNodeContainer) {
            this.addNodeContainerChildren((DNodeContainer)child, childFormatData, editPart, discoveredKeys);
        } else if (child instanceof DNodeList) {
            this.addNodeListChildren((DNodeList)child, childFormatData, editPart, discoveredKeys);
        } else {
            AbstractSiriusFormatDataManager.logUnhandledDiagramElementKindMessage(child);
        }
        if (child instanceof EdgeTarget) {
            this.addOutgoingEdge(childFormatData, (EdgeTarget)child, editPart.getRoot().getViewer());
        }
    }

    protected void addOutgoingEdge(NodeFormatData parentFormatData, EdgeTarget sourceOfEdge, EditPartViewer editPartViewer) {
        for (DEdge outgoingEdge : sourceOfEdge.getOutgoingEdges()) {
            this.addEdgeFormatData(parentFormatData, outgoingEdge, editPartViewer);
        }
    }

    protected void addEdgeFormatData(NodeFormatData parentFormatData, DEdge edge, EditPartViewer editPartViewer) {
        Edge gmfEdge = SiriusGMFHelper.getGmfEdge((DDiagramElement)edge);
        if (gmfEdge != null) {
            EdgeFormatData edgeFormatData = FormatDataHelper.INSTANCE.createEdgeFormatData(gmfEdge, (ConnectionEditPart)editPartViewer.getEditPartRegistry().get(gmfEdge));
            if (parentFormatData != null) {
                parentFormatData.getOutgoingEdges().add((Object)edgeFormatData);
            }
            FormatDataKey edgeKey = this.createKey((DSemanticDecorator)edge);
            edgeFormatData.setId(edgeKey.getId());
            this.addFormatData(edgeKey, edge.getMapping(), (AbstractFormatData)edgeFormatData);
            this.addLabelFormatData((AbstractFormatData)edgeFormatData, (View)gmfEdge);
        }
    }

    private void addLabelFormatData(AbstractFormatData parentFormatData, View gmfElement) {
        Node labelNode = SiriusGMFHelper.getLabelNode(gmfElement);
        if (labelNode != null && parentFormatData != null) {
            NodeFormatData labelFormatData = FormatDataHelper.INSTANCE.createLabelFormatData(labelNode);
            if (labelNode.getElement() instanceof DSemanticDecorator) {
                labelFormatData.setId(this.createKey((DSemanticDecorator)labelNode.getElement()).getId());
            }
            parentFormatData.setLabel(labelFormatData);
        }
    }

    protected void computeCustomFeatures(Style oldStyle, Style newStyle) {
        for (EAttribute attribute : newStyle.eClass().getEAllAttributes()) {
            EAttribute attributeOfOldStyle;
            if (ViewpointPackage.Literals.CUSTOMIZABLE__CUSTOM_FEATURES.equals(attribute) || (attributeOfOldStyle = this.getCorrespondingEAttribute(attribute, oldStyle)) == null) continue;
            if (newStyle.eIsSet((EStructuralFeature)attribute)) {
                if (newStyle.eGet((EStructuralFeature)attribute).equals(oldStyle.eGet((EStructuralFeature)attributeOfOldStyle))) continue;
                newStyle.getCustomFeatures().add((Object)attributeOfOldStyle.getName());
                continue;
            }
            if (!oldStyle.eIsSet((EStructuralFeature)attributeOfOldStyle)) continue;
            newStyle.getCustomFeatures().add((Object)attributeOfOldStyle.getName());
        }
    }

    private EAttribute getCorrespondingEAttribute(EAttribute attribute, Style style) {
        EAttribute result = null;
        if (style.eClass().getFeatureID((EStructuralFeature)attribute) != -1) {
            result = attribute;
        } else {
            EStructuralFeature structuralFeature = style.eClass().getEStructuralFeature(attribute.getName());
            if (structuralFeature instanceof EAttribute) {
                result = (EAttribute)structuralFeature;
            } else if ("color".equals(attribute.getName())) {
                structuralFeature = style.eClass().getEStructuralFeature("backgroundColor");
                if (structuralFeature instanceof EAttribute) {
                    result = (EAttribute)structuralFeature;
                }
            } else if ("backgroundColor".equals(attribute.getName())) {
                structuralFeature = style.eClass().getEStructuralFeature("color");
                if (structuralFeature instanceof EAttribute) {
                    result = (EAttribute)structuralFeature;
                }
            } else if ("width".equals(attribute.getName())) {
                structuralFeature = style.eClass().getEStructuralFeature("horizontalDiameter");
                if (structuralFeature instanceof EAttribute) {
                    result = (EAttribute)structuralFeature;
                }
            } else if ("horizontalDiameter".equals(attribute.getName())) {
                structuralFeature = style.eClass().getEStructuralFeature("width");
                if (structuralFeature instanceof EAttribute) {
                    result = (EAttribute)structuralFeature;
                }
            } else if ("height".equals(attribute.getName())) {
                structuralFeature = style.eClass().getEStructuralFeature("verticalDiameter");
                if (structuralFeature instanceof EAttribute) {
                    result = (EAttribute)structuralFeature;
                }
            } else if ("verticalDiameter".equals(attribute.getName()) && (structuralFeature = style.eClass().getEStructuralFeature("height")) instanceof EAttribute) {
                result = (EAttribute)structuralFeature;
            }
        }
        return result;
    }
}

