/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.operation;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.tools.internal.util.GMFNotationUtilities;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class ShiftEdgeIdentityAnchorOperation
extends AbstractModelChangeOperation<Void> {
    private ChangeBoundsRequest request;
    private Dimension futureSize;
    private PrecisionPoint delta;

    public ShiftEdgeIdentityAnchorOperation(ChangeBoundsRequest request) {
        this.request = request;
    }

    public ShiftEdgeIdentityAnchorOperation(ChangeBoundsRequest request, Dimension futureSize, PrecisionPoint delta) {
        this(request);
        this.futureSize = futureSize;
        this.delta = delta;
    }

    @Override
    public Void execute() {
        List editParts = this.request.getEditParts();
        for (EditPart editPart : Iterables.filter((Iterable)editParts, EditPart.class)) {
            Option<View> viewOption = this.getView(editPart);
            if (!viewOption.some()) continue;
            this.handleTargetEdges((View)viewOption.get(), editPart);
            this.handleSourceEdges((View)viewOption.get(), editPart);
        }
        return null;
    }

    private void handleSourceEdges(View view, EditPart editPart) {
        EList sourceEdges = view.getSourceEdges();
        for (Edge edge : Iterables.filter((Iterable)sourceEdges, Edge.class)) {
            EObject eObj = edge.getElement();
            if (!(eObj instanceof DEdge)) continue;
            this.handleEdge(edge, editPart, true);
        }
    }

    private void handleTargetEdges(View view, EditPart editPart) {
        EList targetEdges = view.getTargetEdges();
        for (Edge edge : Iterables.filter((Iterable)targetEdges, Edge.class)) {
            EObject eObj = edge.getElement();
            if (!(eObj instanceof DEdge)) continue;
            this.handleEdge(edge, editPart, false);
        }
    }

    private void handleEdge(Edge edge, EditPart editPart, boolean sourceAnchor) {
        Anchor anchorToModify = sourceAnchor ? edge.getSourceAnchor() : edge.getTargetAnchor();
        String terminalString = GMFNotationUtilities.getTerminalString(0.5, 0.5);
        if (anchorToModify instanceof IdentityAnchor) {
            terminalString = ((IdentityAnchor)anchorToModify).getId();
        }
        PrecisionPoint anchorPoint = BaseSlidableAnchor.parseTerminalString((String)terminalString);
        PrecisionPoint newPoint = this.computeNewAnchor(anchorPoint, editPart);
        String newTerminalString = new SlidableAnchor(null, newPoint).getTerminal();
        if (anchorToModify instanceof IdentityAnchor) {
            ((IdentityAnchor)anchorToModify).setId(newTerminalString);
        } else if (anchorToModify == null) {
            IdentityAnchor newAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
            newAnchor.setId(newTerminalString);
            if (sourceAnchor) {
                edge.setSourceAnchor((Anchor)newAnchor);
            } else {
                edge.setTargetAnchor((Anchor)newAnchor);
            }
        }
    }

    private PrecisionPoint computeNewAnchor(PrecisionPoint currentAnchorPoint, EditPart editPart) {
        double scale = GraphicalHelper.getZoom((EditPart)editPart);
        IFigure figure = ((IGraphicalEditPart)editPart).getFigure();
        Rectangle bounds = figure.getBounds();
        if (figure instanceof HandleBounds) {
            bounds = ((HandleBounds)figure).getHandleBounds();
        }
        Point currentRelativePoint = this.getAnchorRelativePoint(currentAnchorPoint, bounds);
        if (this.futureSize != null && this.delta != null) {
            return new PrecisionPoint((double)(currentRelativePoint.x - this.delta.x) / (double)this.futureSize.width, (double)(currentRelativePoint.y - this.delta.y) / (double)this.futureSize.height);
        }
        double logicalWidthDelta = (double)this.request.getSizeDelta().width / scale;
        double logicalHeightDelta = (double)this.request.getSizeDelta().height / scale;
        int direction = this.request.getResizeDirection();
        double newRelativeX = this.computeNewXRelativeLocation(direction, currentRelativePoint, logicalWidthDelta);
        double newRelativeY = this.computeNewYRelativeLocation(direction, currentRelativePoint, logicalHeightDelta);
        return new PrecisionPoint(newRelativeX / ((double)bounds.width() + logicalWidthDelta), newRelativeY / ((double)bounds.height() + logicalHeightDelta));
    }

    private Point getAnchorRelativePoint(PrecisionPoint currentAnchorPoint, Rectangle bounds) {
        return new PrecisionPoint((double)bounds.width() * currentAnchorPoint.preciseX(), (double)bounds.height() * currentAnchorPoint.preciseY());
    }

    private double computeNewXRelativeLocation(int direction, Point currentRelativePoint, double logicalWidthDelta) {
        if (direction == 9 || direction == 8 || direction == 12) {
            return currentRelativePoint.preciseX() + logicalWidthDelta;
        }
        return currentRelativePoint.preciseX();
    }

    private double computeNewYRelativeLocation(int direction, Point currentRelativePoint, double logicalHeightDelta) {
        if (direction == 9 || direction == 1 || direction == 17) {
            return currentRelativePoint.preciseY() + logicalHeightDelta;
        }
        return currentRelativePoint.preciseY();
    }

    private Option<View> getView(EditPart editPart) {
        Object model = editPart.getModel();
        if (model instanceof View) {
            return Options.newSome((Object)((View)model));
        }
        return Options.newNone();
    }
}

