/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.aql.business.api;

public class ExpressionTrimmer {
    private static final String ACCELEO_EXPRESSION_PREFIX = "[";
    private static final String ACCELEO_EXPRESSION_SUFFIX = "/]";
    private int removedFromStart;
    private int removedFromEnd;
    private String expression;

    public ExpressionTrimmer(String anyExpression) {
        this.expression = anyExpression;
        this.trim();
    }

    private void trim() {
        if (this.expression != null) {
            if (this.expression.startsWith("aql:")) {
                this.expression = this.expression.substring("aql:".length());
                this.removedFromStart += "aql:".length();
            }
            if (this.expression.startsWith(ACCELEO_EXPRESSION_PREFIX)) {
                this.expression = this.expression.substring(ACCELEO_EXPRESSION_PREFIX.length());
                this.removedFromStart += ACCELEO_EXPRESSION_PREFIX.length();
            }
            if (this.expression.endsWith(ACCELEO_EXPRESSION_SUFFIX)) {
                this.expression = this.expression.substring(0, this.expression.length() - ACCELEO_EXPRESSION_SUFFIX.length());
                this.removedFromEnd += ACCELEO_EXPRESSION_SUFFIX.length();
            }
        }
    }

    public boolean positionIsWithinAQL(int position) {
        return position - this.removedFromStart <= this.expression.length() - this.removedFromEnd;
    }

    public int getPositionWithinAQL(int positionWithinExpression) {
        if (this.positionIsWithinAQL(positionWithinExpression)) {
            return positionWithinExpression - this.removedFromStart;
        }
        return -1;
    }

    public String getExpression() {
        return this.expression;
    }

    public int getPositionInExpression(int cursorOffset) {
        return cursorOffset + this.removedFromStart;
    }
}

