/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.nodespacing.internal.algorithm;

import java.util.Collection;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.AtomicCell;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.HorizontalLabelAlignment;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.LabelCell;
import org.eclipse.elk.alg.common.nodespacing.cellsystem.VerticalLabelAlignment;
import org.eclipse.elk.alg.common.nodespacing.internal.NodeContext;
import org.eclipse.elk.alg.common.nodespacing.internal.PortContext;
import org.eclipse.elk.alg.common.nodespacing.internal.algorithm.NodeLabelAndSizeUtilities;
import org.eclipse.elk.alg.common.overlaps.RectangleStripOverlapRemover;
import org.eclipse.elk.core.math.ElkMath;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;

public final class PortLabelPlacementCalculator {
    private PortLabelPlacementCalculator() {
    }

    public static void placeHorizontalPortLabels(NodeContext nodeContext) {
        PortLabelPlacementCalculator.placePortLabels(nodeContext, PortSide.NORTH);
        PortLabelPlacementCalculator.placePortLabels(nodeContext, PortSide.SOUTH);
    }

    public static void placeVerticalPortLabels(NodeContext nodeContext) {
        PortLabelPlacementCalculator.placePortLabels(nodeContext, PortSide.EAST);
        PortLabelPlacementCalculator.placePortLabels(nodeContext, PortSide.WEST);
    }

    private static void placePortLabels(NodeContext nodeContext, PortSide portSide) {
        boolean constrainedPlacement;
        boolean bl = constrainedPlacement = !nodeContext.sizeConstraints.contains(SizeConstraint.PORT_LABELS) || nodeContext.portConstraints == PortConstraints.FIXED_POS;
        if (nodeContext.portLabelsPlacement.contains(PortLabelPlacement.INSIDE)) {
            if (constrainedPlacement) {
                PortLabelPlacementCalculator.constrainedInsidePortLabelPlacement(nodeContext, portSide);
            } else {
                PortLabelPlacementCalculator.simpleInsidePortLabelPlacement(nodeContext, portSide);
            }
        } else if (nodeContext.portLabelsPlacement.contains(PortLabelPlacement.OUTSIDE)) {
            if (constrainedPlacement) {
                PortLabelPlacementCalculator.constrainedOutsidePortLabelPlacement(nodeContext, portSide);
            } else {
                PortLabelPlacementCalculator.simpleOutsidePortLabelPlacement(nodeContext, portSide);
            }
        }
    }

    private static void simpleInsidePortLabelPlacement(NodeContext nodeContext, PortSide portSide) {
        double insideNorthOrSouthPortLabelAreaHeight = 0.0;
        double labelBorderOffset = PortLabelPlacementCalculator.portLabelBorderOffsetForPortSide(nodeContext, portSide);
        double portLabelSpacing = nodeContext.portLabelSpacing;
        for (PortContext portContext : nodeContext.portContexts.get((Object)portSide)) {
            if (portContext.portLabelCell == null || !portContext.portLabelCell.hasLabels()) continue;
            KVector portSize = portContext.port.getSize();
            double portBorderOffset = portContext.port.hasProperty(CoreOptions.PORT_BORDER_OFFSET) ? (Double)portContext.port.getProperty(CoreOptions.PORT_BORDER_OFFSET) : 0.0;
            LabelCell portLabelCell = portContext.portLabelCell;
            ElkRectangle portLabelCellRect = portLabelCell.getCellRectangle();
            portLabelCellRect.width = portLabelCell.getMinimumWidth();
            portLabelCellRect.height = portLabelCell.getMinimumHeight();
            switch (portSide) {
                case NORTH: {
                    portLabelCellRect.x = portContext.labelsNextToPort ? (portSize.x - portLabelCellRect.width) / 2.0 : portSize.x + portLabelSpacing;
                    portLabelCellRect.y = portSize.y + portBorderOffset + labelBorderOffset;
                    portLabelCell.setHorizontalAlignment(HorizontalLabelAlignment.CENTER);
                    portLabelCell.setVerticalAlignment(VerticalLabelAlignment.TOP);
                    break;
                }
                case SOUTH: {
                    portLabelCellRect.x = portContext.labelsNextToPort ? (portSize.x - portLabelCellRect.width) / 2.0 : portSize.x + portLabelSpacing;
                    portLabelCellRect.y = -portBorderOffset - labelBorderOffset - portLabelCellRect.height;
                    portLabelCell.setHorizontalAlignment(HorizontalLabelAlignment.CENTER);
                    portLabelCell.setVerticalAlignment(VerticalLabelAlignment.BOTTOM);
                    break;
                }
                case EAST: {
                    double labelHeight;
                    portLabelCellRect.x = -portBorderOffset - labelBorderOffset - portLabelCellRect.width;
                    if (portContext.labelsNextToPort) {
                        labelHeight = nodeContext.portLabelsTreatAsGroup ? portLabelCellRect.height : portLabelCell.getLabels().get((int)0).getSize().y;
                        portLabelCellRect.y = (portSize.y - labelHeight) / 2.0;
                    } else {
                        portLabelCellRect.y = portSize.y + portLabelSpacing;
                    }
                    portLabelCell.setHorizontalAlignment(HorizontalLabelAlignment.RIGHT);
                    portLabelCell.setVerticalAlignment(VerticalLabelAlignment.CENTER);
                    break;
                }
                case WEST: {
                    double labelHeight;
                    portLabelCellRect.x = portSize.x + portBorderOffset + labelBorderOffset;
                    if (portContext.labelsNextToPort) {
                        labelHeight = nodeContext.portLabelsTreatAsGroup ? portLabelCellRect.height : portLabelCell.getLabels().get((int)0).getSize().y;
                        portLabelCellRect.y = (portSize.y - labelHeight) / 2.0;
                    } else {
                        portLabelCellRect.y = portSize.y + portLabelSpacing;
                    }
                    portLabelCell.setHorizontalAlignment(HorizontalLabelAlignment.LEFT);
                    portLabelCell.setVerticalAlignment(VerticalLabelAlignment.CENTER);
                }
            }
            if (portSide != PortSide.NORTH && portSide != PortSide.SOUTH) continue;
            insideNorthOrSouthPortLabelAreaHeight = Math.max(insideNorthOrSouthPortLabelAreaHeight, portLabelCellRect.height);
        }
        if (insideNorthOrSouthPortLabelAreaHeight > 0.0) {
            nodeContext.insidePortLabelCells.get((Object)portSide).getMinimumContentAreaSize().y = insideNorthOrSouthPortLabelAreaHeight;
        }
    }

    private static double portLabelBorderOffsetForPortSide(NodeContext nodeContext, PortSide portSide) {
        switch (portSide) {
            case NORTH: {
                return nodeContext.nodeContainer.getPadding().top + nodeContext.portLabelSpacing;
            }
            case SOUTH: {
                return nodeContext.nodeContainer.getPadding().bottom + nodeContext.portLabelSpacing;
            }
            case EAST: {
                return nodeContext.nodeContainer.getPadding().right + nodeContext.portLabelSpacing;
            }
            case WEST: {
                return nodeContext.nodeContainer.getPadding().left + nodeContext.portLabelSpacing;
            }
        }
        assert (false);
        return 0.0;
    }

    private static void constrainedInsidePortLabelPlacement(NodeContext nodeContext, PortSide portSide) {
        Collection portContexts = nodeContext.portContexts.get((Object)portSide);
        if (portSide == PortSide.EAST || portSide == PortSide.WEST) {
            PortLabelPlacementCalculator.simpleInsidePortLabelPlacement(nodeContext, portSide);
            return;
        }
        RectangleStripOverlapRemover.OverlapRemovalDirection overlapRemovalDirection = portSide == PortSide.NORTH ? RectangleStripOverlapRemover.OverlapRemovalDirection.DOWN : RectangleStripOverlapRemover.OverlapRemovalDirection.UP;
        VerticalLabelAlignment verticalLabelAlignment = portSide == PortSide.NORTH ? VerticalLabelAlignment.TOP : VerticalLabelAlignment.BOTTOM;
        AtomicCell insidePortLabelContainer = nodeContext.insidePortLabelCells.get(portSide);
        ElkRectangle labelContainerRect = insidePortLabelContainer.getCellRectangle();
        double leftBorder = labelContainerRect.x + ElkMath.maxd((double[])new double[]{insidePortLabelContainer.getPadding().left, nodeContext.surroundingPortMargins.left, nodeContext.nodeLabelSpacing});
        double rightBorder = labelContainerRect.x + labelContainerRect.width - ElkMath.maxd((double[])new double[]{insidePortLabelContainer.getPadding().right, nodeContext.surroundingPortMargins.right, nodeContext.nodeLabelSpacing});
        RectangleStripOverlapRemover overlapRemover = RectangleStripOverlapRemover.createForDirection(overlapRemovalDirection).withGap(nodeContext.portLabelSpacing);
        double startCoordinate = portSide == PortSide.NORTH ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        for (PortContext portContext : portContexts) {
            if (portContext.portLabelCell == null || !portContext.portLabelCell.hasLabels()) continue;
            KVector portSize = portContext.port.getSize();
            KVector portPosition = portContext.portPosition;
            LabelCell portLabelCell = portContext.portLabelCell;
            ElkRectangle portLabelCellRect = portLabelCell.getCellRectangle();
            portLabelCellRect.width = portLabelCell.getMinimumWidth();
            portLabelCellRect.height = portLabelCell.getMinimumHeight();
            portLabelCell.setVerticalAlignment(verticalLabelAlignment);
            portLabelCell.setHorizontalAlignment(HorizontalLabelAlignment.RIGHT);
            PortLabelPlacementCalculator.centerPortLabel(portLabelCellRect, portPosition, portSize, leftBorder, rightBorder);
            overlapRemover.addRectangle(portLabelCellRect);
            double d = startCoordinate = portSide == PortSide.NORTH ? Math.max(startCoordinate, portPosition.y + portContext.port.getSize().y) : Math.min(startCoordinate, portPosition.y);
        }
        double stripHeight = overlapRemover.withStartCoordinate(startCoordinate += portSide == PortSide.NORTH ? nodeContext.portLabelSpacing : -nodeContext.portLabelSpacing).removeOverlaps();
        if (stripHeight > 0.0) {
            nodeContext.insidePortLabelCells.get((Object)portSide).getMinimumContentAreaSize().y = stripHeight;
        }
        for (PortContext portContext : portContexts) {
            if (portContext.portLabelCell == null || !portContext.portLabelCell.hasLabels()) continue;
            ElkRectangle portLabelCellRect = portContext.portLabelCell.getCellRectangle();
            portLabelCellRect.x -= portContext.portPosition.x;
            portLabelCellRect.y -= portContext.portPosition.y;
        }
    }

    private static void centerPortLabel(ElkRectangle portLabelCellRect, KVector portPosition, KVector portSize, double minX, double maxX) {
        portLabelCellRect.x = portPosition.x - (portLabelCellRect.width - portSize.x) / 2.0;
        double actualMinX = Math.min(minX, portPosition.x);
        double actualMaxX = Math.max(maxX, portPosition.x + portSize.x);
        if (portLabelCellRect.x < actualMinX) {
            portLabelCellRect.x = actualMinX;
        } else if (portLabelCellRect.x + portLabelCellRect.width > actualMaxX) {
            portLabelCellRect.x = actualMaxX - portLabelCellRect.width;
        }
    }

    private static void simpleOutsidePortLabelPlacement(NodeContext nodeContext, PortSide portSide) {
        Collection portContexts = nodeContext.portContexts.get((Object)portSide);
        boolean placeFirstPortDifferently = NodeLabelAndSizeUtilities.isFirstOutsidePortLabelPlacedDifferently(nodeContext, portSide);
        for (PortContext portContext : portContexts) {
            if (portContext.portLabelCell == null || !portContext.portLabelCell.hasLabels()) continue;
            KVector portSize = portContext.port.getSize();
            LabelCell portLabelCell = portContext.portLabelCell;
            ElkRectangle portLabelCellRect = portLabelCell.getCellRectangle();
            portLabelCellRect.width = portLabelCell.getMinimumWidth();
            portLabelCellRect.height = portLabelCell.getMinimumHeight();
            switch (portSide) {
                case NORTH: {
                    if (portContext.labelsNextToPort) {
                        portLabelCellRect.x = (portSize.x - portLabelCellRect.width) / 2.0;
                        portLabelCell.setHorizontalAlignment(HorizontalLabelAlignment.CENTER);
                    } else if (placeFirstPortDifferently) {
                        portLabelCellRect.x = -portLabelCellRect.width - nodeContext.portLabelSpacing;
                        portLabelCell.setHorizontalAlignment(HorizontalLabelAlignment.RIGHT);
                    } else {
                        portLabelCellRect.x = portSize.x + nodeContext.portLabelSpacing;
                        portLabelCell.setHorizontalAlignment(HorizontalLabelAlignment.LEFT);
                    }
                    portLabelCellRect.y = -portLabelCellRect.height - nodeContext.portLabelSpacing;
                    portLabelCell.setVerticalAlignment(VerticalLabelAlignment.BOTTOM);
                    break;
                }
                case SOUTH: {
                    if (portContext.labelsNextToPort) {
                        portLabelCellRect.x = (portSize.x - portLabelCellRect.width) / 2.0;
                        portLabelCell.setHorizontalAlignment(HorizontalLabelAlignment.CENTER);
                    } else if (placeFirstPortDifferently) {
                        portLabelCellRect.x = -portLabelCellRect.width - nodeContext.portLabelSpacing;
                        portLabelCell.setHorizontalAlignment(HorizontalLabelAlignment.RIGHT);
                    } else {
                        portLabelCellRect.x = portSize.x + nodeContext.portLabelSpacing;
                        portLabelCell.setHorizontalAlignment(HorizontalLabelAlignment.LEFT);
                    }
                    portLabelCellRect.y = portSize.y + nodeContext.portLabelSpacing;
                    portLabelCell.setVerticalAlignment(VerticalLabelAlignment.TOP);
                    break;
                }
                case EAST: {
                    double labelHeight;
                    if (portContext.labelsNextToPort) {
                        labelHeight = nodeContext.portLabelsTreatAsGroup ? portLabelCellRect.height : portLabelCell.getLabels().get((int)0).getSize().y;
                        portLabelCellRect.y = (portSize.y - labelHeight) / 2.0;
                        portLabelCell.setVerticalAlignment(VerticalLabelAlignment.CENTER);
                    } else if (placeFirstPortDifferently) {
                        portLabelCellRect.y = -portLabelCellRect.height - nodeContext.portLabelSpacing;
                        portLabelCell.setVerticalAlignment(VerticalLabelAlignment.BOTTOM);
                    } else {
                        portLabelCellRect.y = portSize.y + nodeContext.portLabelSpacing;
                        portLabelCell.setVerticalAlignment(VerticalLabelAlignment.TOP);
                    }
                    portLabelCellRect.x = portSize.x + nodeContext.portLabelSpacing;
                    portLabelCell.setHorizontalAlignment(HorizontalLabelAlignment.LEFT);
                    break;
                }
                case WEST: {
                    double labelHeight;
                    if (portContext.labelsNextToPort) {
                        labelHeight = nodeContext.portLabelsTreatAsGroup ? portLabelCellRect.height : portLabelCell.getLabels().get((int)0).getSize().y;
                        portLabelCellRect.y = (portSize.y - labelHeight) / 2.0;
                        portLabelCell.setVerticalAlignment(VerticalLabelAlignment.CENTER);
                    } else if (placeFirstPortDifferently) {
                        portLabelCellRect.y = -portLabelCellRect.height - nodeContext.portLabelSpacing;
                        portLabelCell.setVerticalAlignment(VerticalLabelAlignment.BOTTOM);
                    } else {
                        portLabelCellRect.y = portSize.y + nodeContext.portLabelSpacing;
                        portLabelCell.setVerticalAlignment(VerticalLabelAlignment.TOP);
                    }
                    portLabelCellRect.x = -portLabelCellRect.width - nodeContext.portLabelSpacing;
                    portLabelCell.setHorizontalAlignment(HorizontalLabelAlignment.RIGHT);
                }
            }
            placeFirstPortDifferently = false;
        }
    }

    private static void constrainedOutsidePortLabelPlacement(NodeContext nodeContext, PortSide portSide) {
        Collection portContexts = nodeContext.portContexts.get((Object)portSide);
        if (portContexts.size() <= 2 || portSide == PortSide.EAST || portSide == PortSide.WEST) {
            PortLabelPlacementCalculator.simpleOutsidePortLabelPlacement(nodeContext, portSide);
            return;
        }
        boolean portWithSpecialNeeds = nodeContext.portLabelsPlacement.contains(PortLabelPlacement.SPACE_EFFICIENT);
        RectangleStripOverlapRemover.OverlapRemovalDirection overlapRemovalDirection = portSide == PortSide.NORTH ? RectangleStripOverlapRemover.OverlapRemovalDirection.UP : RectangleStripOverlapRemover.OverlapRemovalDirection.DOWN;
        VerticalLabelAlignment verticalLabelAlignment = portSide == PortSide.NORTH ? VerticalLabelAlignment.BOTTOM : VerticalLabelAlignment.TOP;
        RectangleStripOverlapRemover overlapRemover = RectangleStripOverlapRemover.createForDirection(overlapRemovalDirection).withGap(nodeContext.portLabelSpacing);
        double startCoordinate = portSide == PortSide.NORTH ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        for (PortContext portContext : portContexts) {
            if (portContext.portLabelCell == null || !portContext.portLabelCell.hasLabels()) continue;
            KVector portSize = portContext.port.getSize();
            KVector portPosition = portContext.portPosition;
            LabelCell portLabelCell = portContext.portLabelCell;
            ElkRectangle portLabelCellRect = portLabelCell.getCellRectangle();
            portLabelCellRect.width = portLabelCell.getMinimumWidth();
            portLabelCellRect.height = portLabelCell.getMinimumHeight();
            if (portWithSpecialNeeds) {
                portLabelCellRect.x = portPosition.x - portLabelCell.getMinimumWidth() - nodeContext.portLabelSpacing;
                portWithSpecialNeeds = false;
            } else {
                portLabelCellRect.x = portPosition.x + portSize.x + nodeContext.portLabelSpacing;
            }
            portLabelCell.setVerticalAlignment(verticalLabelAlignment);
            portLabelCell.setHorizontalAlignment(HorizontalLabelAlignment.RIGHT);
            overlapRemover.addRectangle(portLabelCellRect);
            double d = startCoordinate = portSide == PortSide.NORTH ? Math.min(startCoordinate, portPosition.y) : Math.max(startCoordinate, portPosition.y + portContext.port.getSize().y);
        }
        overlapRemover.withStartCoordinate(startCoordinate += portSide == PortSide.NORTH ? -nodeContext.portLabelSpacing : nodeContext.portLabelSpacing).removeOverlaps();
        for (PortContext portContext : portContexts) {
            if (portContext.portLabelCell == null || !portContext.portLabelCell.hasLabels()) continue;
            ElkRectangle portLabelCellRect = portContext.portLabelCell.getCellRectangle();
            portLabelCellRect.x -= portContext.portPosition.x;
            portLabelCellRect.y -= portContext.portPosition.y;
        }
    }
}

