/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.workspace.internal.schema;

import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.LinkedHashSet;
import java.util.function.Function;
import org.eclipse.sirius.services.graphql.common.api.ISiriusGraphQLSchemaCustomizer;
import org.eclipse.sirius.services.graphql.common.api.ISiriusGraphQLTypeCustomizer;
import org.eclipse.sirius.services.graphql.common.api.SiriusGraphQLFilterStatus;
import org.eclipse.sirius.services.graphql.common.api.pagination.PageInfoTypeProvider;
import org.eclipse.sirius.services.graphql.workspace.internal.schema.ContainerTypesProvider;
import org.eclipse.sirius.services.graphql.workspace.internal.schema.FileTypeProvider;
import org.eclipse.sirius.services.graphql.workspace.internal.schema.FolderTypeProvider;
import org.eclipse.sirius.services.graphql.workspace.internal.schema.ProjectTypeProvider;
import org.eclipse.sirius.services.graphql.workspace.internal.schema.ResourceTypeProvider;

public class WorkspaceSchemaCustomizer
implements ISiriusGraphQLSchemaCustomizer {
    public String getIdentifier() {
        return "org.eclipse.sirius.services.graphql.workspace";
    }

    public GraphQLSchema.Builder customize(GraphQLSchema.Builder graphQLSchemaBuilder, Function<GraphQLType, SiriusGraphQLFilterStatus> typeFilter, ISiriusGraphQLTypeCustomizer graphQLTypeCustomizer) {
        LinkedHashSet<GraphQLType> types = new LinkedHashSet<GraphQLType>();
        types.add(new ResourceTypeProvider().getType(graphQLTypeCustomizer));
        types.addAll(new ContainerTypesProvider().getTypes(graphQLTypeCustomizer));
        types.add(new ProjectTypeProvider().getType(graphQLTypeCustomizer));
        types.add(new FolderTypeProvider().getType(graphQLTypeCustomizer));
        types.add(new FileTypeProvider().getType(graphQLTypeCustomizer));
        types.add(new PageInfoTypeProvider().getType(graphQLTypeCustomizer));
        types.removeIf(graphQLType -> SiriusGraphQLFilterStatus.REJECT.equals(typeFilter.apply((GraphQLType)graphQLType)));
        return graphQLSchemaBuilder.additionalTypes(types);
    }
}

