/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.ui.rendering;

import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.ui.rendering.GraphRenderer;
import org.eclipse.elk.core.ui.rendering.GraphRenderingConfigurator;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GraphRenderingCanvas
extends Canvas
implements PaintListener {
    private static final double ZOOM_PER_WHEEL_UNIT = 1.01;
    private ElkNode layoutGraph;
    private final GraphRenderer graphRenderer;
    private Color backgroundColor;

    public GraphRenderingCanvas(Composite parent) {
        this(parent, new GraphRenderingConfigurator(parent.getDisplay()));
    }

    public GraphRenderingCanvas(Composite parent, GraphRenderingConfigurator configurator) {
        super(parent, 0);
        if (!configurator.getDisplay().equals(parent.getDisplay())) {
            throw new IllegalArgumentException("configurator and parent composite must use the same display.");
        }
        this.addPaintListener(this);
        this.graphRenderer = new GraphRenderer(configurator);
        this.backgroundColor = new Color((Device)parent.getDisplay(), 255, 255, 255);
        this.setBackground(this.backgroundColor);
    }

    public void dispose() {
        this.graphRenderer.dispose();
        this.backgroundColor.dispose();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (this.layoutGraph == null) {
            return super.computeSize(wHint, hHint, changed);
        }
        this.checkWidget();
        int width = (int)(this.layoutGraph.getWidth() + 0.5);
        int height = (int)(this.layoutGraph.getHeight() + 0.5);
        if (wHint > width) {
            width = wHint;
        }
        if (hHint > height) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    public GraphRenderer getRenderer() {
        return this.graphRenderer;
    }

    public ElkNode getLayoutGraph() {
        return this.layoutGraph;
    }

    public void setLayoutGraph(ElkNode graph) {
        KVector baseOffset = this.calculateRequiredCanvasSizeAndBaseOffset(graph);
        this.layoutGraph = graph;
        this.graphRenderer.setBaseOffset(baseOffset);
        this.redraw();
    }

    private KVector calculateRequiredCanvasSizeAndBaseOffset(ElkNode graph) {
        if (graph != null) {
            double minX = Double.MAX_VALUE;
            double maxX = Double.MIN_VALUE;
            double minY = Double.MAX_VALUE;
            double maxY = Double.MIN_VALUE;
            for (ElkNode node : graph.getChildren()) {
                minX = Math.min(minX, node.getX());
                maxX = Math.max(maxX, node.getX() + node.getWidth());
                minY = Math.min(minY, node.getY());
                maxY = Math.max(maxY, node.getY() + node.getHeight());
                for (ElkLabel nodeLabel : node.getLabels()) {
                    minX = Math.min(minX, node.getX() + nodeLabel.getX());
                    maxX = Math.max(maxX, node.getX() + nodeLabel.getX() + nodeLabel.getWidth());
                    minY = Math.min(minY, node.getY() + nodeLabel.getY());
                    maxY = Math.max(maxY, node.getY() + nodeLabel.getY() + nodeLabel.getHeight());
                }
            }
            for (ElkEdge edge : graph.getContainedEdges()) {
                for (ElkEdgeSection edgeSection : edge.getSections()) {
                    minX = Math.min(minX, edgeSection.getStartX());
                    minY = Math.min(minY, edgeSection.getStartY());
                    maxX = Math.max(maxX, edgeSection.getStartX());
                    maxY = Math.max(maxY, edgeSection.getStartY());
                    minX = Math.min(minX, edgeSection.getEndX());
                    minY = Math.min(minY, edgeSection.getEndY());
                    maxX = Math.max(maxX, edgeSection.getEndX());
                    maxY = Math.max(maxY, edgeSection.getEndY());
                    for (ElkBendPoint bendPoint : edgeSection.getBendPoints()) {
                        minX = Math.min(minX, bendPoint.getX());
                        minY = Math.min(minY, bendPoint.getY());
                        maxX = Math.max(maxX, bendPoint.getX());
                        maxY = Math.max(maxY, bendPoint.getY());
                    }
                }
                for (ElkLabel edgeLabel : edge.getLabels()) {
                    minX = Math.min(minX, edgeLabel.getX());
                    maxX = Math.max(maxX, edgeLabel.getX() + edgeLabel.getWidth());
                    minY = Math.min(minY, edgeLabel.getY());
                    maxY = Math.max(maxY, edgeLabel.getY() + edgeLabel.getHeight());
                }
            }
            int x = (int)(Math.max(graph.getWidth(), maxX) - Math.min(0.0, minX)) + 1;
            int y = (int)(Math.max(graph.getHeight(), maxY) - Math.min(0.0, minY)) + 1;
            this.setSize(new Point(x, y));
            return new KVector(-Math.min(0.0, minX), -Math.min(0.0, minY));
        }
        return new KVector();
    }

    public void setupMouseInteraction() {
        this.addListener(37, event -> {
            double zoom = Math.pow(1.01, -event.count);
            this.zoom(zoom, new KVector((double)event.x, (double)event.y));
            this.redraw();
            event.doit = false;
        });
        Listener dragListener = new Listener(){
            private boolean isDragging;
            private int lastX;
            private int lastY;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: {
                        this.isDragging = true;
                        break;
                    }
                    case 4: {
                        this.isDragging = false;
                        break;
                    }
                    case 5: {
                        if (!this.isDragging) break;
                        KVector delta = new KVector((double)(event.x - this.lastX), (double)(event.y - this.lastY));
                        GraphRenderingCanvas.this.pan(delta);
                        GraphRenderingCanvas.this.redraw();
                    }
                }
                this.lastX = event.x;
                this.lastY = event.y;
            }
        };
        this.addListener(3, dragListener);
        this.addListener(4, dragListener);
        this.addListener(5, dragListener);
    }

    protected void zoom(double zoom, KVector focusPoint) {
        double newScale = this.graphRenderer.getScale() * zoom;
        this.graphRenderer.setScale(newScale);
        KVector absFocus = KVector.diff((KVector)focusPoint, (KVector)this.graphRenderer.getBaseOffset());
        this.graphRenderer.setBaseOffset(absFocus.scale(zoom).sub(focusPoint).negate());
    }

    protected void pan(KVector delta) {
        KVector offset = this.graphRenderer.getBaseOffset().add(delta);
        this.graphRenderer.setBaseOffset(offset);
    }

    public void paintControl(PaintEvent event) {
        if (this.layoutGraph != null) {
            Rectangle area = new Rectangle(event.x, event.y, event.width, event.height);
            this.graphRenderer.markDirty(area);
            this.graphRenderer.render(this.layoutGraph, event.gc, area);
        }
    }
}

