/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.ui.preferences;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.elk.core.service.ElkServicePlugin;
import org.eclipse.elk.core.ui.ElkUiPlugin;
import org.eclipse.elk.core.ui.Messages;
import org.eclipse.elk.core.ui.views.LayoutViewPart;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LayoutPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button animationCheckBox;
    private Button zoomCheckBox;
    private Button progressCheckBox;
    private Button enableLoggingCheckBox;
    private Button storeLogsCheckBox;
    private Button execTimeCheckBox;
    private Button openLogFolderButton;
    private static final int VERTICAL_LAYOUT_SPACING = 10;
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 5;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, false);
        compositeLayout.verticalSpacing = 10;
        composite.setLayout((Layout)compositeLayout);
        Group generalGroup = this.createGeneralOptionsGroup(composite);
        generalGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        Group devOptionsGroup = this.createDeveloperOptionsGroup(composite);
        devOptionsGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        return composite;
    }

    private Group createGeneralOptionsGroup(Composite parent) {
        IPreferenceStore mainPrefStore = this.getPreferenceStore();
        Group generalGroup = new Group(parent, 0);
        generalGroup.setText(Messages.getString("LayoutPreferencePage.generalGroup.text"));
        this.animationCheckBox = new Button((Composite)generalGroup, 16416);
        this.animationCheckBox.setText(Messages.getString("LayoutPreferencePage.animations.text"));
        this.animationCheckBox.setToolTipText(Messages.getString("LayoutPreferencePage.animations.tip"));
        this.animationCheckBox.setSelection(mainPrefStore.getBoolean("org.eclipse.elk.animation"));
        this.zoomCheckBox = new Button((Composite)generalGroup, 16416);
        this.zoomCheckBox.setText(Messages.getString("LayoutPreferencePage.zoom.text"));
        this.zoomCheckBox.setToolTipText(Messages.getString("LayoutPreferencePage.zoom.tip"));
        this.zoomCheckBox.setSelection(mainPrefStore.getBoolean("org.eclipse.elk.zoomToFit"));
        this.progressCheckBox = new Button((Composite)generalGroup, 16416);
        this.progressCheckBox.setText(Messages.getString("LayoutPreferencePage.progress.text"));
        this.progressCheckBox.setToolTipText(Messages.getString("LayoutPreferencePage.progress.tip"));
        this.progressCheckBox.setSelection(mainPrefStore.getBoolean("org.eclipse.elk.progressDialog"));
        FillLayout layout = new FillLayout(512);
        layout.marginWidth = 10;
        layout.marginHeight = 5;
        layout.spacing = LayoutConstants.getSpacing().y;
        generalGroup.setLayout((Layout)layout);
        return generalGroup;
    }

    private Group createDeveloperOptionsGroup(Composite parent) {
        IPreferenceStore servicePrefStore = ElkServicePlugin.getInstance().getPreferenceStore();
        Group developerGroup = new Group(parent, 0);
        developerGroup.setText(Messages.getString("LayoutPreferencePage.developerGroup.text"));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        layout.marginHeight = 5;
        layout.verticalSpacing = LayoutConstants.getSpacing().y;
        developerGroup.setLayout((Layout)layout);
        this.execTimeCheckBox = new Button((Composite)developerGroup, 16416);
        this.execTimeCheckBox.setText(Messages.getString("LayoutPreferencePage.execTime.text"));
        this.execTimeCheckBox.setToolTipText(Messages.getString("LayoutPreferencePage.execTime.tip"));
        this.execTimeCheckBox.setSelection(servicePrefStore.getBoolean("elk.debug.exectime"));
        this.enableLoggingCheckBox = new Button((Composite)developerGroup, 16416);
        this.enableLoggingCheckBox.setText(Messages.getString("LayoutPreferencePage.enableLogging.text"));
        this.enableLoggingCheckBox.setToolTipText(Messages.getString("LayoutPreferencePage.enableLogging.tip"));
        this.enableLoggingCheckBox.setSelection(servicePrefStore.getBoolean("elk.debug.logs"));
        this.storeLogsCheckBox = new Button((Composite)developerGroup, 16416);
        this.storeLogsCheckBox.setText(Messages.getString("LayoutPreferencePage.storeLogs.text"));
        this.storeLogsCheckBox.setToolTipText(Messages.getString("LayoutPreferencePage.storeLogs.tip"));
        this.storeLogsCheckBox.setSelection(servicePrefStore.getBoolean("elk.debug.store"));
        GridData layoutData = new GridData();
        layoutData.horizontalIndent = LayoutConstants.getIndent();
        this.storeLogsCheckBox.setLayoutData((Object)layoutData);
        this.openLogFolderButton = new Button((Composite)developerGroup, 8);
        this.openLogFolderButton.setText(Messages.getString("LayoutPreferencePage.openLogFolder.text"));
        this.openLogFolderButton.setToolTipText(Messages.getString("LayoutPreferencePage.openLogFolder.tip"));
        this.openLogFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Path debugPath = Paths.get(ElkUtil.debugFolderPath((String[])new String[0]), new String[0]);
                if (Files.isDirectory(debugPath, new LinkOption[0])) {
                    Program.launch((String)debugPath.toString());
                }
            }
        });
        layoutData = new GridData();
        layoutData.verticalIndent = LayoutConstants.getIndent();
        this.openLogFolderButton.setLayoutData((Object)layoutData);
        return developerGroup;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(ElkUiPlugin.getInstance().getPreferenceStore());
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore mainPrefStore = this.getPreferenceStore();
        IPreferenceStore servicePrefStore = ElkServicePlugin.getInstance().getPreferenceStore();
        this.animationCheckBox.setSelection(mainPrefStore.getDefaultBoolean("org.eclipse.elk.animation"));
        this.zoomCheckBox.setSelection(mainPrefStore.getDefaultBoolean("org.eclipse.elk.zoomToFit"));
        this.progressCheckBox.setSelection(mainPrefStore.getDefaultBoolean("org.eclipse.elk.progressDialog"));
        this.execTimeCheckBox.setSelection(servicePrefStore.getDefaultBoolean("elk.debug.exectime"));
        this.enableLoggingCheckBox.setSelection(servicePrefStore.getDefaultBoolean("elk.debug.logs"));
        this.storeLogsCheckBox.setSelection(servicePrefStore.getDefaultBoolean("elk.debug.store"));
    }

    public boolean performOk() {
        IPreferenceStore mainPrefStore = this.getPreferenceStore();
        IPreferenceStore servicePrefStore = ElkServicePlugin.getInstance().getPreferenceStore();
        mainPrefStore.setValue("org.eclipse.elk.animation", this.animationCheckBox.getSelection());
        mainPrefStore.setValue("org.eclipse.elk.zoomToFit", this.zoomCheckBox.getSelection());
        mainPrefStore.setValue("org.eclipse.elk.progressDialog", this.progressCheckBox.getSelection());
        servicePrefStore.setValue("elk.debug.exectime", this.execTimeCheckBox.getSelection());
        servicePrefStore.setValue("elk.debug.logs", this.enableLoggingCheckBox.getSelection());
        servicePrefStore.setValue("elk.debug.store", this.storeLogsCheckBox.getSelection());
        LayoutViewPart layoutView = LayoutViewPart.findView();
        if (layoutView != null) {
            layoutView.refresh();
        }
        return true;
    }
}

