/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.BundledImage;
import org.eclipse.sirius.diagram.BundledImageShape;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractNotSelectableShapeNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IStyleEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramBorderNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.FixedLayoutEditPolicy;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.figure.BundledImageFigure;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.AirStyleDefaultSizeNodeFigure;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.LabelStyle;
import org.eclipse.sirius.viewpoint.description.SystemColors;

public class BundledImageEditPart
extends AbstractNotSelectableShapeNodeEditPart
implements IStyleEditPart {
    public static final int VISUAL_ID = 3004;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public DragTracker getDragTracker(Request request) {
        return this.getParent().getDragTracker(request);
    }

    public BundledImageEditPart(View view) {
        super(view);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        BundledImageFigure figure = this.getPrimaryShape();
        EObject element = this.resolveSemanticElement();
        if (element instanceof BundledImage) {
            BundledImage bundledImage = (BundledImage)element;
            figure.refreshFigure(bundledImage);
            DiagramNodeEditPartOperation.refreshFigure(this);
            DiagramElementEditPartOperation.refreshLabelAlignment(((GraphicalEditPart)this.getParent()).getContentPane(), (LabelStyle)bundledImage);
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new Rectangle(0, 0, figure.getPreferredSize().width, figure.getPreferredSize().height));
        }
    }

    protected void createDefaultEditPolicies() {
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        return new FixedLayoutEditPolicy();
    }

    protected IFigure createNodeShape() {
        BundledImageFigure bif;
        if (this.getMetamodelType().isInstance(this.resolveSemanticElement())) {
            bif = (BundledImageFigure)BundledImageFigure.createImageFigure((BundledImage)this.resolveSemanticElement());
        } else {
            DiagramPlugin.getDefault().logWarning(Messages.BundledImageEditPart_notBundleImageMsg);
            BundledImage bundle = DiagramFactory.eINSTANCE.createBundledImage();
            bundle.setShape(BundledImageShape.SQUARE_LITERAL);
            bundle.getLabelFormat().clear();
            bundle.setLabelSize(10);
            bundle.setColor(VisualBindingManager.getDefault().getRGBValuesFor(SystemColors.BLUE_LITERAL));
            bundle.setBorderColor(VisualBindingManager.getDefault().getRGBValuesFor(SystemColors.DARK_BLUE_LITERAL));
            bif = (BundledImageFigure)BundledImageFigure.createImageFigure(bundle);
        }
        EditPart parent = this.getParent();
        if (parent instanceof IDiagramBorderNodeEditPart) {
            DiagramBorderNodeEditPartOperation.updateTransparencyMode((IDiagramBorderNodeEditPart)parent, bif);
        }
        this.primaryShape = bif;
        return this.primaryShape;
    }

    public BundledImageFigure getPrimaryShape() {
        return (BundledImageFigure)this.primaryShape;
    }

    protected NodeFigure createNodePlate() {
        return new AirStyleDefaultSizeNodeFigure(this.getMapMode().DPtoLP(40), this.getMapMode().DPtoLP(40));
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        EditPolicy result = super.getPrimaryDragEditPolicy();
        if (result instanceof ResizableEditPolicy) {
            ResizableEditPolicy ep = (ResizableEditPolicy)result;
            ep.setResizeDirections(0);
        }
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected Class<?> getMetamodelType() {
        return BundledImage.class;
    }
}

