/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.query;

import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.services.common.api.SiriusServicesCommonOptionalUtils;
import org.eclipse.sirius.services.graphql.common.api.directives.SiriusGraphQLCostDirective;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLConnection;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLPaginationArguments;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLPaginationDataFetcher;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;

public final class FileRepresentationsField {
    private static final String REPRESENTATIONS = "representations";
    private static final int REPRESENTATIONS_COMPLEXITY = 1;

    private FileRepresentationsField() {
    }

    public static GraphQLFieldDefinition build() {
        ArrayList<String> multipliers = new ArrayList<String>();
        multipliers.add("first");
        multipliers.add("last");
        return GraphQLFieldDefinition.newFieldDefinition().name(REPRESENTATIONS).type((GraphQLOutputType)new GraphQLTypeReference("FileRepresentationConnection")).argument(SiriusGraphQLPaginationArguments.build()).withDirective(new SiriusGraphQLCostDirective(1, multipliers).build()).dataFetcher(FileRepresentationsField.getRepresentationsDataFetcher()).build();
    }

    private static DataFetcher<SiriusGraphQLConnection> getRepresentationsDataFetcher() {
        return SiriusGraphQLPaginationDataFetcher.build(environment -> {
            Optional<IFile> optionalFile = Optional.of(environment.getSource()).filter(IFile.class::isInstance).map(IFile.class::cast);
            Optional optionalSession = optionalFile.map(IResource::getProject).flatMap(SiriusServicesCommonOptionalUtils::toSession);
            ArrayList<DRepresentation> representations = new ArrayList<DRepresentation>();
            if (optionalFile.isPresent() && optionalSession.isPresent()) {
                IFile iFile = optionalFile.get();
                Session session = (Session)optionalSession.get();
                Collection representationDescriptors = DialectManager.INSTANCE.getAllRepresentationDescriptors(session);
                for (DRepresentationDescriptor representationDescriptor : representationDescriptors) {
                    URI fileUri;
                    EObject eObject = representationDescriptor.getTarget();
                    URI uri = eObject.eResource().getURI();
                    if (!uri.equals(fileUri = URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true))) continue;
                    representations.add(representationDescriptor.getRepresentation());
                }
            }
            return representations;
        }, FileRepresentationsField::computeRepresentationCursor);
    }

    private static String computeRepresentationCursor(DRepresentation dRepresentation) {
        String unEncodedCursor = EcoreUtil.getURI((EObject)dRepresentation).toString();
        return Base64.getEncoder().encodeToString(unEncodedCursor.getBytes());
    }
}

