/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards.pages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class GenericInitialObjectPage
extends WizardPage {
    protected Combo initialObjectField;
    protected Combo encodingField;
    protected List<String> encodings;
    protected List<String> initialObjectNames;
    protected EPackage ePackage;
    protected ModifyListener validator = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            GenericInitialObjectPage.this.setPageComplete(GenericInitialObjectPage.this.validatePage());
        }
    };

    public GenericInitialObjectPage(String pageId) {
        super(pageId);
    }

    public void setEPackage(EPackage ePackage) {
        this.ePackage = ePackage;
        this.initialObjectNames = null;
        if (this.initialObjectField != null) {
            this.initialObjectField.removeAll();
            this.fillInitialObjectField();
        }
    }

    protected Collection<String> getInitialObjectNames() {
        if (this.initialObjectNames == null) {
            this.initialObjectNames = new ArrayList<String>();
            for (EClassifier eClassifier : this.ePackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                this.initialObjectNames.add(eClass.getName());
            }
            Collections.sort(this.initialObjectNames, CommonPlugin.INSTANCE.getComparator());
        }
        return this.initialObjectNames;
    }

    protected Collection<String> getEncodings() {
        if (this.encodings == null) {
            this.encodings = new ArrayList<String>();
            this.encodings.add("UTF-8");
            this.encodings.add("ASCII");
            this.encodings.add("UTF-16");
            this.encodings.add("UTF-16BE");
            this.encodings.add("UTF-16LE");
            this.encodings.add("ISO-8859-1");
        }
        return this.encodings;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 12;
        composite.setLayout((Layout)layout);
        GridData compositeData = new GridData();
        compositeData.verticalAlignment = 4;
        compositeData.grabExcessVerticalSpace = true;
        compositeData.horizontalAlignment = 4;
        composite.setLayoutData((Object)compositeData);
        Label containerLabel = new Label(composite, 16384);
        containerLabel.setText(Messages.GenericInitialObjectPage_containerLabel);
        GridData containerData = new GridData();
        containerData.horizontalAlignment = 4;
        containerLabel.setLayoutData((Object)containerData);
        this.initialObjectField = new Combo(composite, 2048);
        GridData initialObjectData = new GridData();
        initialObjectData.horizontalAlignment = 4;
        initialObjectData.grabExcessHorizontalSpace = true;
        this.initialObjectField.setLayoutData((Object)initialObjectData);
        this.fillInitialObjectField();
        this.initialObjectField.addModifyListener(this.validator);
        this.initialObjectField.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GenericInitialObjectPage.this.setPageComplete(GenericInitialObjectPage.this.validatePage());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label encodingLabel = new Label(composite, 16384);
        encodingLabel.setText(Messages.GenericInitialObjectPage_encodingLabel);
        GridData encodingLabelData = new GridData();
        encodingLabelData.horizontalAlignment = 4;
        encodingLabel.setLayoutData((Object)encodingLabelData);
        this.encodingField = new Combo(composite, 2048);
        GridData encodingFieldData = new GridData();
        encodingFieldData.horizontalAlignment = 4;
        encodingFieldData.grabExcessHorizontalSpace = true;
        this.encodingField.setLayoutData((Object)encodingFieldData);
        for (String encoding : this.getEncodings()) {
            this.encodingField.add(encoding);
        }
        this.encodingField.select(0);
        this.encodingField.addModifyListener(this.validator);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    private void fillInitialObjectField() {
        for (String objectName : this.getInitialObjectNames()) {
            this.initialObjectField.add(this.getLabel(objectName));
        }
        if (this.initialObjectField.getItemCount() == 1) {
            this.initialObjectField.select(0);
        }
    }

    protected boolean validatePage() {
        return this.getInitialObjectName() != null && this.getEncodings().contains(this.encodingField.getText());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.initialObjectField.getItemCount() == 1) {
                this.initialObjectField.clearSelection();
                this.encodingField.setFocus();
            } else {
                this.encodingField.clearSelection();
                this.initialObjectField.setFocus();
            }
        }
    }

    public String getInitialObjectName() {
        String label = this.initialObjectField.getText();
        for (String name : this.getInitialObjectNames()) {
            if (!this.getLabel(name).equals(label)) continue;
            return name;
        }
        return null;
    }

    public String getEncoding() {
        return this.encodingField.getText();
    }

    protected String getLabel(String typeName) {
        String label = SiriusEditPlugin.getPlugin().getItemText(typeName);
        return label != null ? label : typeName;
    }
}

