/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.condition;

import org.eclipse.sirius.tests.swtbot.support.api.business.UIDiagramRepresentation;
import org.eclipse.sirius.tests.swtbot.support.api.business.UILocalSession;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;

public class SessionCondition
extends DefaultCondition {
    private final UILocalSession session;
    private final String viewpointName;
    private final String representationName;
    private final String representationInstanceName;

    public SessionCondition(UILocalSession session, String viewpointName, String representationName, String representationInstanceName) {
        this.session = session;
        this.viewpointName = viewpointName;
        this.representationName = representationName;
        this.representationInstanceName = representationInstanceName;
    }

    public String getFailureMessage() {
        return "The session " + this.session + "is not correctly opened";
    }

    public boolean test() throws Exception {
        boolean sessionOpenedCorectly;
        try {
            this.session.getLocalSessionBrowser().perCategory().selectViewpoint(this.viewpointName).selectRepresentation(this.representationName).selectRepresentationInstance(this.representationInstanceName, UIDiagramRepresentation.class).open();
            sessionOpenedCorectly = true;
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            sessionOpenedCorectly = false;
        }
        return sessionOpenedCorectly;
    }
}

