/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.internal;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.server.api.ISiriusServerService;
import org.eclipse.sirius.server.api.SiriusServerPath;
import org.eclipse.sirius.server.api.SiriusServerResponse;
import org.eclipse.sirius.server.internal.SiriusServerMatchResult;
import org.eclipse.sirius.server.internal.SiriusServerPathMatcher;
import org.eclipse.sirius.server.internal.SiriusServerPlugin;
import org.eclipse.sirius.server.internal.services.SiriusServerCSPViolationReportService;

public class SiriusServerFilter
implements Filter {
    private static final String UTF_8 = "UTF-8";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest && resp instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)resp;
            Optional<SiriusServerResponse> optionalResponse = this.processRequest(request);
            if (optionalResponse.isPresent()) {
                SiriusServerResponse httpServiceResponse = optionalResponse.get();
                response.setStatus(httpServiceResponse.getStatus());
                response.setContentType(httpServiceResponse.getContentType());
                response.setCharacterEncoding(UTF_8);
                Optional<Object> optionalPayload = Optional.ofNullable(httpServiceResponse.getPayload());
                Optional<String> optionalJsonPayload = optionalPayload.map(arg_0 -> ((Gson)new Gson()).toJson(arg_0));
                optionalJsonPayload.ifPresent(response.getWriter()::write);
            }
        }
    }

    private Optional<SiriusServerResponse> processRequest(HttpServletRequest request) {
        List<SiriusServerServiceDescriptor> descriptors = this.getDescriptors(request);
        descriptors.sort((descriptor1, descriptor2) -> descriptor2.getResult().getVariables().size() - descriptor1.getResult().getVariables().size());
        Optional optionalDescriptor = descriptors.stream().findFirst();
        return optionalDescriptor.flatMap(descriptor -> {
            Optional<ISiriusServerService> optionalServiceInstance = this.createServiceInstance(descriptor.getServiceClass());
            Map<String, String> variables = descriptor.getResult().getVariables();
            String remainingPart = descriptor.getResult().getRemainingPart();
            return optionalServiceInstance.map(service -> service.process(request, variables, remainingPart));
        });
    }

    private List<SiriusServerServiceDescriptor> getDescriptors(HttpServletRequest request) {
        ArrayList<Class<SiriusServerCSPViolationReportService>> serviceClasses = new ArrayList<Class<SiriusServerCSPViolationReportService>>();
        serviceClasses.add(SiriusServerCSPViolationReportService.class);
        SiriusServerPlugin.getPlugin().getSiriusServerServices().stream().map(Object::getClass).forEach(serviceClasses::add);
        ArrayList<SiriusServerServiceDescriptor> descriptors = new ArrayList<SiriusServerServiceDescriptor>();
        for (Class clazz : serviceClasses) {
            SiriusServerPath siriusServerPath = clazz.getAnnotation(SiriusServerPath.class);
            String path = siriusServerPath.value();
            SiriusServerPathMatcher matcher = new SiriusServerPathMatcher(path);
            SiriusServerMatchResult result = matcher.match(request.getServletPath());
            if (!result.hasMatched()) continue;
            descriptors.add(new SiriusServerServiceDescriptor(clazz, result));
        }
        return descriptors;
    }

    private Optional<ISiriusServerService> createServiceInstance(Class<? extends ISiriusServerService> serviceClass) {
        try {
            ISiriusServerService httpService = serviceClass.newInstance();
            return Optional.of(httpService);
        }
        catch (IllegalAccessException | InstantiationException exception) {
            Status status = new Status(4, "org.eclipse.sirius.server", exception.getMessage(), (Throwable)exception);
            SiriusServerPlugin.getPlugin().log(status);
            return Optional.empty();
        }
    }

    public void destroy() {
    }

    private static class SiriusServerServiceDescriptor {
        private Class<? extends ISiriusServerService> serviceClass;
        private SiriusServerMatchResult result;

        SiriusServerServiceDescriptor(Class<? extends ISiriusServerService> serviceClass, SiriusServerMatchResult result) {
            this.serviceClass = serviceClass;
            this.result = result;
        }

        public Class<? extends ISiriusServerService> getServiceClass() {
            return this.serviceClass;
        }

        public SiriusServerMatchResult getResult() {
            return this.result;
        }
    }
}

