/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.core.internal.schema;

import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.LinkedHashSet;
import java.util.function.Function;
import org.eclipse.sirius.services.graphql.common.api.ISiriusGraphQLSchemaCustomizer;
import org.eclipse.sirius.services.graphql.common.api.ISiriusGraphQLTypeCustomizer;
import org.eclipse.sirius.services.graphql.common.api.SiriusGraphQLFilterStatus;
import org.eclipse.sirius.services.graphql.common.api.pagination.PageInfoTypeProvider;
import org.eclipse.sirius.services.graphql.core.internal.schema.DiagramDescriptionTypeProvider;
import org.eclipse.sirius.services.graphql.core.internal.schema.DiagramTypeProvider;
import org.eclipse.sirius.services.graphql.core.internal.schema.RepresentationDescriptionTypeProvider;
import org.eclipse.sirius.services.graphql.core.internal.schema.RepresentationTypeProvider;
import org.eclipse.sirius.services.graphql.core.internal.schema.ViewpointTypesBuilder;

public class CoreSchemaCustomizer
implements ISiriusGraphQLSchemaCustomizer {
    public String getIdentifier() {
        return "org.eclipse.sirius.services.graphql.core";
    }

    public GraphQLSchema.Builder customize(GraphQLSchema.Builder graphQLSchemaBuilder, Function<GraphQLType, SiriusGraphQLFilterStatus> typeFilter, ISiriusGraphQLTypeCustomizer graphQLTypeCustomizer) {
        LinkedHashSet<GraphQLType> types = new LinkedHashSet<GraphQLType>();
        types.addAll(new ViewpointTypesBuilder().getTypes(graphQLTypeCustomizer));
        types.add(new RepresentationDescriptionTypeProvider().getType(graphQLTypeCustomizer));
        types.add(new DiagramDescriptionTypeProvider().getType(graphQLTypeCustomizer));
        types.add(new RepresentationTypeProvider().getType(graphQLTypeCustomizer));
        types.add(new DiagramTypeProvider().getType(graphQLTypeCustomizer));
        types.add(new PageInfoTypeProvider().getType(graphQLTypeCustomizer));
        types.removeIf(graphQLType -> SiriusGraphQLFilterStatus.REJECT.equals(typeFilter.apply((GraphQLType)graphQLType)));
        return graphQLSchemaBuilder.additionalTypes(types);
    }
}

