/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IFuture;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.util.search.FileQueryInput;
import org.eclipse.scout.sdk.core.s.util.search.IFileQuery;
import org.eclipse.scout.sdk.core.s.util.search.IFileQueryResult;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.environment.AbstractJob;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;

public class EclipseWorkspaceWalker {
    private final String m_taskName;
    private final Collection<String> m_fileExtensions;
    private boolean m_skipOutputLocation;
    private boolean m_skipHiddenPaths;
    private boolean m_skipNodeModules;
    private BiPredicate<Path, BasicFileAttributes> m_fileFilter;

    public EclipseWorkspaceWalker(String taskName) {
        this.m_taskName = (String)Ensure.notNull((Object)taskName);
        this.m_fileExtensions = new ArrayList<String>();
        this.m_skipOutputLocation = true;
        this.m_skipHiddenPaths = true;
        this.m_skipNodeModules = true;
    }

    public static IFileQueryResult executeQuerySync(IFileQuery query, IProgressMonitor monitor) {
        return EclipseWorkspaceWalker.executeQueryInWorkspace(query, monitor);
    }

    public static IFileQueryResult executeQuerySync(BiFunction<IEnvironment, IProgress, IFileQuery> queryFactory, IProgressMonitor monitor) {
        return (IFileQueryResult)EclipseEnvironment.callInEclipseEnvironmentSync((e, p) -> EclipseWorkspaceWalker.executeQueryInWorkspace((IFileQuery)queryFactory.apply((IEnvironment)e, (IProgress)p), monitor), monitor);
    }

    public static IFuture<IFileQueryResult> executeQuery(final IFileQuery query) {
        final AtomicReference result = new AtomicReference();
        return new AbstractJob(query.name()){

            @Override
            protected void execute(IProgressMonitor monitor) {
                result.set(EclipseWorkspaceWalker.executeQueryInWorkspace(query, monitor));
            }
        }.scheduleWithFuture(0L, TimeUnit.MILLISECONDS, result::get);
    }

    protected static IFileQuery executeQueryInWorkspace(IFileQuery query, IProgressMonitor monitor) {
        try {
            new EclipseWorkspaceWalker(query.name()).walk((file, progress) -> EclipseWorkspaceWalker.executeQueryInFile(query, file), monitor);
            return query;
        }
        catch (CoreException ex) {
            throw new SdkException((Throwable)ex);
        }
    }

    protected static void executeQueryInFile(IFileQuery query, WorkspaceFile file) {
        FileQueryInput candidate = new FileQueryInput(file.path(), file.projectPath(), file::content);
        query.searchIn(candidate);
    }

    public void walk(BiConsumer<WorkspaceFile, IProgress> visitor, IProgressMonitor monitor) throws CoreException {
        Ensure.notNull(visitor);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)this.taskName(), (int)(projects.length * 2));
        for (IProject root : projects) {
            Path projectPath;
            if (!root.isAccessible()) continue;
            Set<Path> outputLocations = Collections.emptySet();
            subMonitor.subTask(root.getName());
            if (this.isSkipOutputLocation()) {
                IJavaProject jp = JavaCore.create((IProject)root);
                outputLocations = EclipseWorkspaceWalker.getOutputLocations(jp);
            }
            if (Files.exists(projectPath = root.getLocation().toFile().toPath(), new LinkOption[0])) {
                this.searchInFolder(visitor, projectPath, Charset.forName(root.getDefaultCharset()), outputLocations, (IProgressMonitor)subMonitor.newChild(1));
            }
            if (subMonitor.isCanceled()) {
                return;
            }
            subMonitor.worked(1);
        }
    }

    protected static Set<Path> getOutputLocations(IJavaProject jp) throws JavaModelException {
        if (!JdtUtils.exists((IJavaElement)jp)) {
            return Collections.emptySet();
        }
        String projectDir = jp.getProject().getLocation().toOSString();
        IClasspathEntry[] rawClasspath = jp.getRawClasspath();
        return Arrays.stream(rawClasspath).map(IClasspathEntry::getOutputLocation).filter(Objects::nonNull).map(location -> location.removeFirstSegments(1).toOSString()).map(location -> Paths.get(projectDir, location)).collect(Collectors.toSet());
    }

    protected void searchInFolder(final BiConsumer<WorkspaceFile, IProgress> visitor, final Path folder, final Charset charset, final Collection<Path> outputFolders, final IProgressMonitor monitor) {
        try {
            Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){
                final /* synthetic */ EclipseWorkspaceWalker this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (monitor.isCanceled()) {
                        return FileVisitResult.TERMINATE;
                    }
                    if (outputFolders.contains(dir)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (!this.this$0.directoryFiltersAccepted(dir, attrs)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (monitor.isCanceled()) {
                        return FileVisitResult.TERMINATE;
                    }
                    if (this.this$0.allFiltersAccepted(file, attrs)) {
                        visitor.accept(new WorkspaceFile(file, folder, charset), EclipseEnvironment.toScoutProgress(monitor));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new SdkException((Throwable)e);
        }
    }

    protected boolean directoryFiltersAccepted(Path file, BasicFileAttributes attrs) {
        if (this.isSkipHiddenPaths() && EclipseWorkspaceWalker.isHidden(file)) {
            return false;
        }
        Path fileName = file.getFileName();
        if (this.isSkipNodeModules() && fileName != null && "node_modules".equals(fileName.toString())) {
            return false;
        }
        return this.fileFilter().map(filter -> filter.test(file, attrs)).orElse(Boolean.TRUE);
    }

    protected boolean allFiltersAccepted(Path file, BasicFileAttributes attrs) {
        if (!this.acceptFileExtension(file)) {
            return false;
        }
        return this.directoryFiltersAccepted(file, attrs);
    }

    protected boolean acceptFileExtension(Path file) {
        if (this.extensionsAccepted().isEmpty()) {
            return true;
        }
        Path path = file.getFileName();
        if (path == null) {
            return false;
        }
        String fileName = path.toString().toLowerCase(Locale.US);
        return this.extensionsAccepted().stream().anyMatch(fileName::endsWith);
    }

    protected static boolean isHidden(Path path) {
        Path fileName = path.getFileName();
        return fileName != null && fileName.toString().startsWith(".");
    }

    public String taskName() {
        return this.m_taskName;
    }

    public boolean isSkipOutputLocation() {
        return this.m_skipOutputLocation;
    }

    public EclipseWorkspaceWalker withSkipOutputLocation(boolean skipOutputLocation) {
        this.m_skipOutputLocation = skipOutputLocation;
        return this;
    }

    public boolean isSkipHiddenPaths() {
        return this.m_skipHiddenPaths;
    }

    public EclipseWorkspaceWalker withSkipHiddenPaths(boolean skipHiddenPaths) {
        this.m_skipHiddenPaths = skipHiddenPaths;
        return this;
    }

    public boolean isSkipNodeModules() {
        return this.m_skipNodeModules;
    }

    public EclipseWorkspaceWalker withSkipNodeModules(boolean skipNodeModules) {
        this.m_skipNodeModules = skipNodeModules;
        return this;
    }

    public Optional<BiPredicate<Path, BasicFileAttributes>> fileFilter() {
        return Optional.ofNullable(this.m_fileFilter);
    }

    public EclipseWorkspaceWalker withFilter(BiPredicate<Path, BasicFileAttributes> fileFilter) {
        this.m_fileFilter = fileFilter;
        return this;
    }

    public Collection<String> extensionsAccepted() {
        return Collections.unmodifiableCollection(this.m_fileExtensions);
    }

    public EclipseWorkspaceWalker withExtensionsAccepted(String ... extensions) {
        List<String> l = extensions == null ? null : Arrays.asList(extensions);
        return this.withExtensionsAccepted(l);
    }

    public EclipseWorkspaceWalker withExtensionsAccepted(Collection<String> extensions) {
        this.m_fileExtensions.clear();
        if (extensions != null && !extensions.isEmpty()) {
            for (String e : extensions) {
                if (!Strings.hasText((CharSequence)e)) continue;
                this.m_fileExtensions.add(e);
            }
        }
        return this;
    }

    public static class WorkspaceFile {
        private final Path m_file;
        private final Path m_projectPath;
        private final Charset m_charset;
        private final FinalValue<List<IFile>> m_workspaceFiles;
        private CharSequence m_content;

        public WorkspaceFile(Path file, Path projectPath, Charset charset) {
            this.m_file = (Path)Ensure.notNull((Object)file);
            this.m_projectPath = (Path)Ensure.notNull((Object)projectPath);
            this.m_charset = (Charset)Ensure.notNull((Object)charset);
            this.m_workspaceFiles = new FinalValue();
        }

        public Charset charset() {
            return this.m_charset;
        }

        public Path path() {
            return this.m_file;
        }

        public Path projectPath() {
            return this.m_projectPath;
        }

        public List<IFile> inWorkspace() {
            return (List)this.m_workspaceFiles.computeIfAbsentAndGet(() -> WorkspaceFile.resolveInWorkspace(this.path()));
        }

        protected static List<IFile> resolveInWorkspace(Path file) {
            return Arrays.stream(ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(file.toUri())).filter(IResource::exists).toList();
        }

        public CharSequence content() {
            if (this.m_content == null) {
                try {
                    this.m_content = Strings.fromFile((Path)this.path(), (Charset)this.charset());
                }
                catch (IOException e) {
                    throw new SdkException((CharSequence)"Unable to read content of file '{}'.", new Object[]{this.path(), e});
                }
            }
            return this.m_content;
        }

        public String toString() {
            return WorkspaceFile.class.getSimpleName() + ": " + String.valueOf(this.path());
        }

        public int hashCode() {
            return this.m_file.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            WorkspaceFile other = (WorkspaceFile)obj;
            return this.m_file.equals(other.m_file);
        }
    }
}

