/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.fields.proposal.content;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.manager.TranslationManager;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.AbstractContentProviderAdapter;
import org.eclipse.swt.graphics.Image;

public class TranslationStoreContentProvider
extends AbstractContentProviderAdapter {
    private final TranslationManager m_manager;
    private final Map<IType, org.eclipse.jdt.core.IType> m_jdtTypeCache;

    public TranslationStoreContentProvider(TranslationManager manager) {
        this.m_manager = (TranslationManager)Ensure.notNull((Object)manager);
        this.m_jdtTypeCache = new HashMap<IType, org.eclipse.jdt.core.IType>();
    }

    @Override
    public Image getImage(Object element) {
        return super.getImage(this.toTextService(element));
    }

    public String getText(Object element) {
        return ((ITranslationStore)element).service().type().elementName();
    }

    @Override
    public String getTextSelected(Object element) {
        org.eclipse.jdt.core.IType t = this.toTextService(element);
        StringBuilder sb = new StringBuilder(t.getElementName());
        String packageName = t.getPackageFragment().getElementName();
        if (Strings.hasText((CharSequence)packageName)) {
            sb.append(" - ").append(packageName);
        }
        return sb.toString();
    }

    @Override
    public Object createDescriptionContent(Object element, IProgressMonitor monitor) {
        return super.createDescriptionContent(this.toTextService(element), monitor);
    }

    public org.eclipse.jdt.core.IType toTextService(Object element) {
        ITranslationStore store = (ITranslationStore)element;
        return this.m_jdtTypeCache.computeIfAbsent(store.service().type(), EclipseEnvironment::toJdtType);
    }

    @Override
    protected Collection<?> loadProposals(IProgressMonitor monitor) {
        return this.m_manager.allEditableStores().collect(Collectors.toList());
    }
}

