/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.project;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectImportResult;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.project.ScoutProjectNewHelper;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.environment.CompilationUnitWriteOperation;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.osgi.framework.Version;

public class ScoutProjectNewOperation
implements BiConsumer<EclipseEnvironment, EclipseProgress> {
    private String m_groupId;
    private String m_artifactId;
    private String m_displayName;
    private boolean m_useJsClient;
    private String m_scoutVersion;
    private Path m_targetDirectory;
    private List<IProject> m_createdProjects;

    @Override
    public void accept(EclipseEnvironment env, EclipseProgress progress) {
        try {
            progress.init(100, this.toString(), new Object[0]);
            ScoutProjectNewHelper.createProject((Path)this.getTargetDirectory(), (String)this.getGroupId(), (String)this.getArtifactId(), (String)this.getDisplayName(), (boolean)this.isUseJsClient(), (String)this.getJavaVersion(), (String)this.getScoutVersion(), (IEnvironment)env, (IProgress)progress.newChild(5));
            this.m_createdProjects = this.importIntoWorkspace(progress.newChild(90));
            this.formatCreatedProjects(progress.newChild(5));
        }
        catch (Exception e) {
            throw new SdkException((CharSequence)"Unable to create Scout Project.", new Object[]{e});
        }
    }

    protected String getJavaVersion() {
        int[] supportedJavaVersions = ScoutProjectNewHelper.getSupportedJavaVersions((String)this.getScoutVersion());
        Set supportedJavaVersionSet = Arrays.stream(supportedJavaVersions).boxed().collect(Collectors.toSet());
        int javaVersion = Arrays.stream(JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType").getVMInstalls()).filter(vm -> vm instanceof IVMInstall2).map(vm -> (IVMInstall2)vm).map(IVMInstall2::getJavaVersion).filter(Strings::hasText).map(Version::new).mapToInt(v -> v.getMajor() >= 9 ? v.getMajor() : v.getMinor()).filter(supportedJavaVersionSet::contains).max().orElseGet(() -> Arrays.stream(supportedJavaVersions).max().orElseThrow());
        return Integer.toString(javaVersion);
    }

    protected void formatCreatedProjects(EclipseProgress progress) throws CoreException {
        progress.init(this.m_createdProjects.size(), "Format created projects", new Object[0]);
        for (IProject createdProject : this.m_createdProjects) {
            IJavaProject jp;
            if (!createdProject.isAccessible() || !createdProject.hasNature("org.eclipse.jdt.core.javanature") || !JdtUtils.exists((IJavaElement)(jp = JavaCore.create((IProject)createdProject)))) continue;
            ScoutProjectNewOperation.formatProject(progress.newChild(1), jp);
        }
    }

    protected static void formatProject(EclipseProgress progress, IJavaProject p) throws JavaModelException {
        for (IPackageFragment pck : p.getPackageFragments()) {
            for (ICompilationUnit u : pck.getCompilationUnits()) {
                new CompilationUnitWriteOperation(u, u.getSource()).accept(progress);
            }
        }
    }

    protected List<IProject> importIntoWorkspace(EclipseProgress progress) throws CoreException {
        List subFolders;
        try (Stream<Path> files = Files.list(this.getTargetDirectory().resolve(this.getArtifactId()));){
            subFolders = files.collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.scout.sdk.s2e", "Unable to list content of " + this.getTargetDirectory(), (Throwable)e));
        }
        ArrayList<MavenProjectInfo> projects = new ArrayList<MavenProjectInfo>(subFolders.size());
        for (Path subFolder : subFolders) {
            Path pom = subFolder.resolve("pom.xml");
            if (!Files.isReadable(pom) || !Files.isRegularFile(pom, new LinkOption[0])) continue;
            projects.add(new MavenProjectInfo(subFolder.getFileName().toString(), pom.toFile(), null, null));
        }
        return MavenPlugin.getProjectConfigurationManager().importProjects(projects, new ProjectImportConfiguration(), (IProgressMonitor)progress.newChild(projects.size()).monitor()).stream().filter(Objects::nonNull).map(IMavenProjectImportResult::getProject).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public void setDisplayName(String displayName) {
        this.m_displayName = displayName;
    }

    public Path getTargetDirectory() {
        return this.m_targetDirectory;
    }

    public void setTargetDirectory(Path targetDirectory) {
        this.m_targetDirectory = targetDirectory;
    }

    public List<IProject> getCreatedProjects() {
        return Collections.unmodifiableList(this.m_createdProjects);
    }

    public String getGroupId() {
        return this.m_groupId;
    }

    public void setGroupId(String groupId) {
        this.m_groupId = groupId;
    }

    public String getArtifactId() {
        return this.m_artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.m_artifactId = artifactId;
    }

    public boolean isUseJsClient() {
        return this.m_useJsClient;
    }

    public void setUseJsClient(boolean useJsClient) {
        this.m_useJsClient = useJsClient;
    }

    public String getScoutVersion() {
        return this.m_scoutVersion;
    }

    public void setScoutVersion(String scoutVersion) {
        this.m_scoutVersion = scoutVersion;
    }

    public String toString() {
        return "Create new Scout Project";
    }
}

