/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation.jaxws;

import java.util.HashSet;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.util.maven.MavenBuild;
import org.eclipse.scout.sdk.core.s.util.maven.MavenRunner;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;

public class RebuildArtifactsOperation
implements BiConsumer<IEnvironment, IProgress> {
    private final IJavaProject m_javaProject;

    public RebuildArtifactsOperation(IJavaProject javaProject) {
        this.m_javaProject = (IJavaProject)Ensure.notNull((Object)javaProject);
    }

    @Override
    public void accept(IEnvironment env, IProgress p) {
        Ensure.isTrue((boolean)JdtUtils.exists((IJavaElement)this.getJavaProject()), (String)"Java Project must exist.", (Object[])new Object[0]);
        EclipseProgress progress = EclipseEnvironment.toScoutProgress(p).init(this.toString(), 100);
        try {
            IProject project = this.getJavaProject().getProject();
            project.refreshLocal(2, (IProgressMonitor)progress.newChild(2).monitor());
            RebuildArtifactsOperation.deleteOutputFolderContents(project, progress.newChild(44).monitor());
            RebuildArtifactsOperation.rebuildArtifacts((IResource)project, env, progress.newChild(52));
            progress.monitor().setTaskName("Refresh project");
            project.refreshLocal(2, (IProgressMonitor)progress.newChild(2).monitor());
        }
        catch (CoreException e) {
            throw new SdkException((Throwable)e);
        }
    }

    protected static void rebuildArtifacts(IResource workingDir, IEnvironment env, IProgress p) {
        try {
            MavenRunner.execute((MavenBuild)new MavenBuild().withGoal("clean").withGoal("process-resources").withWorkingDirectory(workingDir.getLocation().toFile().toPath()), (IEnvironment)env, (IProgress)p);
        }
        catch (RuntimeException e) {
            SdkLog.error((String)"Unable to rebuild artifacts. See maven console for details.", (Object[])new Object[]{e});
        }
    }

    protected static void deleteOutputFolderContents(IProject project, SubMonitor progress) throws CoreException {
        IFolder outFolder = project.getFolder("target");
        if (!outFolder.exists()) {
            return;
        }
        HashSet resourcesToDelete = new HashSet();
        outFolder.accept(resource -> {
            boolean isOutFolder = Objects.equals(outFolder, resource);
            if (!isOutFolder) {
                resourcesToDelete.add(resource);
            }
            return isOutFolder;
        });
        progress.beginTask("Delete existing Artifacts", resourcesToDelete.size());
        for (IResource r : resourcesToDelete) {
            try {
                r.delete(1, (IProgressMonitor)progress.newChild(1));
            }
            catch (CoreException e) {
                SdkLog.warning((String)"Unable to delete resource '{}'.", (Object[])new Object[]{r.getFullPath().toOSString(), e});
            }
        }
    }

    public IJavaProject getJavaProject() {
        return this.m_javaProject;
    }

    public String toString() {
        return "Rebuild Web Service Artifacts";
    }
}

