/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation;

import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.scout.sdk.core.builder.BuilderContext;
import org.eclipse.scout.sdk.core.builder.IBuilderContext;
import org.eclipse.scout.sdk.core.builder.java.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.builder.java.JavaBuilderContext;
import org.eclipse.scout.sdk.core.generator.annotation.IAnnotationGenerator;
import org.eclipse.scout.sdk.core.imports.CompilationUnitScopedImportCollector;
import org.eclipse.scout.sdk.core.imports.IImportCollector;
import org.eclipse.scout.sdk.core.imports.IImportValidator;
import org.eclipse.scout.sdk.core.imports.ImportCollector;
import org.eclipse.scout.sdk.core.imports.ImportValidator;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.JavaTypes;
import org.eclipse.scout.sdk.core.util.PropertySupport;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.environment.WorkingCopyManager;
import org.eclipse.scout.sdk.s2e.operation.ImportsCreateOperation;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class AnnotationNewOperation
implements BiConsumer<EclipseEnvironment, EclipseProgress> {
    private static final Pattern REGEX_WHITE_SPACE_START = Pattern.compile("^(\\s+).*");
    private final IAnnotationGenerator<?> m_sourceBuilder;
    private final IMember m_declaringMember;

    public AnnotationNewOperation(IAnnotationGenerator<?> sourceBuilder, IMember declaringType) {
        this.m_sourceBuilder = sourceBuilder;
        this.m_declaringMember = declaringType;
    }

    @Override
    public void accept(EclipseEnvironment env, EclipseProgress progress) {
        Ensure.isTrue((boolean)JdtUtils.exists((IJavaElement)this.m_declaringMember));
        try {
            ICompilationUnit icu = this.m_declaringMember.getCompilationUnit();
            WorkingCopyManager.currentWorkingCopyManager().register(icu, (IProgressMonitor)progress.monitor());
            IJavaEnvironment javaEnv = env.toScoutJavaEnvironment(this.m_declaringMember.getJavaProject());
            CompilationUnitScopedImportCollector collector = new CompilationUnitScopedImportCollector((IImportCollector)new ImportCollector(javaEnv), JdtUtils.getPackage(icu));
            Document doc = new Document(icu.getSource());
            TextEdit edit = this.createEdit((IImportValidator)new ImportValidator((IImportCollector)collector), (IDocument)doc, icu.findRecommendedLineSeparator());
            edit.apply((IDocument)doc);
            IBuffer buffer = icu.getBuffer();
            buffer.setContents(doc.get());
            new ImportsCreateOperation(icu, (IImportCollector)collector).accept(env, progress);
        }
        catch (CoreException | BadLocationException ex) {
            SdkLog.warning((CharSequence)"could not add annotation to '{}'.", (Object[])new Object[]{this.m_declaringMember.getElementName(), ex});
        }
    }

    protected ISourceRange getAnnotationReplaceRange(IDocument sourceDocument, CharSequence newLine, CharSequence newAnnotationSource) throws JavaModelException, BadLocationException {
        String sn = JavaTypes.simpleName((CharSequence)((CharSequence)this.m_sourceBuilder.elementName().orElseThrow(() -> Ensure.newFail((CharSequence)"Annotation generator is missing the name.", (Object[])new Object[0]))));
        String fqn = String.valueOf(JavaTypes.qualifier((CharSequence)((CharSequence)this.m_sourceBuilder.elementName().get()))) + '.' + sn;
        int newLineLength = newLine.length();
        IRegion lineOfMemberName = sourceDocument.getLineInformationOfOffset(this.m_declaringMember.getNameRange().getOffset());
        int lineBeforeMemberNameEndPos = lineOfMemberName.getOffset() - newLineLength;
        int lastLineStart = sourceDocument.getLineInformationOfOffset(this.m_declaringMember.getSourceRange().getOffset()).getOffset();
        int newAnnotationLen = newAnnotationSource.length();
        IRegion lineInfo = sourceDocument.getLineInformationOfOffset(lineBeforeMemberNameEndPos);
        IRegion result = lineOfMemberName;
        boolean isReplaceExisting = false;
        boolean isInBlockComment = false;
        while (lineInfo.getOffset() >= lastLineStart) {
            String lineSource = sourceDocument.get(lineInfo.getOffset(), lineInfo.getLength());
            if (lineSource != null && !(lineSource = CoreUtils.removeComments((CharSequence)lineSource)).isEmpty()) {
                if (!isInBlockComment && lineSource.endsWith("*/")) {
                    isInBlockComment = true;
                } else if (isInBlockComment && lineSource.startsWith("/*")) {
                    isInBlockComment = false;
                }
                if (!isInBlockComment && lineSource.charAt(0) == '@') {
                    if (lineSource.length() > newAnnotationLen) {
                        result = lineInfo;
                    }
                    if (lineSource.startsWith(String.valueOf('@') + sn) || lineSource.startsWith(String.valueOf('@') + fqn)) {
                        result = lineInfo;
                        isReplaceExisting = true;
                        break;
                    }
                }
            }
            lineInfo = sourceDocument.getLineInformationOfOffset(lineInfo.getOffset() - newLineLength);
        }
        return new SourceRange(result.getOffset(), isReplaceExisting ? result.getLength() : 0);
    }

    protected static String getIndent(IDocument sourceDocument, ISourceRange replaceRange) throws BadLocationException {
        IRegion line = sourceDocument.getLineInformationOfOffset(replaceRange.getOffset());
        Matcher matcher = REGEX_WHITE_SPACE_START.matcher(sourceDocument.get(line.getOffset(), line.getLength()));
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public TextEdit createEdit(IImportValidator validator, IDocument sourceDocument, String nl) throws CoreException {
        try {
            Path targetPath = this.m_declaringMember.getCompilationUnit().getResource().getLocation().toFile().toPath();
            PropertySupport properties = S2eUtils.propertyMap(this.m_declaringMember.getJavaProject(), targetPath);
            StringBuilder src = this.getSourceBuilder().toJavaSource((IJavaBuilderContext)new JavaBuilderContext((IBuilderContext)new BuilderContext(nl, properties), validator));
            ISourceRange replaceRange = this.getAnnotationReplaceRange(sourceDocument, nl, src);
            src.insert(0, AnnotationNewOperation.getIndent(sourceDocument, replaceRange));
            if (replaceRange.getLength() == 0) {
                src.append(nl);
            }
            return new ReplaceEdit(replaceRange.getOffset(), replaceRange.getLength(), src.toString());
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.scout.sdk.s2e", "could not find insert location for annotation.", (Throwable)e));
        }
    }

    public IAnnotationGenerator<?> getSourceBuilder() {
        return this.m_sourceBuilder;
    }

    public String toString() {
        return "Create new Annotation";
    }
}

