/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.fields.proposal.content;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.util.JavaTypes;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.StrictHierarchyTypeContentProvider;
import org.eclipse.scout.sdk.s2e.ui.util.NormalizedPattern;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;

public class TypeContentProvider
extends StrictHierarchyTypeContentProvider {
    private NormalizedPattern m_lastPattern;
    private int m_maxProposalCount = 100;
    private final List<String> m_mostlyUsedTypes = new ArrayList<String>(Arrays.asList("java.lang.Boolean", "java.lang.Byte", "java.lang.Character", CharSequence.class.getName(), "java.lang.Integer", "java.lang.Long", Number.class.getName(), String.class.getName(), BigDecimal.class.getName(), BigInteger.class.getName(), Collection.class.getName(), List.class.getName(), Map.class.getName(), Set.class.getName()));

    public TypeContentProvider(IJavaProject project) {
        super(project, null);
        this.setTypeProposalFilter((Predicate<IType>)new JdtUtils.PublicPrimaryTypeFilter());
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        this.m_lastPattern = null;
        this.m_mostlyUsedTypes.clear();
    }

    @Override
    public Collection<Object> getProposals(NormalizedPattern searchPattern, IProgressMonitor monitor) {
        if (!Objects.equals(this.m_lastPattern, searchPattern)) {
            this.m_lastPattern = searchPattern;
            this.clearCache();
        }
        return super.getProposals(searchPattern, monitor);
    }

    protected boolean addProposalCandidate(IType candidate, Collection<IType> candidates) {
        if (candidates.size() >= this.getMaxProposalCount()) {
            return false;
        }
        if (JdtUtils.exists((IJavaElement)candidate)) {
            candidates.add(candidate);
        }
        return candidates.size() < this.getMaxProposalCount();
    }

    @Override
    protected Collection<?> loadProposals(IProgressMonitor monitor) {
        if (Strings.hasText((CharSequence)this.getBaseClassFqn()) && !Object.class.getName().equals(this.getBaseClassFqn())) {
            return super.loadProposals(monitor);
        }
        TreeSet<IType> result = new TreeSet<IType>((Comparator<IType>)new JdtUtils.ElementNameComparator());
        this.addMostlyUsedCandidates(result, monitor);
        int remainingSpace = this.getMaxProposalCount() - result.size();
        if (remainingSpace > 0) {
            this.addOtherCandidates(result, monitor);
        }
        return result;
    }

    protected void addMostlyUsedCandidates(Collection<IType> candidates, IProgressMonitor monitor) {
        IJavaProject javaProject = this.getJavaProject();
        if (!JdtUtils.exists((IJavaElement)javaProject)) {
            return;
        }
        Predicate<IType> filter = this.getTypeProposalFilter();
        for (String fqn : this.m_mostlyUsedTypes) {
            boolean matches;
            if (monitor.isCanceled()) {
                return;
            }
            boolean bl = matches = this.m_lastPattern.getMatchingRegions(JavaTypes.simpleName((CharSequence)fqn)) != null;
            if (!matches) continue;
            try {
                IType type = javaProject.findType(fqn);
                if (filter != null && !filter.test(type) || this.addProposalCandidate(type, candidates)) continue;
                return;
            }
            catch (JavaModelException e) {
                SdkLog.warning((CharSequence)"Unable to find type {} in project {}.", (Object[])new Object[]{fqn, javaProject.getElementName(), e});
            }
        }
    }

    protected void addOtherCandidates(Set<IType> candidates, IProgressMonitor monitor) {
        if (this.m_lastPattern.isEmpty()) {
            return;
        }
        IJavaProject javaProject = this.getJavaProject();
        if (!JdtUtils.exists((IJavaElement)javaProject)) {
            return;
        }
        P_SearchRequestor requestor = new P_SearchRequestor(candidates, monitor);
        SearchPattern pat = SearchPattern.createPattern((String)this.m_lastPattern.getPattern(), (int)0, (int)0, (int)this.m_lastPattern.getMatchRule());
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaProject});
        try {
            new SearchEngine().search(pat, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, (SearchRequestor)requestor, monitor);
        }
        catch (OperationCanceledException e) {
            SdkLog.debug((CharSequence)"SearchEngine lookup canceled.", (Object[])new Object[]{e});
        }
        catch (CoreException e) {
            SdkLog.warning((CharSequence)"Unable to search for type candidates in project '{}' matching pattern '{}'.", (Object[])new Object[]{javaProject.getElementName(), this.m_lastPattern.getPattern(), e});
        }
    }

    public int getMaxProposalCount() {
        return this.m_maxProposalCount;
    }

    public void setMaxProposalCount(int maxProposalCount) {
        if (this.m_maxProposalCount == maxProposalCount) {
            return;
        }
        this.m_maxProposalCount = maxProposalCount;
        this.clearCache();
    }

    public void addMostlyUsedType(String type) {
        this.m_mostlyUsedTypes.add(type);
        this.clearCache();
    }

    public void setMostlyUsedTypes(Collection<String> types) {
        this.m_mostlyUsedTypes.clear();
        this.m_mostlyUsedTypes.addAll(types);
        this.clearCache();
    }

    public void removeMostlyUsedType(String type) {
        this.m_mostlyUsedTypes.remove(type);
        this.clearCache();
    }

    private final class P_SearchRequestor
    extends SearchRequestor {
        private final IProgressMonitor m_monitor;
        private final Set<IType> m_collector;
        private final Predicate<IType> m_typeProposalFilter;

        private P_SearchRequestor(Set<IType> collector, IProgressMonitor monitor) {
            this.m_collector = collector;
            this.m_monitor = monitor;
            this.m_typeProposalFilter = TypeContentProvider.this.getTypeProposalFilter();
        }

        public void acceptSearchMatch(SearchMatch m) {
            if (this.m_monitor.isCanceled()) {
                throw new OperationCanceledException("type lookup canceled because monitor has been canceled.");
            }
            if (!(m instanceof TypeDeclarationMatch)) {
                return;
            }
            TypeDeclarationMatch match = (TypeDeclarationMatch)m;
            IType type = (IType)match.getElement();
            if (!JdtUtils.exists((IJavaElement)type)) {
                return;
            }
            if (this.m_typeProposalFilter != null && !this.m_typeProposalFilter.test(type)) {
                return;
            }
            if (this.m_collector.contains(type)) {
                return;
            }
            if (!TypeContentProvider.this.addProposalCandidate(type, this.m_collector)) {
                throw new OperationCanceledException("type lookup canceled because max number of candidates reached.");
            }
        }
    }
}

