/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.wizard;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.swt.widgets.Display;

public class WizardFinishTask<OP extends BiConsumer<? super EclipseEnvironment, ? super EclipseProgress>>
implements BiConsumer<EclipseEnvironment, EclipseProgress> {
    private final Display m_display;
    private FinalValue<OP> m_operation;
    private Supplier<OP> m_operationSupplier;
    private BiConsumer<PageToOperationMappingInput, ? extends OP> m_mapper;
    private BiConsumer<OP, Display> m_uiAction;

    public WizardFinishTask(Display display) {
        this.m_display = (Display)Ensure.notNull((Object)display);
        this.m_operation = new FinalValue();
    }

    @Override
    public void accept(EclipseEnvironment environment, EclipseProgress progress) {
        int workForMapping = 1;
        int workForOperation = 1000;
        progress.init("Values from UI to operation", workForMapping + workForOperation);
        BiConsumer operation = (BiConsumer)Ensure.notNull(this.operation());
        this.mapper().accept(new PageToOperationMappingInput(environment, progress.newChild(workForMapping)), (PageToOperationMappingInput)((Object)operation));
        operation.accept(environment, progress.newChild(workForOperation));
        this.uiAction().ifPresent(action -> action.accept(operation, this.m_display));
    }

    public WizardFinishTask<OP> withOperation(Supplier<OP> supplier) {
        this.m_operationSupplier = (Supplier)Ensure.notNull(supplier);
        this.m_operation = new FinalValue();
        return this;
    }

    protected OP operation() {
        return (OP)((BiConsumer)this.m_operation.computeIfAbsentAndGet(this.operationSupplier()));
    }

    public Supplier<OP> operationSupplier() {
        return this.m_operationSupplier;
    }

    public WizardFinishTask<OP> withMapper(BiConsumer<PageToOperationMappingInput, ? extends OP> mapper) {
        this.m_mapper = Optional.ofNullable(mapper).orElse((input, op) -> {});
        return this;
    }

    public <T extends OP> BiConsumer<PageToOperationMappingInput, T> mapper() {
        return this.m_mapper;
    }

    public WizardFinishTask<OP> withUiAction(BiConsumer<OP, Display> action) {
        this.m_uiAction = action;
        return this;
    }

    public Optional<BiConsumer<OP, Display>> uiAction() {
        return Optional.ofNullable(this.m_uiAction);
    }

    public String toString() {
        return this.operation().toString();
    }

    public static class PageToOperationMappingInput {
        private final EclipseEnvironment m_env;
        private final EclipseProgress m_progress;

        public PageToOperationMappingInput(EclipseEnvironment env, EclipseProgress progress) {
            this.m_env = (EclipseEnvironment)Ensure.notNull((Object)env);
            this.m_progress = (EclipseProgress)Ensure.notNull((Object)progress);
        }

        public EclipseEnvironment environment() {
            return this.m_env;
        }

        public EclipseProgress progress() {
            return this.m_progress;
        }
    }
}

