/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.bigintegerfield;

import java.math.BigInteger;
import java.text.ParsePosition;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.bigintegerfield.IBigIntegerField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.AbstractNumberField;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;

public abstract class AbstractBigIntegerField
extends AbstractNumberField<BigInteger>
implements IBigIntegerField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractBigIntegerField.class);

    @ConfigProperty(value="LONG")
    @Order(value=250.0)
    @ConfigPropertyValue(value="null")
    @ValidationRule(value="minValue")
    protected Long getConfiguredMinValue() {
        return null;
    }

    @ConfigProperty(value="LONG")
    @Order(value=260.0)
    @ConfigPropertyValue(value="null")
    @ValidationRule(value="maxValue")
    protected Long getConfiguredMaxValue() {
        return null;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMinValue(this.getConfiguredMinValue() != null ? BigInteger.valueOf(this.getConfiguredMinValue()) : null);
        this.setMaxValue(this.getConfiguredMaxValue() != null ? BigInteger.valueOf(this.getConfiguredMaxValue()) : null);
    }

    @Override
    protected BigInteger parseValueInternal(String text) throws ProcessingException {
        BigInteger retVal = null;
        if ((text = text == null ? "" : text.trim()).length() > 0) {
            ParsePosition p = new ParsePosition(0);
            Number n = this.createNumberFormat().parse(text, p);
            if (p.getErrorIndex() >= 0 || p.getIndex() != text.length()) {
                throw new ProcessingException(ScoutTexts.get((String)"InvalidNumberMessageX", (String[])new String[]{text}));
            }
            retVal = new BigInteger(n.toString());
        }
        return retVal;
    }
}

