/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.wrappedform.IWrappedFormField;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractCompositeField
extends AbstractFormField
implements ICompositeField {
    private IFormField[] m_fields;

    public AbstractCompositeField() {
        this(true);
    }

    public AbstractCompositeField(boolean callInitializer) {
        super(callInitializer);
    }

    protected Class<? extends IFormField>[] getConfiguredFields() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, IFormField.class);
    }

    @Override
    protected boolean execCalculateVisible() {
        return true;
    }

    @Override
    protected void initConfig() {
        this.m_fields = new IFormField[0];
        super.initConfig();
        ArrayList<IFormField> fieldList = new ArrayList<IFormField>();
        Class<? extends IFormField>[] fieldArray = this.getConfiguredFields();
        int i = 0;
        while (i < fieldArray.length) {
            try {
                IFormField f = (IFormField)ConfigurationUtility.newInnerInstance((Object)this, fieldArray[i]);
                fieldList.add(f);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("field: " + fieldArray[i].getName(), t));
            }
            ++i;
        }
        this.injectFieldsInternal(fieldList);
        for (IFormField f : fieldList) {
            f.setParentFieldInternal(this);
        }
        IFormField[] iFormFieldArray = this.m_fields = fieldList.toArray(new IFormField[fieldList.size()]);
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            f.addPropertyChangeListener(new P_FieldPropertyChangeListener());
            ++n2;
        }
        this.handleFieldVisibilityChanged();
    }

    protected void injectFieldsInternal(List<IFormField> fieldList) {
    }

    @Override
    public void setFormInternal(IForm form) {
        super.setFormInternal(form);
        IFormField[] a = this.m_fields;
        int i = 0;
        while (i < a.length) {
            IFormField f = a[i];
            f.setFormInternal(form);
            ++i;
        }
    }

    @Override
    public int getFieldIndex(IFormField f) {
        int i = 0;
        while (i < this.m_fields.length) {
            if (this.m_fields[i] == f) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getFieldCount() {
        return this.m_fields.length;
    }

    @Override
    public IFormField getFieldById(final String id) {
        final Holder found = new Holder(IFormField.class);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field.getFieldId().equals(id)) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (IFormField)found.getValue();
    }

    @Override
    public <T extends IFormField> T getFieldById(final String id, final Class<T> type) {
        final Holder found = new Holder(type);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (type.isAssignableFrom(field.getClass()) && field.getFieldId().equals(id)) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (T)((IFormField)found.getValue());
    }

    @Override
    public <T extends IFormField> T getFieldByClass(final Class<T> c) {
        final Holder found = new Holder(c);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field.getClass() == c) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (T)((IFormField)found.getValue());
    }

    @Override
    public IFormField[] getFields() {
        IFormField[] a = new IFormField[this.m_fields.length];
        System.arraycopy(this.m_fields, 0, a, 0, a.length);
        return a;
    }

    @Override
    public boolean visitFields(IFormFieldVisitor visitor, int startLevel) {
        if (!visitor.visitField(this, startLevel, 0)) {
            return false;
        }
        int index = 0;
        IFormField[] f = this.m_fields;
        int i = 0;
        while (i < f.length) {
            if (f[i] instanceof ICompositeField ? !((ICompositeField)f[i]).visitFields(visitor, startLevel + 1) : (f[i] instanceof IWrappedFormField ? !((IWrappedFormField)f[i]).visitFields(visitor, startLevel + 1) : !visitor.visitField(f[i], startLevel, index))) {
                return false;
            }
            ++index;
            ++i;
        }
        return true;
    }

    @Override
    protected boolean execIsSaveNeeded() throws ProcessingException {
        IFormField[] iFormFieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            if (f.isSaveNeeded()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void execMarkSaved() throws ProcessingException {
        super.execMarkSaved();
        IFormField[] iFormFieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            f.markSaved();
            ++n2;
        }
    }

    @Override
    protected boolean execIsEmpty() throws ProcessingException {
        IFormField[] iFormFieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            if (!f.isEmpty()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void setMandatory(boolean b) {
        IFormField[] iFormFieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            f.setMandatory(b);
            ++n2;
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    @Override
    public void setEnabledGranted(boolean b) {
        super.setEnabledGranted(b);
        IFormField[] iFormFieldArray = this.getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            if (f.getEnabledPermission() == null) {
                f.setEnabledGranted(b);
            }
            ++n2;
        }
    }

    @Override
    public void setVisibleGranted(boolean b) {
        super.setVisibleGranted(b);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (this.isInitialized()) {
            IFormField[] iFormFieldArray = this.m_fields;
            int n = this.m_fields.length;
            int n2 = 0;
            while (n2 < n) {
                IFormField f = iFormFieldArray[n2];
                f.setEnabled(b);
                ++n2;
            }
        }
    }

    protected void handleFieldVisibilityChanged() {
        int visCount = 0;
        IFormField[] f = this.m_fields;
        int i = 0;
        while (i < f.length) {
            if (f[i].isVisible()) {
                ++visCount;
            }
            ++i;
        }
        this.setVisibleFieldCount(visCount);
        this.calculateVisibleInternal();
    }

    @Override
    public void rebuildFieldGrid() {
    }

    private void setVisibleFieldCount(int n) {
        this.propertySupport.setPropertyInt("visibleFieldCount", n);
    }

    protected int getVisibleFieldCount() {
        return this.propertySupport.getPropertyInt("visibleFieldCount");
    }

    private class P_FieldPropertyChangeListener
    implements PropertyChangeListener {
        private P_FieldPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("visible")) {
                AbstractCompositeField.this.handleFieldVisibilityChanged();
            } else if (e.getPropertyName().equals("saveNeeded")) {
                AbstractCompositeField.this.checkSaveNeeded();
            } else if (e.getPropertyName().equals("empty")) {
                AbstractCompositeField.this.checkEmpty();
            }
        }
    }
}

