/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columnfilter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

@Deprecated
public class SmartColumnFilter<T>
implements ITableColumnFilter<T> {
    private final ISmartColumn<T> m_column;
    private Set<T> m_selectedValues;

    public SmartColumnFilter(ISmartColumn<T> column) {
        this.m_column = column;
    }

    @Override
    public IColumn<T> getColumn() {
        return this.m_column;
    }

    @Override
    public Set<T> getSelectedValues() {
        return this.m_selectedValues;
    }

    @Override
    public void setSelectedValues(Set<T> set) {
        this.m_selectedValues = set;
    }

    @Override
    public List<LookupRow> createHistogram() {
        TreeMap<String, LookupRow> hist = new TreeMap<String, LookupRow>();
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        ITableRow[] iTableRowArray = this.m_column.getTable().getRows();
        int n = iTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            Integer count;
            ITableRow row = iTableRowArray[n2];
            Object key = this.m_column.getValue(row);
            String text = this.m_column.getDisplayText(row);
            if (text != null && !hist.containsKey(text)) {
                FontSpec font = row.isFilterAccepted() ? null : FontSpec.parse((String)"italic");
                hist.put(text, new LookupRow(key, text, null, null, null, null, font));
            }
            countMap.put(text, (count = (Integer)countMap.get(text)) != null ? count + 1 : 1);
            ++n2;
        }
        for (Map.Entry e : hist.entrySet()) {
            Integer count = (Integer)countMap.get(e.getKey());
            if (count == null || count <= 1) continue;
            LookupRow row = (LookupRow)e.getValue();
            row.setText(String.valueOf(row.getText()) + " (" + count + ")");
        }
        ArrayList<LookupRow> list = new ArrayList<LookupRow>();
        list.addAll(hist.values());
        Integer nullCount = (Integer)countMap.get(null);
        list.add(new LookupRow(null, "(" + ScoutTexts.get((String)"ColumnFilterNullText", (String[])new String[0]) + ")" + (nullCount != null && nullCount > 1 ? " (" + nullCount + ")" : "")));
        return list;
    }

    @Override
    public boolean isEmpty() {
        return this.m_selectedValues == null || this.m_selectedValues.isEmpty();
    }

    @Override
    public boolean accept(ITableRow row) {
        Object value = this.m_column.getValue(row);
        return this.m_selectedValues == null || this.m_selectedValues.contains(value);
    }
}

