/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.calendar;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.eclipse.scout.commons.nls.NlsLocale;

public class DateTimeFormatFactory {
    private Locale m_nlsLocale;
    private boolean m_different;

    public DateTimeFormatFactory() {
        Locale loc = Locale.getDefault();
        this.m_nlsLocale = NlsLocale.getDefault().getLocale();
        this.m_different = !loc.equals(this.m_nlsLocale);
    }

    public DateFormat getDayMonthYear(int style) {
        DateFormat fmt = DateFormat.getDateInstance(style);
        if (this.isDifferentLocale()) {
            fmt = this.transformDateFormat(fmt);
        }
        return fmt;
    }

    public DateFormat getHourMinute() {
        DateFormat fmt = DateFormat.getTimeInstance(3);
        if (this.isDifferentLocale()) {
            fmt = this.transformDateFormat(fmt);
        }
        return fmt;
    }

    public DateFormat getHourMinuteSecond() {
        DateFormat fmt = DateFormat.getTimeInstance(2);
        if (this.isDifferentLocale()) {
            fmt = this.transformDateFormat(fmt);
        }
        return fmt;
    }

    public DateFormat getDayMonthYearHourMinuteSecond(int dateStyle, int timeStyle) {
        DateFormat fmt = DateFormat.getDateTimeInstance(dateStyle, timeStyle);
        if (this.isDifferentLocale()) {
            fmt = this.transformDateFormat(fmt);
        }
        return fmt;
    }

    public DateFormat getDayMonth(int style) {
        DateFormat fmt = this.getDayMonthYear(style);
        if (fmt instanceof SimpleDateFormat) {
            String pattern = ((SimpleDateFormat)fmt).toPattern();
            pattern = this.removeYear(pattern);
            ((SimpleDateFormat)fmt).applyPattern(pattern);
        }
        return fmt;
    }

    private boolean isDifferentLocale() {
        return this.m_different;
    }

    private DateFormat transformDateFormat(DateFormat fmt) {
        if (fmt instanceof SimpleDateFormat) {
            SimpleDateFormat sfmt = (SimpleDateFormat)fmt;
            String pattern = sfmt.toPattern();
            fmt = new SimpleDateFormat(pattern, this.m_nlsLocale);
        }
        return fmt;
    }

    private String removeYear(String s) {
        return s.replace("[/-,. ]*[y]+[/-,.]*", "").trim();
    }
}

