/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.servicetunnel.http.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.scout.commons.xmlparser.ScoutXmlDocument;
import org.eclipse.scout.commons.xmlparser.ScoutXmlParser;
import org.xml.sax.SAXException;

public class TestSoapXml {
    public void run() throws Exception {
        String a = "Hello World";
        System.out.println("a:\n" + a);
        byte[] msg = this.send(a);
        System.out.println("msg:\n" + new String(msg, "UTF-8"));
        String b = this.receive(msg);
        System.out.println("b:\n" + b);
    }

    public byte[] send(String text) throws Exception {
        ScoutXmlDocument doc = new ScoutXmlDocument();
        doc.setXmlVersion("1.0");
        doc.setXmlEncoding("UTF-8");
        ScoutXmlDocument.ScoutXmlElement env = doc.setRoot("");
        env.setNamespace("SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
        env.setName("SOAP-ENV:Envelope");
        env.setAttribute("SOAP-ENV:encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
        ScoutXmlDocument.ScoutXmlElement body = env.addChild("SOAP-ENV:Body");
        ScoutXmlDocument.ScoutXmlElement dataPart = body.addChild("data");
        dataPart.addContent((Object)text);
        ScoutXmlDocument.ScoutXmlElement infoPart = body.addChild("info");
        infoPart.addContent((Object)"For maximal performance, data is reduced, compressed, signed and base64 encoded.");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        doc.write((OutputStream)out);
        out.close();
        return out.toByteArray();
    }

    public String receive(byte[] msg) throws IOException, SAXException {
        ScoutXmlDocument doc = new ScoutXmlParser().parse((InputStream)new ByteArrayInputStream(msg));
        ScoutXmlDocument.ScoutXmlElement env = doc.getChild("{http://schemas.xmlsoap.org/soap/envelope/}Envelope");
        ScoutXmlDocument.ScoutXmlElement body = env.getChild("{http://schemas.xmlsoap.org/soap/envelope/}Body");
        ScoutXmlDocument.ScoutXmlElement dataPart = body.getChild("data");
        String text = dataPart.getText();
        ScoutXmlDocument.ScoutXmlElement infoPart = body.getChild("info");
        String info = infoPart.getText();
        System.out.println("Info: " + info);
        return text;
    }

    public static void main(String[] args) throws Exception {
        new TestSoapXml().run();
    }
}

