/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.session.internal;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.session.IClientSessionRegistryService;
import org.eclipse.scout.service.AbstractService;
import org.osgi.framework.Bundle;

@Priority(value=-1.0f)
public class ClientSessionRegistryService
extends AbstractService
implements IClientSessionRegistryService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ClientSessionRegistryService.class);
    private final HashMap<String, IClientSession> m_cache = new HashMap();
    private final Object m_cacheLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IClientSession> T getClientSession(Class<T> clazz) {
        Bundle bundle;
        String symbolicName = clazz.getPackage().getName();
        Bundle bundleLocator = null;
        while (symbolicName != null) {
            bundleLocator = Platform.getBundle((String)symbolicName);
            int i = symbolicName.lastIndexOf(46);
            if (bundleLocator != null || i < 0) break;
            symbolicName = symbolicName.substring(0, i);
        }
        if ((bundle = Platform.getBundle((String)symbolicName)) != null) {
            Object object = this.m_cacheLock;
            synchronized (object) {
                IClientSession clientSession = this.m_cache.get(bundle.getSymbolicName());
                if (clientSession == null || !clientSession.isActive()) {
                    try {
                        clientSession = (IClientSession)clazz.newInstance();
                        this.m_cache.put(symbolicName, clientSession);
                        ClientSyncJob job = new ClientSyncJob("Session startup", clientSession){

                            @Override
                            protected void runVoid(IProgressMonitor monitor) throws Throwable {
                                1.getCurrentSession().startSession(bundle);
                            }
                        };
                        job.schedule();
                        job.join();
                        job.throwOnError();
                    }
                    catch (Throwable t) {
                        LOG.error("could not load session for " + symbolicName, t);
                    }
                }
                return (T)clientSession;
            }
        }
        return null;
    }

    @Override
    public <T extends IClientSession> T newClientSession(Class<T> clazz, String webSessionId) {
        Bundle bundle;
        String symbolicName = clazz.getPackage().getName();
        Bundle bundleLocator = null;
        while (symbolicName != null) {
            bundleLocator = Platform.getBundle((String)symbolicName);
            int i = symbolicName.lastIndexOf(46);
            if (bundleLocator != null || i < 0) break;
            symbolicName = symbolicName.substring(0, i);
        }
        if ((bundle = Platform.getBundle((String)symbolicName)) != null) {
            try {
                IClientSession clientSession = (IClientSession)clazz.newInstance();
                if (webSessionId != null) {
                    clientSession.setWebSessionId(webSessionId);
                }
                ClientSyncJob job = new ClientSyncJob("Session startup", clientSession){

                    @Override
                    protected void runVoid(IProgressMonitor monitor) throws Throwable {
                        2.getCurrentSession().startSession(bundle);
                    }
                };
                job.runNow((IProgressMonitor)new NullProgressMonitor());
                job.throwOnError();
                return (T)clientSession;
            }
            catch (Throwable t) {
                LOG.error("could not load session for " + symbolicName, t);
            }
        }
        return null;
    }
}

