/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.search;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.services.common.search.DefaultSearchFilterService;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.AbstractComposerField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.internal.LegacyComposerStatementBuilder;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;
import org.eclipse.scout.rt.shared.services.common.jdbc.LegacySearchFilter;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;

@Deprecated
public class LegacySearchFilterService
extends DefaultSearchFilterService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(LegacySearchFilterService.class);

    @Override
    public SearchFilter createNewSearchFilter() {
        return new LegacySearchFilter();
    }

    public int resolveTokenIdByClass(Class<?> source) {
        throw new IllegalArgumentException("subclass should implement this method the resolve type to tokenId");
    }

    @Override
    public void applySearchDelegate(IFormField field, SearchFilter search, boolean includeChildren) {
        super.applySearchDelegate(field, search, false);
        if (search instanceof LegacySearchFilter && this.applyInterceptor(field, (LegacySearchFilter)search)) {
            return;
        }
        if (includeChildren) {
            this.applySearchDelegateForChildren(field, search);
        }
    }

    protected boolean applyInterceptor(IFormField field, LegacySearchFilter search) {
        if (field instanceof AbstractComposerField) {
            LegacySearchFilter.ComposerConstraint specialConstraint;
            AbstractComposerField composerField = (AbstractComposerField)field;
            ITreeNode rootNode = composerField.getTree().getRootNode();
            if (rootNode != null && (specialConstraint = new LegacyComposerStatementBuilder(search.getBindMap()).build(rootNode)) != null) {
                try {
                    search.addSpecialWhereToken((Object)specialConstraint);
                }
                catch (ProcessingException e) {
                    LOG.error("adding legacy search filter", (Throwable)e);
                }
            }
            return true;
        }
        if (field instanceof AbstractStringField) {
            AbstractStringField valueField = (AbstractStringField)field;
            String value = (String)valueField.getValue();
            if (value != null && valueField.getLegacySearchTerm() != null) {
                if (ClientJob.getCurrentSession().getDesktop().isAutoPrefixWildcardForTextSearch()) {
                    value = "*" + value;
                }
                try {
                    search.addSpecialWhereToken((Object)new LegacySearchFilter.StringLikeConstraint(valueField.getLegacySearchTerm(), value));
                }
                catch (ProcessingException e) {
                    LOG.error("adding legacy search filter", (Throwable)e);
                }
            }
            return true;
        }
        if (field instanceof AbstractValueField) {
            AbstractValueField valueField = (AbstractValueField)field;
            if (valueField.getValue() != null && valueField.getLegacySearchTerm() != null) {
                search.addWhereToken(valueField.getLegacySearchTerm(), valueField.getValue());
            }
            return true;
        }
        return false;
    }
}

