/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.jdt.IResourceFilter;
import org.eclipse.scout.nls.sdk.internal.jdt.NlsJdtHandler;
import org.eclipse.scout.nls.sdk.internal.ui.FieldValidator;
import org.eclipse.scout.nls.sdk.internal.ui.NlsUi;
import org.eclipse.scout.nls.sdk.internal.ui.TextButtonField;
import org.eclipse.scout.nls.sdk.internal.ui.TextField;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.ResourceDialog;
import org.eclipse.scout.nls.sdk.internal.ui.fields.IInputChangedListener;
import org.eclipse.scout.nls.sdk.internal.ui.fields.TextProposalField;
import org.eclipse.scout.nls.sdk.internal.ui.formatter.IInputFormatter;
import org.eclipse.scout.nls.sdk.internal.ui.formatter.IInputValidator;
import org.eclipse.scout.nls.sdk.internal.ui.wizard.PackageProposalModel;
import org.eclipse.scout.nls.sdk.internal.ui.wizard.ResourceProposalModel;
import org.eclipse.scout.nls.sdk.operations.desc.NewNlsFileOperationDesc;
import org.eclipse.scout.nls.sdk.util.concurrent.Lock;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class NewNlsFileWizardPage2
extends NewTypeWizardPage {
    private NewNlsFileOperationDesc m_desc;
    private Composite m_rootPane;
    private TextButtonField m_containerField;
    private P_RootContainerModifyListener m_containerFieldModifyListener = new P_RootContainerModifyListener();
    private TextProposalField m_package;
    private TextField<String> m_className;
    private TextProposalField m_translationFolderField;
    private TextField<String> m_translationFileName;
    private FieldValidator m_fieldValidator = new FieldValidator();
    private Lock m_lock = new Lock();
    private PackageProposalModel m_packageProposalModel;

    public NewNlsFileWizardPage2(String pageName, NewNlsFileOperationDesc desc) {
        super(true, "new NLS Class");
        this.setTitle("Create a NLS class");
        this.setDescription("This class will be referenced to get a translated text");
        this.m_desc = desc;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.m_rootPane = new Composite(parent, 0);
        this.m_containerField = new TextButtonField(this.m_rootPane);
        this.m_fieldValidator.addField((Control)this.m_containerField);
        this.m_containerField.setLabelText("Source Folder");
        this.m_containerField.setButtonText("Browse");
        this.m_containerField.addTextModifyListener(this.m_containerFieldModifyListener);
        this.m_containerField.addButtonSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPackageFragmentRoot frag = NewNlsFileWizardPage2.this.chooseContainer();
                NewNlsFileWizardPage2.this.setPackageFragmentRoot(frag, false);
                if (frag == null) {
                    NewNlsFileWizardPage2.this.m_desc.setSourceContainer(null);
                } else {
                    NewNlsFileWizardPage2.this.m_desc.setSourceContainer(frag.getPath());
                }
            }
        });
        this.m_packageProposalModel = new PackageProposalModel();
        KeyStroke stoke = KeyStroke.getInstance((int)262144, (int)32);
        this.m_package = new TextProposalField(this.m_rootPane, this.m_packageProposalModel, stoke);
        this.m_package.setLabelText("Package");
        this.m_package.setLabelProvider((ILabelProvider)this.m_packageProposalModel);
        this.m_package.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewNlsFileWizardPage2.this.m_desc.setPackage(NewNlsFileWizardPage2.this.m_package.getText());
            }
        });
        NlsUi.decorate(this.m_package, false);
        this.m_fieldValidator.addField((Control)this.m_package);
        this.m_className = new TextField(this.m_rootPane);
        this.m_fieldValidator.addField((Control)this.m_className);
        this.m_className.setLabelText("Class Name");
        this.m_className.addInputChangedListener(new IInputChangedListener<String>(){

            @Override
            public void inputChanged(String input) {
                NewNlsFileWizardPage2.this.m_desc.setClassName(input);
            }
        });
        this.m_className.setInputValidator(new IInputValidator(){
            private String m_regexp = "\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b";

            @Override
            public IStatus isValid(String value) {
                if (value.matches(this.m_regexp)) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        });
        this.attachGridData(this.createTranslationGroup(this.m_rootPane));
        this.m_rootPane.setLayout((Layout)new GridLayout(1, false));
        this.attachGridData((Control)this.m_containerField);
        this.attachGridData((Control)this.m_package);
        this.attachGridData((Control)this.m_className);
        this.initUi();
    }

    private void initUi() {
        this.m_desc.addPropertyChangeListener(new P_DescPropertyChangedListener());
        for (Map.Entry<String, Object> entry : this.m_desc.getPropertiesMap().entrySet()) {
            this.handlePropertyChanged(entry.getKey(), null, entry.getValue());
        }
    }

    private Control createTranslationGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Translation File(s)");
        ResourceProposalModel model = new ResourceProposalModel();
        List<Object> projectList = new ArrayList();
        if (this.m_desc.getPlugin() != null) {
            try {
                projectList = NlsCore.getProjectGroup(this.m_desc.getPlugin());
            }
            catch (FileNotFoundException e) {
                NlsCore.logWarning(e);
            }
            catch (CoreException e) {
                NlsCore.logWarning(e);
            }
        }
        model.setResourceFilter(new IResourceFilter(){

            @Override
            public boolean accept(IProject project, IResource resource) {
                if (resource instanceof IFolder) {
                    IFolder folder = (IFolder)resource;
                    IJavaProject jp = JavaCore.create((IProject)project);
                    try {
                        if (jp.getOutputLocation().toOSString().equals(folder.getFullPath().toOSString())) {
                            return false;
                        }
                    }
                    catch (JavaModelException e) {
                        NlsCore.logWarning(e);
                    }
                    return !folder.getProjectRelativePath().toOSString().equals("META-INF");
                }
                return false;
            }
        });
        model.setProjects(projectList.toArray(new IProject[projectList.size()]));
        KeyStroke stoke = KeyStroke.getInstance((int)262144, (int)32);
        this.m_translationFolderField = new TextProposalField((Composite)group, model, stoke);
        this.m_translationFolderField.setLabelText("Folder");
        this.m_translationFolderField.setLabelProvider((ILabelProvider)model);
        this.m_translationFolderField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewNlsFileWizardPage2.this.m_desc.setTranslationFolder(NewNlsFileWizardPage2.this.m_translationFolderField.getText());
            }
        });
        NlsUi.decorate(this.m_translationFolderField, false);
        this.m_translationFileName = new TextField((Composite)group, 8);
        this.m_fieldValidator.addField((Control)this.m_translationFileName);
        this.m_translationFileName.setLabelText("translation file prefix");
        this.m_translationFileName.setToolTipText("e.g. messages for messages[_language].properties");
        this.m_translationFileName.addInputChangedListener(new IInputChangedListener<String>(){

            @Override
            public void inputChanged(String input) {
                NewNlsFileWizardPage2.this.m_desc.setTranlationFileName(input);
            }
        });
        this.m_translationFileName.setInputValidator(new IInputValidator(){
            private String m_regexp = "\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b";

            @Override
            public IStatus isValid(String value) {
                if (value.matches(this.m_regexp)) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        });
        group.setLayout((Layout)new GridLayout(1, true));
        this.attachGridData((Control)this.m_translationFolderField);
        this.attachGridData((Control)this.m_translationFileName);
        return group;
    }

    protected IFolder chooseTranslationFolder() {
        IResource selection;
        ResourceDialog dialog = new ResourceDialog(this.getShell(), "Choose Folder", (IContainer)this.m_desc.getPlugin());
        dialog.setInitialExpansion(new IResource[]{this.m_desc.getPlugin()});
        dialog.setInitialSelection(new IResource[]{this.m_desc.getPlugin()});
        dialog.addViewerFilter(new ViewerFilter(){

            public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
                LinkedList<Object> elList = new LinkedList<Object>();
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object e = objectArray[n2];
                    if (e instanceof IContainer) {
                        if (parent instanceof IProject) {
                            IJavaProject jp = JavaCore.create((IProject)((IProject)parent));
                            try {
                                if (!((IContainer)e).getProjectRelativePath().lastSegment().equals(jp.getOutputLocation().lastSegment())) {
                                    elList.add(e);
                                }
                            }
                            catch (JavaModelException e1) {
                                e1.printStackTrace();
                            }
                        } else {
                            elList.add(e);
                        }
                    }
                    ++n2;
                }
                return elList.toArray();
            }

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof IFolder;
            }
        });
        if (dialog.open() == 0 && (selection = dialog.getFirstResult()) instanceof IFolder) {
            return (IFolder)selection;
        }
        return null;
    }

    protected IPackageFragmentRoot chooseContainer() {
        IPackageFragmentRoot initElement = this.getPackageFragmentRoot();
        Class[] acceptedClasses = new Class[]{IPackageFragmentRoot.class, IJavaProject.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IJavaProject) {
                        IJavaProject jproject = (IJavaProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findPackageFragmentRoot(path) != null;
                    }
                    if (element instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    return true;
                }
                catch (JavaModelException e) {
                    JavaPlugin.log((IStatus)e.getStatus());
                    return false;
                }
            }
        };
        acceptedClasses = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log((IStatus)e.getStatus());
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setSorter((ViewerSorter)new JavaElementSorter());
        dialog.setTitle(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_title);
        dialog.setMessage(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)JavaCore.create((IProject)this.m_desc.getPlugin()));
        dialog.setInitialSelection((Object)initElement);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    public Control getControl() {
        return this.m_rootPane;
    }

    public void setVisible(boolean visible) {
        if (this.m_rootPane != null && !this.m_rootPane.isDisposed()) {
            this.m_rootPane.setVisible(visible);
        }
    }

    private void revalidate() {
        this.m_fieldValidator.reset();
        if (this.m_desc.getSourceContainer() == null) {
            this.m_fieldValidator.setDisabled((Control)this.m_package);
        }
        this.m_fieldValidator.applay();
        this.setMessage(null);
        if (this.m_desc.getSourceContainer() == null) {
            this.setMessage("Source Container must be specified!", 2);
            this.setPageComplete(false);
            return;
        }
        if (this.m_desc.getPackage() == null) {
            this.setMessage("Package must be specified!", 2);
            this.setPageComplete(false);
            return;
        }
        if (this.m_desc.getClassName() == null) {
            this.setMessage("Class name must be specified!", 2);
            this.setPageComplete(false);
            return;
        }
        if (this.m_desc.getTranslationFolder() == null) {
            this.setMessage("Translation folder must be specified!", 2);
            this.setPageComplete(false);
            return;
        }
        if (this.m_desc.getTranlationFileName() == null) {
            this.setMessage("Translation file must be specified!", 2);
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
    }

    private void attachGridData(Control c) {
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        c.setLayoutData((Object)data);
    }

    protected void handlePropertyChanged(String name, Object oldValue, Object newValue) {
        if (name.equals("plugin")) {
            this.m_containerFieldModifyListener.setPlugin((IProject)newValue);
            this.m_packageProposalModel.setProject((IProject)newValue);
        }
        if (name.equals("srcContainer") && this.m_lock.acquire()) {
            try {
                IPath path = (IPath)newValue;
                if (path == null) {
                    this.m_containerField.setText("");
                }
                this.m_containerField.setText(path.lastSegment());
            }
            finally {
                this.m_lock.release();
            }
        } else {
            name.equals("package");
        }
        this.revalidate();
    }

    private class P_DescPropertyChangedListener
    implements PropertyChangeListener {
        private P_DescPropertyChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NewNlsFileWizardPage2.this.handlePropertyChanged(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    private class P_PackageContentProposalProvider
    implements IContentProposalProvider {
        private P_PackageContentProposalProvider() {
        }

        public IContentProposal[] getProposals(String contents, int position) {
            return new IContentProposal[]{new IContentProposal(){

                public String getContent() {
                    return null;
                }

                public int getCursorPosition() {
                    return 0;
                }

                public String getDescription() {
                    return null;
                }

                public String getLabel() {
                    return null;
                }
            }};
        }
    }

    private class P_PackageFieldModifyListener
    implements ModifyListener {
        private P_PackageFieldModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
        }
    }

    private class P_PackageFormatter
    implements IInputFormatter<IPackageFragment> {
        private P_PackageFormatter() {
        }

        @Override
        public String format(Object source, IPackageFragment value) {
            if (value == null) {
                return "";
            }
            return value.getElementName();
        }

        @Override
        public IPackageFragment parse(Object source, String input) {
            Path path = new Path(input);
            if (NewNlsFileWizardPage2.this.m_desc.getSourceContainer() == null) {
                NewNlsFileWizardPage2.this.setMessage("Source Location must be specified!", 2);
                return null;
            }
            IJavaProject project = JavaCore.create((IProject)NewNlsFileWizardPage2.this.m_desc.getPlugin());
            if (project == null) {
                NewNlsFileWizardPage2.this.setMessage("src container must be specified first!", 2);
                return null;
            }
            try {
                IPackageFragment frag = (IPackageFragment)project.findElement((IPath)path);
                if (frag != null) {
                    return frag;
                }
            }
            catch (JavaModelException e) {
                NlsCore.logWarning(e);
            }
            return null;
        }
    }

    private class P_RootContainerModifyListener
    implements ModifyListener {
        private HashMap<String, IClasspathEntry> m_map = new HashMap();

        private P_RootContainerModifyListener() {
        }

        public void setPlugin(IProject project) {
            if (project == null) {
                return;
            }
            this.m_map.clear();
            IJavaProject jp = JavaCore.create((IProject)project);
            try {
                for (IClasspathEntry entry : NlsJdtHandler.getSourceLocations(jp)) {
                    this.m_map.put(entry.getPath().toPortableString(), entry);
                }
            }
            catch (JavaModelException e) {
                NlsCore.logWarning(e);
            }
        }

        public void modifyText(ModifyEvent e) {
            if (NewNlsFileWizardPage2.this.m_lock.acquire()) {
                try {
                    String input = NewNlsFileWizardPage2.this.m_containerField.getText();
                    for (IClasspathEntry entry : this.m_map.values()) {
                        if (entry.getPath().lastSegment().equals(input)) {
                            NewNlsFileWizardPage2.this.m_desc.setSourceContainer(entry.getPath());
                            continue;
                        }
                        NewNlsFileWizardPage2.this.m_desc.setPlugin(null);
                        NewNlsFileWizardPage2.this.setMessage("invalid source container", 2);
                    }
                }
                finally {
                    NewNlsFileWizardPage2.this.m_lock.release();
                }
            }
        }
    }

    private class P_RootPackageFormatter
    implements IInputFormatter<IPackageFragmentRoot> {
        private P_RootPackageFormatter() {
        }

        @Override
        public String format(Object source, IPackageFragmentRoot value) {
            if (value == null) {
                return "";
            }
            return value.toString();
        }

        @Override
        public IPackageFragmentRoot parse(Object source, String input) {
            block7: {
                Path path = new Path(input);
                String prjectname = path.segment(0);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(prjectname);
                if (project == null || !project.exists()) {
                    return null;
                }
                if (!project.hasNature("org.eclipse.pde.PluginNature")) break block7;
                IJavaProject jp = JavaCore.create((IProject)project);
                if (path.segmentCount() > 1) {
                    path = path.removeFirstSegments(1);
                    IPackageFragmentRoot[] iPackageFragmentRootArray = jp.getPackageFragmentRoots();
                    int n = iPackageFragmentRootArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                        if (root.isOpen() && root.getElementName().equalsIgnoreCase(path.toPortableString())) {
                            NewNlsFileWizardPage2.this.setMessage(null);
                            return root;
                        }
                        ++n2;
                    }
                    NewNlsFileWizardPage2.this.setMessage("Invalid source folder name", 2);
                    return null;
                }
            }
            try {
                NewNlsFileWizardPage2.this.setMessage("Nls files must be in PDE plugins", 2);
            }
            catch (CoreException e) {
                NlsCore.logWarning(e);
            }
            return null;
        }
    }
}

