/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.model.NlsTableModel;
import org.eclipse.scout.nls.sdk.internal.model.workspace.InheritedNlsEntry;
import org.eclipse.scout.nls.sdk.internal.model.workspace.project.NlsProject;
import org.eclipse.scout.nls.sdk.internal.ui.action.CopyPasteAction;
import org.eclipse.scout.nls.sdk.internal.ui.action.FindReferencesAction;
import org.eclipse.scout.nls.sdk.internal.ui.action.RemoveAction;
import org.eclipse.scout.nls.sdk.internal.ui.action.UpdateReferenceCountAction;
import org.eclipse.scout.nls.sdk.internal.ui.editor.NlsTable;
import org.eclipse.scout.nls.sdk.internal.ui.editor.NlsTableInputValidator;
import org.eclipse.scout.nls.sdk.internal.ui.wizard.importExport.NlsExportAction;
import org.eclipse.scout.nls.sdk.internal.ui.wizard.importExport.NlsImportAction;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProjectListener;
import org.eclipse.scout.nls.sdk.model.workspace.project.NlsProjectEvent;
import org.eclipse.scout.nls.sdk.ui.INlsTableActionHanlder;
import org.eclipse.scout.nls.sdk.ui.action.NlsEntryNewAction;
import org.eclipse.scout.nls.sdk.ui.action.NlsRefreshAction;
import org.eclipse.scout.nls.sdk.ui.action.TranslationFileNewAction;
import org.eclipse.scout.nls.sdk.util.concurrent.UiRunnable;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class NlsTablePage
extends Composite {
    private NlsProject m_nlsProject;
    private NlsTable m_table;
    private Button m_hideInherited;
    private NlsTableModel m_tableModel;
    private P_ProjectListener m_projectListener;
    private final IFile m_nlsFile;

    public NlsTablePage(Composite parent, NlsProject project, IFile nlsFile) {
        super(parent, 0);
        this.m_nlsProject = project;
        this.m_nlsFile = nlsFile;
        this.m_tableModel = new NlsTableModel(project);
        FormToolkit toolkit = new FormToolkit(this.getDisplay());
        Form form = toolkit.createForm((Composite)this);
        form.setText("Translations");
        this.createContent(toolkit, form.getBody());
        this.setLayout((Layout)new FillLayout());
        this.createFormMenu(form.getToolBarManager());
        form.updateToolBar();
        this.attachListeners();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NlsTablePage.this.dettachListeners();
            }
        });
    }

    private void attachListeners() {
        if (this.m_projectListener == null) {
            this.m_projectListener = new P_ProjectListener();
        }
        this.m_nlsProject.addProjectListener(this.m_projectListener);
    }

    private void dettachListeners() {
        if (this.m_projectListener != null) {
            this.m_nlsProject.removeProjectListener(this.m_projectListener);
        }
    }

    private void createFormMenu(IToolBarManager manager) {
        manager.add((IAction)new UpdateReferenceCountAction(this.m_nlsProject, this.m_table, this.m_tableModel));
        manager.add((IAction)new NlsEntryNewAction(true, this.m_nlsProject));
        manager.add((IAction)new TranslationFileNewAction(this.m_table.getShell(), true, this.m_nlsProject));
        manager.add((IAction)new NlsImportAction(this.m_nlsProject, this.m_table.getShell()));
        manager.add((IAction)new NlsExportAction(this.m_nlsProject, this.m_table.getShell()));
    }

    private void createContent(FormToolkit toolkit, Composite parent) {
        Composite rootArea = toolkit.createComposite(parent);
        this.m_hideInherited = toolkit.createButton(rootArea, "hide inherited rows", 32);
        this.m_hideInherited.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NlsTablePage.this.m_table.setHideInherited(NlsTablePage.this.m_hideInherited.getSelection());
            }
        });
        this.m_table = new NlsTable(rootArea, this.m_tableModel);
        this.m_table.setInputValidator(new NlsTableInputValidator(this.m_nlsProject));
        this.m_table.setActionHanlder(new P_TableActionHandler());
        this.m_table.addMenuListener(new P_MenuListener());
        parent.setLayout((Layout)new FillLayout());
        rootArea.setLayout((Layout)new GridLayout(1, true));
        this.m_hideInherited.setLayoutData((Object)new GridData(768));
        this.m_table.setLayoutData(new GridData(1808));
    }

    protected void handleProjectChangedEvnet(NlsProjectEvent event) {
        try {
            this.m_table.setRedraw(false);
            this.handleProjectChangedEvnetInternal(event);
        }
        finally {
            this.m_table.setRedraw(true);
        }
    }

    protected void handleProjectChangedEvnetInternal(NlsProjectEvent event) {
        if (event.isMultiEvent()) {
            NlsProjectEvent[] nlsProjectEventArray = event.getChildEvents();
            int n = nlsProjectEventArray.length;
            int n2 = 0;
            while (n2 < n) {
                NlsProjectEvent e = nlsProjectEventArray[n2];
                this.handleProjectChangedEvnetInternal(e);
                ++n2;
            }
        } else {
            switch (event.getType()) {
                case 1: {
                    this.m_table.getViewer().add((Object)event.getEntry());
                    this.m_table.getViewer().reveal((Object)event.getEntry());
                    this.m_table.getViewer().setSelection((ISelection)new StructuredSelection((Object)event.getEntry()));
                    break;
                }
                case 4: {
                    this.m_table.refresh(event.getEntry());
                    break;
                }
                case 2: {
                    this.m_table.getViewer().remove((Object)event.getEntry());
                    break;
                }
                case 8: {
                    this.m_table.refreshAll(false);
                    break;
                }
                case 16: {
                    this.m_table.refreshAll(true);
                    break;
                }
            }
        }
    }

    private class P_MenuListener
    implements IMenuListener {
        private P_MenuListener() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            IStructuredSelection selection = (IStructuredSelection)NlsTablePage.this.m_table.getViewer().getSelection();
            ArrayList<INlsEntry> entries = new ArrayList<INlsEntry>();
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                entries.add((INlsEntry)it.next());
            }
            MenuManager menuManager = (MenuManager)manager;
            if (entries.size() == 1) {
                Point cursorPos = NlsTablePage.this.m_table.getCursorLocation();
                if (cursorPos.y < 0) {
                    cursorPos.y = -1;
                }
                TableItem row = null;
                if (cursorPos.x >= 0) {
                    row = NlsTablePage.this.m_table.getViewer().getTable().getItem(cursorPos.x);
                }
                this.addSingleSelectMenues(menuManager, (INlsEntry)entries.get(0), cursorPos.y, row.getText(cursorPos.y));
            } else if (entries.size() > 1) {
                this.addMultiSelectMenues(menuManager, entries.toArray(new INlsEntry[entries.size()]));
            }
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new UpdateReferenceCountAction(NlsTablePage.this.m_nlsProject, NlsTablePage.this.m_table, NlsTablePage.this.m_tableModel));
            manager.add((IAction)new TranslationFileNewAction(NlsTablePage.this.m_table.getShell(), true, NlsTablePage.this.m_nlsProject));
        }

        private void addSingleSelectMenues(MenuManager manager, INlsEntry entry, int cursorColumn, String cursorText) {
            if (!(entry instanceof InheritedNlsEntry)) {
                if (cursorColumn == 1) {
                    manager.add((IAction)new Action("Edit key"){

                        public void run() {
                            NlsTablePage.this.m_table.showEditor();
                        }
                    });
                }
                manager.add((IAction)new RemoveAction("Remove " + entry.getKey(), NlsTablePage.this.m_nlsProject, entry));
                manager.add((IContributionItem)new Separator());
            }
            manager.add((IAction)new FindReferencesAction(NlsTablePage.this.m_nlsProject, entry.getKey()));
            manager.add((IAction)new CopyPasteAction("Copy", cursorText, NlsTablePage.this.m_table.getDisplay()));
        }

        private void addMultiSelectMenues(MenuManager manager, INlsEntry[] entries) {
            manager.add((IAction)new RemoveAction("Remove entries", NlsTablePage.this.m_nlsProject, entries));
        }
    }

    private class P_ProjectListener
    implements INlsProjectListener {
        private P_ProjectListener() {
        }

        @Override
        public void notifyProjectChanged(NlsProjectEvent event) {
            if (NlsTablePage.this.m_table != null) {
                NlsTablePage.this.m_table.getDisplay().asyncExec((Runnable)new UiRunnable(new Object[]{event}){

                    @Override
                    public void run() {
                        NlsTablePage.this.handleProjectChangedEvnet((NlsProjectEvent)this.p_args[0]);
                    }
                });
            }
        }
    }

    private class P_TableActionHandler
    implements INlsTableActionHanlder {
        private P_TableActionHandler() {
        }

        @Override
        public void handleRefreshTable(boolean realoadFiles) {
            NlsRefreshAction refreshAciton = new NlsRefreshAction(NlsTablePage.this.m_nlsProject, realoadFiles);
            refreshAciton.run();
            try {
                refreshAciton.join();
            }
            catch (InterruptedException e) {
                NlsCore.logWarning(e);
            }
            NlsTablePage.this.m_nlsProject = refreshAciton.getNlsProject();
        }

        @Override
        public void handleRefreshReferenceCount(String key) {
        }

        public void handleReload() {
        }
    }
}

