/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.dialog.nlsDirChooser;

import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.nlsDirChooser.CompareablePath;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.nlsDirChooser.NlsDirChooserDialogModel;
import org.eclipse.scout.nls.sdk.internal.ui.fields.IInputChangedListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class NlsDirChooserDialog
extends Dialog {
    private String m_title;
    private Tree m_tree;
    private TreeViewer m_viewer;
    private NlsDirChooserDialogModel m_model;
    private IProject m_project;
    private IPath m_selection;
    private List<IInputChangedListener<IPath>> m_listeners = new LinkedList<IInputChangedListener<IPath>>();

    public NlsDirChooserDialog(Shell parentShell, String title, IProject project) {
        super(parentShell);
        this.m_title = title;
        this.m_project = project;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.m_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite rootPane = new Composite(parent, 0);
        this.m_tree = new Tree(rootPane, 4);
        this.m_viewer = new TreeViewer(this.m_tree);
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NlsDirChooserDialog.this.handleSelectionChanged((StructuredSelection)event.getSelection());
            }
        });
        try {
            this.setModel(new NlsDirChooserDialogModel(NlsCore.getProjectGroup(this.m_project)));
        }
        catch (FileNotFoundException e) {
            NlsCore.logWarning(e);
        }
        catch (CoreException e) {
            NlsCore.logWarning(e);
        }
        rootPane.setLayout((Layout)new GridLayout(1, true));
        this.m_tree.setLayoutData((Object)new GridData(300, 300));
        return rootPane;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public IPath openDialog() {
        if (super.open() == 0) {
            return this.m_selection;
        }
        return null;
    }

    private void setModel(NlsDirChooserDialogModel model) {
        this.m_model = model;
        this.m_viewer.setContentProvider((IContentProvider)this.m_model);
        this.m_viewer.setLabelProvider((IBaseLabelProvider)this.m_model);
        this.m_viewer.setInput((Object)this.m_model);
    }

    public void addInputChangeListener(IInputChangedListener<IPath> listener) {
        this.m_listeners.add(listener);
    }

    public void removeInputChangeListener(IInputChangedListener<IPath> listener) {
        this.m_listeners.remove(listener);
    }

    private void handleSelectionChanged(StructuredSelection selection) {
        if (selection.getFirstElement() != null) {
            IPath path = ((CompareablePath)selection.getFirstElement()).getPath();
            this.getButton(0).setEnabled(true);
            this.m_selection = path;
            for (IInputChangedListener<IPath> listener : this.m_listeners) {
                listener.inputChanged(path);
            }
        } else {
            this.getButton(0).setEnabled(false);
        }
    }
}

