/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.dialog.language;

import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.jdt.INlsFolder;
import org.eclipse.scout.nls.sdk.internal.ui.smartfield.ISmartFieldModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class TranslationLocationSmartFieldModel
implements ISmartFieldModel {
    private List<Object> m_folders;
    private IProject m_project;
    private IPath m_path;

    public TranslationLocationSmartFieldModel(IProject project, IPath path) {
        this.m_project = project;
        this.m_path = path;
        this.m_folders = new LinkedList<Object>();
        LinkedList<INlsFolder> folds = new LinkedList<INlsFolder>();
        try {
            List<IProject> projects = NlsCore.getProjectGroup(this.m_project);
            for (IProject toCheck : projects) {
                folds.addAll(NlsCore.getFoldersOfProject(toCheck, this.m_path, true));
            }
            for (INlsFolder folder : folds) {
                this.m_folders.add(folder);
            }
        }
        catch (FileNotFoundException e) {
            NlsCore.logWarning(e);
        }
        catch (CoreException e) {
            NlsCore.logWarning(e);
        }
    }

    @Override
    public Image getImage(Object item) {
        switch (((INlsFolder)item).getType()) {
            case 1: {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
            }
            case 4: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
        }
        return null;
    }

    @Override
    public List<Object> getProposals(String pattern) {
        return this.m_folders;
    }

    @Override
    public String getText(Object item) {
        return String.valueOf(((INlsFolder)item).getFolder().getProject().getName()) + "/" + ((INlsFolder)item).getFolder().getProjectRelativePath();
    }
}

