/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.dialog.importexport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.importexport.NlsImportDialogModel;
import org.eclipse.scout.nls.sdk.internal.ui.fields.FileChooserField;
import org.eclipse.scout.nls.sdk.internal.ui.fields.IInputChangedListener;
import org.eclipse.scout.nls.sdk.util.concurrent.UiRunnable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NlsImportDialog
extends TitleAreaDialog {
    private NlsImportDialogModel m_model;
    private Composite m_rootArea;

    public NlsImportDialog(Shell parentShell, NlsImportDialogModel desc) {
        super(parentShell);
        this.m_model = desc;
        this.m_model.addPropertyChangeListener(new P_PropertyChangedListener());
    }

    public NlsImportDialogModel getModel() {
        return this.m_model;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Import NLS Entries");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.revalidate();
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        this.m_rootArea = new Composite(parent, 0);
        FileChooserField selectCsv = new FileChooserField(this.m_rootArea, "Select File to import");
        selectCsv.setButtonText("Browse...");
        selectCsv.setExtendsionFilter(new String[]{"*.csv; *.properties; *.xls"});
        selectCsv.setLabelText("File:");
        selectCsv.addInputChangedListener(24, new IInputChangedListener<String>(){

            @Override
            public void inputChanged(String input) {
                NlsImportDialog.this.m_model.setImportFile(input);
            }
        });
        this.attachGridData((Control)selectCsv);
        this.m_rootArea.setLayout((Layout)new GridLayout(1, true));
        return this.m_rootArea;
    }

    private void attachGridData(Control c) {
        GridData d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.horizontalAlignment = 4;
        c.setLayoutData((Object)d);
    }

    private void revalidate() {
        if (this.m_model.getImportFile() == null || this.m_model.getImportFile().equals("")) {
            this.setMessage("The import file must be set.", 2);
            return;
        }
        File f = new File(this.m_model.getImportFile());
        if (f.exists()) {
            this.setMessage(null);
            return;
        }
        this.setMessage("The file to import does not exist.", 2);
    }

    private class P_PropertyChangedListener
    implements PropertyChangeListener {
        private P_PropertyChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (NlsImportDialog.this.getContents() != null && !NlsImportDialog.this.getContents().isDisposed()) {
                NlsImportDialog.this.getContents().getDisplay().asyncExec((Runnable)new UiRunnable(new Object[]{evt}){

                    @Override
                    public void run() {
                        P_PropertyChangedListener.this.syncPropertyChange((PropertyChangeEvent)this.p_args[0]);
                    }
                });
            }
        }

        private void syncPropertyChange(PropertyChangeEvent evt) {
            NlsImportDialog.this.revalidate();
        }
    }
}

