/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.search;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.internal.search.AbstractNlsKeySearchRequestor;
import org.eclipse.scout.nls.sdk.internal.search.INlsKeySearchListener;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.search.ui.text.Match;

public class DefaultNlsKeySearchRequestor
extends AbstractNlsKeySearchRequestor {
    private Map<String, List<Match>> m_matches;
    private EventListenerList m_eventListeners = new EventListenerList();

    public DefaultNlsKeySearchRequestor(INlsProject project) {
        super(project);
    }

    public void addFindReferencesListener(INlsKeySearchListener listener) {
        this.m_eventListeners.add(INlsKeySearchListener.class, (EventListener)listener);
    }

    public void removeFindReferencesListener(INlsKeySearchListener listener) {
        this.m_eventListeners.remove(INlsKeySearchListener.class, (EventListener)listener);
    }

    public void beginReporting() {
        this.m_matches = new HashMap<String, List<Match>>();
        INlsKeySearchListener[] iNlsKeySearchListenerArray = (INlsKeySearchListener[])this.m_eventListeners.getListeners(INlsKeySearchListener.class);
        int n = iNlsKeySearchListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            INlsKeySearchListener l = iNlsKeySearchListenerArray[n2];
            l.beginReporting();
            ++n2;
        }
    }

    @Override
    protected void acceptMatch(String statement, SearchMatch match) {
        String nlsKey = this.parseKey(statement, match);
        if (!StringUtility.isNullOrEmpty((String)nlsKey)) {
            Match nlsMatch = new Match((Object)match.getResource(), match.getOffset(), statement.length());
            this.acceptNlsKeyMatch(nlsKey, nlsMatch);
        }
    }

    protected void acceptNlsKeyMatch(String nlsKey, Match match) {
        List<Match> list = this.m_matches.get(nlsKey);
        if (list == null) {
            list = new ArrayList<Match>();
            this.m_matches.put(nlsKey, list);
        }
        list.add(match);
        INlsKeySearchListener[] iNlsKeySearchListenerArray = (INlsKeySearchListener[])this.m_eventListeners.getListeners(INlsKeySearchListener.class);
        int n = iNlsKeySearchListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            INlsKeySearchListener l = iNlsKeySearchListenerArray[n2];
            l.foundMatch(nlsKey, match);
            ++n2;
        }
    }

    public void endReporting() {
        INlsKeySearchListener[] iNlsKeySearchListenerArray = (INlsKeySearchListener[])this.m_eventListeners.getListeners(INlsKeySearchListener.class);
        int n = iNlsKeySearchListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            INlsKeySearchListener l = iNlsKeySearchListenerArray[n2];
            l.endReporting();
            ++n2;
        }
    }

    private String parseKey(String statement, SearchMatch match) {
        Pattern p;
        Matcher m;
        if (match.getElement() instanceof IImportDeclaration) {
            return null;
        }
        String elementName = this.getProject().getNlsType().getType().getElementName();
        int startIndex = statement.indexOf(elementName) + elementName.length();
        if (startIndex > 0 && startIndex < statement.length()) {
            statement = statement.substring(startIndex);
        }
        if ((m = (p = Pattern.compile("\\A\\s*\\.\\s*get\\s*\\(\\s*\\\"([^\\\"]*)\\\"\\s*[\\)\\,\\s]{1}", 8)).matcher(statement)).find()) {
            return statement.substring(m.start(1), m.end(1));
        }
        return null;
    }

    public Match[] getMatches(String nlsKey) {
        List<Match> list = this.m_matches.get(nlsKey);
        if (list == null) {
            list = new ArrayList<Match>();
        }
        return list.toArray(new Match[list.size()]);
    }

    public Map<String, List<Match>> getAllMatches() {
        return new HashMap<String, List<Match>>(this.m_matches);
    }
}

