/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.model.workspace.nlsfile;

import java.beans.PropertyChangeListener;
import java.io.InputStream;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.nls.sdk.model.workspace.INlsResource;
import org.eclipse.scout.nls.sdk.model.workspace.util.PropertyFileReader;

public abstract class AbstractNlsFile
implements INlsResource {
    public static final String PROP_NLS_TYPE_NAME = "nlsTypeName";
    private BasicPropertySupport m_propertySupport = new BasicPropertySupport((Object)this);
    public static final String MANIFEST_CLASS = "Nls-Class";
    private String m_name;

    public AbstractNlsFile(InputStream stream, String name) {
        this.m_name = name;
        this.parseInput(stream, name);
    }

    protected void parseInput(InputStream stream, String name) {
        PropertyFileReader reader = new PropertyFileReader(stream, name);
        this.m_propertySupport.setPropertyString(PROP_NLS_TYPE_NAME, reader.getAttribute(MANIFEST_CLASS));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public String getNlsTypeName() {
        return this.m_propertySupport.getPropertyString(PROP_NLS_TYPE_NAME);
    }
}

