/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.model.workspace.manifest;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.scout.nls.sdk.NlsCore;

public class ManifestElement {
    private String m_value;
    private HashMap<String, String> m_properties = new HashMap();

    public ManifestElement(String value) {
        this.m_value = value;
    }

    ManifestElement() {
    }

    void parse(String text) {
        text = text.replaceAll("\n", "");
        String[] args = text.split(";", 2);
        this.m_value = args[0].trim();
        if (args.length > 1) {
            this.parseProperties(args[1]);
        }
    }

    void parseProperties(String elementText) {
        elementText = elementText.replaceAll("\n", "");
        String[] args = elementText.split(";");
        int i = 0;
        while (i < args.length) {
            this.addProperty(args[i]);
            ++i;
        }
    }

    private void addProperty(String property) {
        String[] args = property.split("=");
        if (args.length != 2) {
            NlsCore.logWarning("can not parse property: " + property + " of value: " + this.m_value);
        }
        Assert.isTrue((args.length == 2 ? 1 : 0) != 0);
        this.m_properties.put(args[0].trim(), args[1].trim());
    }

    public String getValue() {
        return this.m_value;
    }

    public void addProperty(String key, String value) {
        this.m_properties.put(key, value);
    }

    public boolean hasProperties() {
        return this.m_properties.size() > 0;
    }

    public String getProperty(String key) {
        return this.m_properties.get(key);
    }

    public Map<String, String> getPropertyMap() {
        return new HashMap<String, String>(this.m_properties);
    }
}

