/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.marker;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.search.AbstractNlsKeySearchRequestor;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;

public class NlsMarkerBuilder {
    public static final String NLSKEY_MARKER_ID = "org.eclipse.scout.nls.sdk.undefinedNlsKey";
    private final INlsProject m_project;
    private P_NlsKeySearchJob m_pendingJob;
    private Object m_jobLock = new Object();

    public NlsMarkerBuilder(INlsProject project) {
        this.m_project = project;
        JavaCore.addElementChangedListener((IElementChangedListener)new IElementChangedListener(){

            public void elementChanged(ElementChangedEvent event) {
                event.getType();
            }

            public void visitRec(IJavaElementDelta delta) {
                IJavaElementDelta[] iJavaElementDeltaArray = delta.getChangedChildren();
                int n = iJavaElementDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElementDelta d = iJavaElementDeltaArray[n2];
                    this.visitRec(d);
                    ++n2;
                }
                if (delta.getElement().getElementType() == 5) {
                    NlsMarkerBuilder.this.handleElementChanged(delta.getElement());
                }
            }
        });
        LinkedList<IJavaProject> jProjects = new LinkedList<IJavaProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        try {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                if (p.isOpen() && p.hasNature("org.eclipse.jdt.core.javanature") && p.hasNature("org.eclipse.pde.PluginNature")) {
                    jProjects.add(JavaCore.create((IProject)p));
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            NlsCore.logError("Could not create java projects for nls search.");
        }
        this.m_pendingJob = new P_NlsKeySearchJob(new ArrayList<IJavaElement>(jProjects), new P_SearchRequestor(this.getProject()));
        this.m_pendingJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleElementChanged(IJavaElement element) {
        Object object = this.m_jobLock;
        synchronized (object) {
            if (element.getElementType() == 5) {
                ArrayList<IJavaElement> scope = null;
                if (this.m_pendingJob != null && this.m_pendingJob.getState() != 4) {
                    this.m_pendingJob.setCanceled(true);
                    scope = this.m_pendingJob.getSearchScope();
                } else {
                    scope = new ArrayList<IJavaElement>(1);
                    scope.add(element);
                }
                this.m_pendingJob = new P_NlsKeySearchJob(scope, new P_SearchRequestor(this.getProject()));
                this.m_pendingJob.schedule(500L);
            }
        }
    }

    public INlsProject getProject() {
        return this.m_project;
    }

    private class P_NlsKeySearchJob
    extends Job {
        private List<IJavaElement> m_searchScope;
        private boolean m_canceled;
        private final AbstractNlsKeySearchRequestor m_requestor;

        public P_NlsKeySearchJob(List<IJavaElement> searchScope, AbstractNlsKeySearchRequestor requestor) {
            super("update nls Markers");
            this.m_searchScope = searchScope;
            this.m_requestor = requestor;
            this.setPriority(40);
        }

        public void setCanceled(boolean canceled) {
            this.m_canceled = canceled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Object object = NlsMarkerBuilder.this.m_jobLock;
            synchronized (object) {
                if (this.m_canceled) {
                    return Status.CANCEL_STATUS;
                }
                for (IJavaElement e : this.getSearchScope()) {
                    try {
                        e.getResource().deleteMarkers(NlsMarkerBuilder.NLSKEY_MARKER_ID, false, 0);
                    }
                    catch (CoreException e1) {
                        NlsCore.logError("could not delete nls markers.", e1);
                    }
                }
                IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])this.getSearchScope().toArray(new IJavaElement[this.getSearchScope().size()]));
                SearchPattern pattern = SearchPattern.createPattern((IJavaElement)NlsMarkerBuilder.this.getProject().getNlsType().getType(), (int)2);
                try {
                    SearchEngine engine = new SearchEngine();
                    engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)this.m_requestor, monitor);
                }
                catch (CoreException e) {
                    NlsCore.logError("NLS search failed.", e);
                }
                NlsMarkerBuilder.this.m_pendingJob = null;
            }
            return Status.OK_STATUS;
        }

        public List<IJavaElement> getSearchScope() {
            return this.m_searchScope;
        }
    }

    private class P_SearchRequestor
    extends AbstractNlsKeySearchRequestor {
        public P_SearchRequestor(INlsProject project) {
            super(project);
        }

        @Override
        protected void acceptMatch(String statement, SearchMatch match) {
            IType nlsType = this.getProject().getNlsType().getType();
            if (match.getElement() instanceof IImportDeclaration || CompareUtility.equals((Object)match.getResource(), (Object)nlsType.getResource())) {
                return;
            }
            Pattern p = Pattern.compile("\\A((" + nlsType.getElementName() + ")|(" + nlsType.getFullyQualifiedName() + "))\\s*\\.\\s*get\\s*\\(\\s*\\\"([^\\\"]*)\\\"\\s*[\\)\\,\\s]{1}", 8);
            Matcher m = p.matcher(statement);
            if (m.find()) {
                String nlsKey = m.group(4);
                if (this.getProject().getEntry(nlsKey) == null) {
                    try {
                        IMarker errorMarker = match.getResource().createMarker(NlsMarkerBuilder.NLSKEY_MARKER_ID);
                        errorMarker.setAttribute("message", (Object)("The NLS key '" + nlsKey + "' is not defined in the NLS project."));
                        errorMarker.setAttribute("priority", 2);
                        errorMarker.setAttribute("charStart", match.getOffset());
                        errorMarker.setAttribute("charEnd", match.getOffset() + match.getLength());
                        errorMarker.setAttribute("severity", 2);
                    }
                    catch (CoreException e) {
                        NlsCore.logWarning("Could not create NLS marker.", e);
                    }
                }
            } else {
                try {
                    IMarker errorMarker = match.getResource().createMarker(NlsMarkerBuilder.NLSKEY_MARKER_ID);
                    errorMarker.setAttribute("message", (Object)"The nls key should be a plain string. Do not use variables nor method calls to get/callculate a key.");
                    errorMarker.setAttribute("priority", 2);
                    errorMarker.setAttribute("charStart", match.getOffset());
                    errorMarker.setAttribute("charEnd", match.getOffset() + match.getLength());
                    errorMarker.setAttribute("severity", 1);
                }
                catch (CoreException e) {
                    NlsCore.logWarning("Could not create NLS marker.", e);
                }
            }
        }
    }
}

