/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.parsers;

import java.text.ParsePosition;
import java.util.ArrayList;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.parsers.IntoModel;
import org.eclipse.scout.commons.parsers.token.ValueOutputToken;

public class IntoParser {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(IntoParser.class);
    private static final String S_MAP = " \n\t\r";
    private static final String NAME_MAP = "_.0123456789{}ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private String m_str;
    private ParsePosition m_pos;
    private ArrayList<ValueOutputToken> m_intoList = new ArrayList();
    private StringBuffer m_filteredText = new StringBuffer();
    private int m_lastTextIndex;

    public IntoParser(String sqlStatement) {
        this.m_str = sqlStatement.trim();
    }

    public IntoModel parse() {
        this.m_pos = new ParsePosition(0);
        this.parseStatement();
        this.addTextUntil(this.m_str.length());
        if (this.m_pos.getIndex() < this.m_str.length()) {
            LOG.warn("statement not fully parsed (index " + this.m_pos.getIndex() + "): " + this.m_str);
        }
        return new IntoModel(this.m_filteredText.toString(), this.m_intoList.toArray(new ValueOutputToken[0]));
    }

    private boolean parseStatement() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseStatement");
        }
        int index = this.m_pos.getIndex();
        this.parseWhitespace(0);
        if (this.parseTokenList()) {
            return true;
        }
        this.m_pos.setIndex(index);
        return false;
    }

    private boolean parseTokenList() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseTokenList");
        }
        int index = this.m_pos.getIndex();
        if (this.parseToken()) {
            index = this.m_pos.getIndex();
            this.parseWhitespace(0);
            while (this.parseToken()) {
                index = this.m_pos.getIndex();
                this.parseWhitespace(0);
            }
            this.m_pos.setIndex(index);
            return true;
        }
        this.m_pos.setIndex(index);
        return false;
    }

    private boolean parseToken() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseToken");
        }
        return this.parseText() || this.parseInto() || this.parseChar();
    }

    private boolean parseText() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseText");
        }
        int index = this.m_pos.getIndex();
        if (this.matches("'")) {
            while (this.parseTextChar()) {
            }
            if (!this.matches("'")) {
                LOG.warn("expected ' at position " + this.m_pos.getIndex() + " of " + this.m_str);
            }
            return true;
        }
        this.m_pos.setIndex(index);
        return false;
    }

    private boolean parseInto() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseInto");
        }
        int index = this.m_pos.getIndex();
        if (this.matches("into") && this.parseWhitespace(1) && this.parseBindList()) {
            this.addTextUntil(index);
            this.ignoreTextUntil(this.m_pos.getIndex());
            return true;
        }
        this.m_pos.setIndex(index);
        return false;
    }

    private boolean parseBindList() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseBindList");
        }
        int index = this.m_pos.getIndex();
        if (this.parseBind()) {
            index = this.m_pos.getIndex();
            while (this.parseWhitespace(0) && this.matches(",") && this.parseWhitespace(0) && this.parseBind()) {
                index = this.m_pos.getIndex();
            }
            this.m_pos.setIndex(index);
            return true;
        }
        this.m_pos.setIndex(index);
        return false;
    }

    private boolean parseBind() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseBind");
        }
        int index = this.m_pos.getIndex();
        if (this.parseHashBind() || this.parsePlainBind() || this.parseStdBind()) {
            return true;
        }
        this.m_pos.setIndex(index);
        return false;
    }

    private boolean parseHashBind() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseHashBind");
        }
        int index = this.m_pos.getIndex();
        if (this.matches("#") && this.parseName() && this.matches("#")) {
            this.addIntoToken(new ValueOutputToken(this.m_str.substring(index, this.m_pos.getIndex()), this.m_str.substring(index + 1, this.m_pos.getIndex() - 1), true));
            return true;
        }
        this.m_pos.setIndex(index);
        return false;
    }

    private boolean parsePlainBind() {
        if (LOG.isTraceEnabled()) {
            this.trace("parsePlainBind");
        }
        int index = this.m_pos.getIndex();
        if (this.matches("&") && this.parseName() && this.matches("&")) {
            this.addIntoToken(new ValueOutputToken(this.m_str.substring(index, this.m_pos.getIndex()), this.m_str.substring(index + 1, this.m_pos.getIndex() - 1), true));
            return true;
        }
        this.m_pos.setIndex(index);
        return false;
    }

    private boolean parseStdBind() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseStdBind");
        }
        int index = this.m_pos.getIndex();
        if (this.matches(":") && this.parseName()) {
            this.addIntoToken(new ValueOutputToken(this.m_str.substring(index, this.m_pos.getIndex()), this.m_str.substring(index + 1, this.m_pos.getIndex()), true));
            return true;
        }
        this.m_pos.setIndex(index);
        return false;
    }

    private boolean parseName() {
        if (LOG.isTraceEnabled()) {
            this.trace("parseName");
        }
        int index = this.m_pos.getIndex();
        while (this.parseNameChar()) {
        }
        if (this.m_pos.getIndex() > index) {
            return true;
        }
        this.m_pos.setIndex(index);
        return false;
    }

    private boolean parseChar() {
        int index;
        if (LOG.isTraceEnabled()) {
            this.trace("parseChar");
        }
        if ((index = this.m_pos.getIndex()) < this.m_str.length()) {
            this.m_pos.setIndex(index + 1);
            return true;
        }
        return false;
    }

    private boolean matches(String m) {
        int len;
        int index = this.m_pos.getIndex();
        if (index + (len = m.length()) <= this.m_str.length() && m.equalsIgnoreCase(this.m_str.substring(index, index + len))) {
            this.m_pos.setIndex(index + len);
            return true;
        }
        return false;
    }

    private boolean parseTextChar() {
        int len;
        int index;
        if (LOG.isTraceEnabled()) {
            this.trace("parseTextChar");
        }
        if ((index = this.m_pos.getIndex()) < (len = this.m_str.length()) && this.m_str.charAt(index) != '\'') {
            this.m_pos.setIndex(index + 1);
            return true;
        }
        if (index + 1 < len && this.m_str.charAt(index + 1) == '\'') {
            this.m_pos.setIndex(index + 2);
            return true;
        }
        return false;
    }

    private boolean parseNameChar() {
        int len;
        int index;
        if (LOG.isTraceEnabled()) {
            this.trace("parseNameChar");
        }
        if ((index = this.m_pos.getIndex()) < (len = this.m_str.length()) && NAME_MAP.indexOf(this.m_str.charAt(index)) >= 0) {
            this.m_pos.setIndex(index + 1);
            return true;
        }
        return false;
    }

    private boolean parseWhitespace(int nunRequired) {
        int index = this.m_pos.getIndex();
        int len = this.m_str.length();
        int i = index;
        while (i < len && S_MAP.indexOf(this.m_str.charAt(i)) >= 0) {
            ++i;
        }
        if (i - index >= nunRequired) {
            this.m_pos.setIndex(i);
            return true;
        }
        return false;
    }

    private void trace(String s) {
        int len = this.m_str.length();
        int i0 = Math.min(this.m_pos.getIndex(), len - 1);
        int i1 = Math.min(i0 + 32, len);
        LOG.trace("# " + s + " at:" + this.m_str.substring(i0, i1));
    }

    private void addTextUntil(int endIndex) {
        if (endIndex > this.m_lastTextIndex) {
            this.m_filteredText.append(this.m_str.substring(this.m_lastTextIndex, endIndex));
        }
        this.m_lastTextIndex = endIndex;
    }

    private void ignoreTextUntil(int endIndex) {
        this.m_lastTextIndex = endIndex;
    }

    private void addIntoToken(ValueOutputToken t) {
        this.m_intoList.add(t);
    }
}

