/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.beans.tests;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.TreeSet;
import org.eclipse.scout.commons.BeanUtility;
import org.eclipse.scout.commons.TuningUtility;
import org.eclipse.scout.commons.beans.FastBeanInfo;
import org.eclipse.scout.commons.beans.FastPropertyDescriptor;

public class TestBeanUtility {
    public static void main(String[] args) {
        int i = 1;
        while (i <= 5) {
            System.out.println("pass " + i);
            new TestBeanUtility().testBeanInfo();
            TuningUtility.finishAll();
            ++i;
        }
    }

    public void testBeanInfo() {
    }

    protected void testClassTree(Class<?> c, Class<?> stopClass) {
        this.testClass(c, stopClass);
        Class<?>[] classArray = c.getClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> sub = classArray[n2];
            this.testClassTree(sub, stopClass);
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void testClass(Class<?> c, Class<?> stopClass) {
        void var12_18;
        BeanInfo info1;
        if (stopClass != null && !stopClass.isAssignableFrom(c)) {
            return;
        }
        try {
            TuningUtility.startTimer();
            info1 = Introspector.getBeanInfo(c, stopClass);
            TuningUtility.stopTimer("sun", false, true);
        }
        catch (IntrospectionException e) {
            System.out.println("ignoring " + c.getName() + " with stop " + stopClass + ": " + e);
            return;
        }
        TuningUtility.startTimer();
        FastBeanInfo info2 = BeanUtility.getFastBeanInfo(c, stopClass);
        TuningUtility.stopTimer("bsi", false, true);
        StringBuilder b1 = new StringBuilder();
        b1.append("Class: " + info1.getBeanDescriptor().getBeanClass() + "\n");
        int count1 = 0;
        TreeSet<String> set1 = new TreeSet<String>();
        PropertyDescriptor[] propertyDescriptorArray = info1.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor d = propertyDescriptorArray[n2];
            TuningUtility.startTimer();
            d.getName();
            d.getPropertyType();
            d.getReadMethod();
            d.getWriteMethod();
            TuningUtility.stopTimer("sun", false, true);
            if (d.getReadMethod() != null || d.getWriteMethod() != null) {
                ++count1;
                String string = String.valueOf(d.getName()) + ";" + d.getPropertyType() + ";" + TestBeanUtility.dumpMethod(d.getReadMethod()) + ";" + TestBeanUtility.dumpMethod(d.getWriteMethod());
                set1.add(string);
            }
            ++n2;
        }
        b1.append("Count: " + count1 + "\n");
        for (String s : set1) {
            b1.append("Property: " + s + "\n");
        }
        StringBuilder b2 = new StringBuilder();
        b2.append("Class: " + info2.getBeanClass() + "\n");
        int count2 = 0;
        TreeSet<String> set2 = new TreeSet<String>();
        FastPropertyDescriptor[] fastPropertyDescriptorArray = info2.getPropertyDescriptors();
        int n3 = fastPropertyDescriptorArray.length;
        boolean bl = false;
        while (var12_18 < n3) {
            FastPropertyDescriptor d = fastPropertyDescriptorArray[var12_18];
            TuningUtility.startTimer();
            d.getName();
            d.getPropertyType();
            d.getReadMethod();
            d.getWriteMethod();
            TuningUtility.stopTimer("bsi", false, true);
            ++count2;
            String s2 = String.valueOf(d.getName()) + ";" + d.getPropertyType() + ";" + TestBeanUtility.dumpMethod(d.getReadMethod()) + ";" + TestBeanUtility.dumpMethod(d.getWriteMethod());
            set2.add(s2);
            ++var12_18;
        }
        b2.append("Count: " + count2 + "\n");
        for (String s3 : set2) {
            b2.append("Property: " + s3 + "\n");
        }
        if (!b1.toString().equals(b2.toString())) {
            System.out.println("************ ERROR *************");
            System.out.println(info1.getBeanDescriptor().getBeanClass());
            System.out.println(info2.getBeanClass());
            System.out.println(String.valueOf(count1) + "==" + count2);
            TreeSet tmp = new TreeSet(set1);
            set1.removeAll(set2);
            set2.removeAll(tmp);
            for (String string : set1) {
                System.out.println("Set1: " + string);
            }
            for (String string : set2) {
                System.out.println("Set2: " + string);
            }
        }
    }

    private static String dumpMethod(Method m) {
        if (m == null) {
            return null;
        }
        return m.getReturnType() + " " + m.getName() + Arrays.asList(m.getParameterTypes());
    }
}

