/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public class OptimisticLock {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(OptimisticLock.class);
    private int m_lockCount = 0;

    public synchronized boolean acquire() {
        ++this.m_lockCount;
        if (this.m_lockCount == 1) {
            return true;
        }
        if (this.m_lockCount > 10) {
            LOG.warn("potential programming problem; lock was 10 times acquired and not released", new Exception("origin"));
        }
        return false;
    }

    public void release() {
        --this.m_lockCount;
    }

    public boolean isAcquired() {
        return this.m_lockCount > 0;
    }

    public boolean isReleased() {
        return this.m_lockCount <= 0;
    }
}

