/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.UnsupportedEncodingException;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;

public class CharsetSafeMimeMessage
extends MimeMessage {
    private String m_charset;

    public CharsetSafeMimeMessage() {
        super(null);
        this.m_charset = "UTF-8";
    }

    public CharsetSafeMimeMessage(String charset) {
        super(null);
        this.m_charset = charset;
    }

    public void setFrom(Address address) throws MessagingException {
        super.setFrom(this.encodeAddress(address));
    }

    public void addFrom(Address[] addresses) throws MessagingException {
        super.addFrom(this.encodeAddresses(addresses));
    }

    public void addRecipients(Message.RecipientType type, Address[] addresses) throws MessagingException {
        super.addRecipients(type, this.encodeAddresses(addresses));
    }

    public void addRecipients(Message.RecipientType type, String addresses) throws MessagingException {
        if (type == MimeMessage.RecipientType.NEWSGROUPS) {
            super.addRecipients(type, addresses);
        } else {
            this.addRecipients(type, (Address[])InternetAddress.parse((String)addresses));
        }
    }

    public void setDescription(String description) throws MessagingException {
        super.setDescription(description, this.m_charset);
    }

    public void setFrom() throws MessagingException {
        InternetAddress me = InternetAddress.getLocalAddress((Session)this.session);
        if (me == null) {
            throw new MessagingException("No From address");
        }
        this.setFrom(this.encodeAddress((Address)me));
    }

    public void setRecipients(Message.RecipientType type, Address[] addresses) throws MessagingException {
        super.setRecipients(type, this.encodeAddresses(addresses));
    }

    public void setRecipients(Message.RecipientType type, String addresses) throws MessagingException {
        if (type == MimeMessage.RecipientType.NEWSGROUPS) {
            super.setRecipients(type, addresses);
        } else {
            this.setRecipients(type, (Address[])InternetAddress.parse((String)addresses));
        }
    }

    public void setReplyTo(Address[] addresses) throws MessagingException {
        super.setReplyTo(this.encodeAddresses(addresses));
    }

    public void setSender(Address address) throws MessagingException {
        super.setSender(this.encodeAddress(address));
    }

    public void setSubject(String subject) throws MessagingException {
        super.setSubject(subject, this.m_charset);
    }

    public void setText(String text) throws MessagingException {
        super.setText(text, this.m_charset);
    }

    private Address encodeAddress(Address address) throws MessagingException {
        if (address instanceof InternetAddress) {
            InternetAddress inet = (InternetAddress)address;
            if (inet.getPersonal() != null && inet.getPersonal().length() > 0) {
                try {
                    inet.setPersonal(MimeUtility.encodeText((String)inet.getPersonal(), (String)this.m_charset, (String)"Q"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new MessagingException("Unable to encode from address", (Exception)e);
                }
            }
            return inet;
        }
        return address;
    }

    private Address[] encodeAddresses(Address[] addresses) throws MessagingException {
        if (addresses != null && addresses.length > 0) {
            Address[] addressArray = addresses;
            int n = addresses.length;
            int n2 = 0;
            while (n2 < n) {
                Address a = addressArray[n2];
                this.encodeAddress(a);
                ++n2;
            }
        }
        return addresses;
    }
}

