/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.File;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.internal.Activator;

public final class BundleContextUtility {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{([^\\}]+)\\}");

    private BundleContextUtility() {
    }

    public static String resolve(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        String t = s;
        Matcher m = VARIABLE_PATTERN.matcher(t);
        while (m.find()) {
            String key = m.group(1);
            String value = null;
            if (key.equals("workspace_loc")) {
                if (!Platform.inDevelopmentMode() && value == null) {
                    throw new IllegalArgumentException("resolving expression \"" + s + "\": variable ${" + key + "} is not supported in production mode");
                }
                try {
                    String dev = new URL(Activator.getDefault().getBundle().getBundleContext().getProperty("osgi.dev")).getFile();
                    value = new File(dev.substring(0, dev.indexOf("/.metadata/"))).getAbsolutePath();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                value = Activator.getDefault().getBundle().getBundleContext().getProperty(key);
                try {
                    value = new File(new URL(value).getFile()).getAbsolutePath();
                }
                catch (Exception exception) {}
            }
            if (value == null) {
                throw new IllegalArgumentException("resolving expression \"" + s + "\": variable ${" + key + "} is not defined in the bundle context");
            }
            t = String.valueOf(t.substring(0, m.start())) + value + t.substring(m.end());
            m = VARIABLE_PATTERN.matcher(t);
        }
        return t;
    }
}

