/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import intrinsic.flash.text.TextField;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.Display;

public final class TextLayout {
    Font font;
    String text;
    int lineSpacing;
    int ascent;
    int descent;
    int alignment;
    int wrapWidth;
    int orientation;
    int indent;
    boolean justify;
    int[] tabs;
    int[] segments;
    StyleItem[] styles;
    TextField textField;
    static final int BORDER = 2;
    static final int TAB_COUNT = 32;
    final Device device;
    private boolean disposed;

    public Device getDevice() {
        Device result;
        if (this.disposed) {
            SWT.error((int)44);
        }
        if ((result = this.device) == null) {
            result = Display.getCurrent();
        }
        return result;
    }

    public void dispose() {
        if (this.device == null) {
            String msg = "A factory-created resource cannot be disposed.";
            throw new IllegalStateException(msg);
        }
        this.destroy();
        this.disposed = true;
    }

    static Device checkDevice(Device device) {
        Device result = device;
        if (result == null) {
            result = Display.getCurrent();
        }
        if (result == null) {
            SWT.error((int)4);
        }
        return result;
    }

    public TextLayout(Device device) {
        this.device = device;
        this.wrapWidth = -1;
        this.descent = -1;
        this.ascent = -1;
        this.text = "";
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error((int)44);
        }
    }

    void destroy() {
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.tabs = null;
        this.styles = null;
    }

    void computeRuns() {
        this.computeRuns(null);
    }

    int[] computePolyline(int left, int top, int right, int bottom) {
        int length;
        int height = bottom - top;
        int width = 2 * height;
        int peaks = Compatibility.ceil((int)(right - left), (int)width);
        if (peaks == 0 && right - left > 2) {
            peaks = 1;
        }
        if ((length = (2 * peaks + 1) * 2) < 0) {
            return new int[0];
        }
        int[] coordinates = new int[length];
        int i = 0;
        while (i < peaks) {
            int index = 4 * i;
            coordinates[index] = left + width * i;
            coordinates[index + 1] = bottom;
            coordinates[index + 2] = coordinates[index] + width / 2;
            coordinates[index + 3] = top;
            ++i;
        }
        coordinates[length - 2] = left + width * peaks;
        coordinates[length - 1] = bottom;
        return coordinates;
    }

    void computeRuns(GCData data) {
    }

    public void draw(GC gc, int x, int y) {
        this.draw(gc, x, y, -1, -1, null, null);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.draw(gc, x, y, selectionStart, selectionEnd, selectionForeground, selectionBackground, 0);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground, int flags) {
        this.checkLayout();
        if (gc == null) {
            SWT.error((int)4);
        }
        if (gc.isDisposed()) {
            SWT.error((int)5);
        }
        gc.drawText(this.text, x, y, true);
    }

    void freeRuns() {
        this.textField = new TextField();
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns();
        int width = this.text.length() > 0 ? (int)this.textField.textWidth : 0;
        int height = (int)this.textField.textHeight;
        if (this.wrapWidth != -1) {
            width = this.wrapWidth;
        }
        if (this.ascent != -1 && this.descent != -1) {
            height = Math.max(height, this.ascent + this.descent);
        }
        return new Rectangle(0, 0, width, height);
    }

    public Rectangle getBounds(int start, int end) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (length == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (start > end) {
            return new Rectangle(0, 0, 0, 0);
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        start = this.translateOffset(start);
        end = this.translateOffset(end);
        return new Rectangle(0, 0, 10, 10);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    public int getLevel(int offset) {
        this.checkLayout();
        return 0;
    }

    public Rectangle getLineBounds(int lineIndex) {
        this.checkLayout();
        this.computeRuns();
        if (lineIndex < 0 || lineIndex >= this.textField.numLines) {
            SWT.error((int)6);
        }
        if (this.text.length() == 0) {
            return this.getBounds();
        }
        this.textField.getLineOffset(lineIndex);
        return new Rectangle(0, 0, 10, 10);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns();
        return this.textField.numLines;
    }

    public int getLineIndex(int offset) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error((int)6);
        }
        if (offset == length) {
            return this.textField.numLines - 1;
        }
        offset = this.translateOffset(offset);
        return this.textField.getLineIndexOfChar(offset);
    }

    public FontMetrics getLineMetrics(int lineIndex) {
        this.checkLayout();
        this.computeRuns();
        int lineCount = this.getLineCount();
        if (lineIndex < 0 || lineIndex >= lineCount) {
            SWT.error((int)6);
        }
        return null;
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns();
        int[] offsets = new int[this.textField.numLines + 1];
        int i = 0;
        while (i < offsets.length - 1) {
            offsets[i] = this.untranslateOffset(this.textField.getLineOffset(i));
            ++i;
        }
        offsets[offsets.length - 1] = this.text.length();
        return offsets;
    }

    public Point getLocation(int offset, boolean trailing) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error((int)6);
        }
        if (length == 0) {
            return new Point(0, 0);
        }
        offset = this.translateOffset(offset);
        return new Point(0, 0);
    }

    public int getNextOffset(int offset, int movement) {
        this.checkLayout();
        return this._getOffset(offset, movement, true);
    }

    int _getOffset(int offset, int movement, boolean forward) {
        int step;
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error((int)6);
        }
        if (forward && offset == length) {
            return length;
        }
        if (!forward && offset == 0) {
            return 0;
        }
        int n = step = forward ? 1 : -1;
        if ((movement & 1) != 0) {
            return offset + step;
        }
        if ((movement & 2) != 0) {
            return offset + step;
        }
        offset = this.translateOffset(offset);
        int lineIndex = this.textField.getLineIndexOfChar(Math.max(0, Math.min(length - 1, offset)));
        int lineStart = this.textField.getLineOffset(lineIndex);
        int lineLength = this.textField.getLineLength(lineIndex);
        int lineBreak = 0;
        block5: while (lineStart <= offset && offset <= lineStart + lineLength) {
            int lineEnd;
            int newOffset = offset + step;
            int trailing = 0;
            if (forward) {
                if (newOffset + trailing >= lineStart + lineLength - lineBreak) {
                    lineEnd = lineStart + lineLength;
                    if (trailing != 0) {
                        lineEnd -= lineBreak;
                    }
                    return this.untranslateOffset(Math.min(length, lineEnd));
                }
            } else if (newOffset + trailing == lineStart) {
                if (lineIndex == 0) {
                    return 0;
                }
                lineEnd = 0;
                return this.untranslateOffset(Math.max(0, newOffset + trailing - lineEnd));
            }
            offset = newOffset + trailing;
            switch (movement) {
                case 2: {
                    return this.untranslateOffset(offset);
                }
                case 4: 
                case 16: {
                    boolean previousLetterOrDigit;
                    boolean letterOrDigit;
                    if (offset <= 0 || (letterOrDigit = Character.isLetterOrDigit(this.text.charAt(offset))) == (previousLetterOrDigit = Character.isLetterOrDigit(this.text.charAt(offset - 1))) && letterOrDigit || Character.isWhitespace(this.text.charAt(offset))) continue block5;
                    return this.untranslateOffset(offset);
                }
                case 8: {
                    if (offset <= 0) break;
                    boolean isLetterOrDigit = Character.isLetterOrDigit(this.text.charAt(offset));
                    boolean previousLetterOrDigit = Character.isLetterOrDigit(this.text.charAt(offset - 1));
                    if (isLetterOrDigit || !previousLetterOrDigit) continue block5;
                    return this.untranslateOffset(offset);
                }
            }
        }
        return forward ? length : 0;
    }

    public int getOffset(Point point, int[] trailing) {
        this.checkLayout();
        this.computeRuns();
        if (point == null) {
            SWT.error((int)4);
        }
        return this.getOffset(point.x, point.y, trailing);
    }

    public int getOffset(int x, int y, int[] trailing) {
        int length;
        this.checkLayout();
        this.computeRuns();
        if (trailing != null && trailing.length < 1) {
            SWT.error((int)5);
        }
        if ((length = this.text.length()) == 0) {
            return 0;
        }
        double nx = Math.max(2.0, Math.min((double)(x + 2), this.textField.textWidth + 2.0 - 1.0));
        double ny = Math.max(2.0, Math.min((double)(y + 2), this.textField.textHeight + 2.0 - 1.0));
        int offset = this.textField.getCharIndexAtPoint(nx, ny);
        return Math.min(this.untranslateOffset(offset), length - 1);
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    public int getPreviousOffset(int offset, int movement) {
        this.checkLayout();
        return this._getOffset(offset, movement, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] result = new int[this.styles.length * 2];
        int count = 0;
        int i = 0;
        while (i < this.styles.length - 1) {
            if (this.styles[i].style != null) {
                result[count++] = this.styles[i].start;
                result[count++] = this.styles[i + 1].start - 1;
            }
            ++i;
        }
        if (count != result.length) {
            int[] newResult = new int[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public int getSpacing() {
        this.checkLayout();
        return this.lineSpacing;
    }

    public TextStyle getStyle(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (offset < 0 || offset >= length) {
            SWT.error((int)6);
        }
        int i = 1;
        while (i < this.styles.length) {
            if (this.styles[i].start > offset) {
                return this.styles[i - 1].style;
            }
            ++i;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] result = new TextStyle[this.styles.length];
        int count = 0;
        int i = 0;
        while (i < this.styles.length) {
            if (this.styles[i].style != null) {
                result[count++] = this.styles[i].style;
            }
            ++i;
        }
        if (count != result.length) {
            TextStyle[] newResult = new TextStyle[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    public void setAlignment(int alignment) {
        this.checkLayout();
        int mask = 16924672;
        if ((alignment &= mask) == 0) {
            return;
        }
        if ((alignment & 0x4000) != 0) {
            alignment = 16384;
        }
        if ((alignment & 0x20000) != 0) {
            alignment = 131072;
        }
        if (this.alignment == alignment) {
            return;
        }
        this.freeRuns();
        this.alignment = alignment;
    }

    public void setAscent(int ascent) {
        this.checkLayout();
        if (ascent < -1) {
            SWT.error((int)5);
        }
        if (this.ascent == ascent) {
            return;
        }
        this.freeRuns();
        this.ascent = ascent;
    }

    public void setDescent(int descent) {
        this.checkLayout();
        if (descent < -1) {
            SWT.error((int)5);
        }
        if (this.descent == descent) {
            return;
        }
        this.freeRuns();
        this.descent = descent;
    }

    public void setFont(Font font) {
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        if (this.font == font) {
            return;
        }
        if (font != null && font.equals((Object)this.font)) {
            return;
        }
        this.freeRuns();
        this.font = font;
    }

    public void setIndent(int indent) {
        this.checkLayout();
        if (indent < 0) {
            return;
        }
        if (this.indent == indent) {
            return;
        }
        this.freeRuns();
        this.indent = indent;
    }

    public void setJustify(boolean justify) {
        this.checkLayout();
        if (this.justify == justify) {
            return;
        }
        this.freeRuns();
        this.justify = justify;
    }

    public void setOrientation(int orientation) {
        this.checkLayout();
        int mask = 0x6000000;
        if ((orientation &= mask) == 0) {
            return;
        }
        if ((orientation & 0x2000000) != 0) {
            orientation = 0x2000000;
        }
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        this.freeRuns();
    }

    public void setSegments(int[] segments) {
        this.checkLayout();
        if (this.segments == null && segments == null) {
            return;
        }
        if (this.segments != null && segments != null && this.segments.length == segments.length) {
            int i = 0;
            while (i < segments.length) {
                if (this.segments[i] != segments[i]) break;
                ++i;
            }
            if (i == segments.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = segments;
    }

    public void setSpacing(int spacing) {
        this.checkLayout();
        if (spacing < 0) {
            SWT.error((int)5);
        }
        if (this.lineSpacing == spacing) {
            return;
        }
        this.freeRuns();
        this.lineSpacing = spacing;
    }

    public void setStyle(TextStyle style, int start, int end) {
        int modifyStart;
        this.checkLayout();
        int length = this.text.length();
        if (length == 0) {
            return;
        }
        if (start > end) {
            return;
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        int low = -1;
        int high = this.styles.length;
        while (high - low > 1) {
            int index = (high + low) / 2;
            if (this.styles[index + 1].start > start) {
                high = index;
                continue;
            }
            low = index;
        }
        if (high >= 0 && high < this.styles.length) {
            StyleItem item = this.styles[high];
            if (item.start == start && this.styles[high + 1].start - 1 == end && (style == null ? item.style == null : style.equals(item.style))) {
                return;
            }
        }
        this.freeRuns();
        int modifyEnd = modifyStart = high;
        while (modifyEnd < this.styles.length) {
            if (this.styles[modifyEnd + 1].start > end) break;
            ++modifyEnd;
        }
        if (modifyStart == modifyEnd) {
            int styleStart = this.styles[modifyStart].start;
            int styleEnd = this.styles[modifyEnd + 1].start - 1;
            if (styleStart == start && styleEnd == end) {
                this.styles[modifyStart].style = style;
                return;
            }
            if (styleStart != start && styleEnd != end) {
                StyleItem[] newStyles = new StyleItem[this.styles.length + 2];
                System.arraycopy(this.styles, 0, newStyles, 0, modifyStart + 1);
                StyleItem item = new StyleItem();
                item.start = start;
                item.style = style;
                newStyles[modifyStart + 1] = item;
                item = new StyleItem();
                item.start = end + 1;
                item.style = this.styles[modifyStart].style;
                newStyles[modifyStart + 2] = item;
                System.arraycopy(this.styles, modifyEnd + 1, newStyles, modifyEnd + 3, this.styles.length - modifyEnd - 1);
                this.styles = newStyles;
                return;
            }
        }
        if (start == this.styles[modifyStart].start) {
            --modifyStart;
        }
        if (end == this.styles[modifyEnd + 1].start - 1) {
            ++modifyEnd;
        }
        int newLength = this.styles.length + 1 - (modifyEnd - modifyStart - 1);
        StyleItem[] newStyles = new StyleItem[newLength];
        System.arraycopy(this.styles, 0, newStyles, 0, modifyStart + 1);
        StyleItem item = new StyleItem();
        item.start = start;
        item.style = style;
        newStyles[modifyStart + 1] = item;
        this.styles[modifyEnd].start = end + 1;
        System.arraycopy(this.styles, modifyEnd, newStyles, modifyStart + 2, this.styles.length - modifyEnd);
        this.styles = newStyles;
    }

    public void setTabs(int[] tabs) {
        this.checkLayout();
        if (this.tabs == null && tabs == null) {
            return;
        }
        if (this.tabs != null && tabs != null && this.tabs.length == tabs.length) {
            int i = 0;
            while (i < tabs.length) {
                if (this.tabs[i] != tabs[i]) break;
                ++i;
            }
            if (i == tabs.length) {
                return;
            }
        }
        this.freeRuns();
        this.tabs = tabs;
    }

    public void setText(String text) {
        this.checkLayout();
        if (text == null) {
            SWT.error((int)4);
        }
        if (text.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = text;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = text.length();
    }

    public void setWidth(int width) {
        this.checkLayout();
        if (width < -1 || width == 0) {
            SWT.error((int)5);
        }
        if (this.wrapWidth == width) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = width;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {}";
    }

    int translateOffset(int offset) {
        return offset;
    }

    int untranslateOffset(int offset) {
        return offset;
    }

    static class StyleItem {
        TextStyle style;
        int start;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

